/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;

public class FactoryGImageMultiBand {
    public static GImageMultiBand wrap(ImageSingleBand image) {
        return new GSingleToMB(FactoryGImageSingleBand.wrap(image));
    }

    public static GImageMultiBand wrap(MultiSpectral image) {
        return new MS(image);
    }

    public static class GSingleToMB
    implements GImageMultiBand {
        GImageSingleBand sb;

        public GSingleToMB(GImageSingleBand sb) {
            this.sb = sb;
        }

        @Override
        public int getWidth() {
            return this.sb.getWidth();
        }

        @Override
        public int getHeight() {
            return this.sb.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return 1;
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.sb.set(x, y, Float.valueOf(value[0]));
        }

        @Override
        public void get(int x, int y, float[] value) {
            value[0] = this.sb.getF(y * this.sb.getWidth() + x);
        }

        @Override
        public <T extends ImageBase> T getImage() {
            return (T)this.sb.getImage();
        }
    }

    public static class MS
    implements GImageMultiBand {
        MultiSpectral image;

        public MS(MultiSpectral image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return this.image.getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                Object band = this.image.getBand(i);
                GeneralizedImageOps.set(band, x, y, value[i]);
            }
        }

        @Override
        public void get(int x, int y, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                Object band = this.image.getBand(i);
                value[i] = (float)GeneralizedImageOps.get(band, x, y);
            }
        }

        @Override
        public <T extends ImageBase> T getImage() {
            return (T)this.image;
        }
    }
}

