/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_F64;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class FactoryGImageSingleBand {
    public static GImageSingleBand wrap(ImageSingleBand image) {
        if (image.getClass() == ImageUInt8.class) {
            return new GSingle_U8((ImageUInt8)image);
        }
        if (image.getClass() == ImageSInt8.class) {
            return new GSingle_S8((ImageSInt8)image);
        }
        if (image.getClass() == ImageUInt16.class) {
            return new GSingle_U16((ImageUInt16)image);
        }
        if (image.getClass() == ImageSInt16.class) {
            return new GSingle_S16((ImageSInt16)image);
        }
        if (image.getClass() == ImageSInt32.class) {
            return new GSingle_S32((ImageSInt32)image);
        }
        if (image.getClass() == ImageSInt64.class) {
            return new GSingle_I64((ImageSInt64)image);
        }
        if (image.getClass() == ImageFloat32.class) {
            return new GSingle_F32((ImageFloat32)image);
        }
        if (image.getClass() == ImageFloat64.class) {
            return new GSingle_F64((ImageFloat64)image);
        }
        throw new IllegalArgumentException("Unknown image type: " + image.getClass());
    }

    public static GImageSingleBand wrap(ImageSingleBand image, GImageSingleBand output) {
        if (output == null) {
            return FactoryGImageSingleBand.wrap(image);
        }
        if (image.getClass() == ImageUInt8.class) {
            ((GSingle_U8)output).image = (ImageUInt8)image;
        } else if (image.getClass() == ImageSInt8.class) {
            ((GSingle_S8)output).image = (ImageSInt8)image;
        } else if (image.getClass() == ImageUInt16.class) {
            ((GSingle_U16)output).image = (ImageUInt16)image;
        } else if (image.getClass() == ImageSInt16.class) {
            ((GSingle_S16)output).image = (ImageSInt16)image;
        } else if (image.getClass() == ImageSInt32.class) {
            ((GSingle_S32)output).image = (ImageSInt32)image;
        } else if (image.getClass() == ImageSInt64.class) {
            ((GSingle_I64)output).image = (ImageSInt64)image;
        } else if (image.getClass() == ImageFloat32.class) {
            ((GSingle_F32)output).image = (ImageFloat32)image;
        } else if (image.getClass() == ImageFloat64.class) {
            ((GSingle_F64)output).image = (ImageFloat64)image;
        } else {
            throw new IllegalArgumentException("Unknown image type: " + image.getClass());
        }
        return output;
    }

    public static GImageSingleBand wrap(ImageBorder image) {
        if (ImageInteger.class.isAssignableFrom(image.getImage().getClass())) {
            return new Border_I32((ImageBorder_I32)image);
        }
        if (image.getImage().getClass() == ImageFloat32.class) {
            return new Border_F32((ImageBorder_F32)image);
        }
        if (image.getImage().getClass() == ImageFloat64.class) {
            return new Border_F64((ImageBorder_F64)image);
        }
        throw new IllegalArgumentException("Unknown image type: " + image.getClass());
    }

    public static abstract class GSingleBorder<T extends ImageBorder>
    implements GImageSingleBand {
        protected T image;

        public GSingleBorder(T image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getHeight();
        }

        @Override
        public ImageSingleBand getImage() {
            return ((ImageBorder)this.image).getImage();
        }
    }

    public static abstract class GSingleBase<T extends ImageSingleBand>
    implements GImageSingleBand {
        protected T image;

        public GSingleBase(T image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return ((ImageBase)this.image).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)this.image).getHeight();
        }

        @Override
        public ImageSingleBand getImage() {
            return this.image;
        }
    }

    public static abstract class GSingleBaseInt<T extends ImageSingleBand>
    extends GSingleBase<T> {
        public GSingleBaseInt(T image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return false;
        }
    }

    public static class GSingle_F64
    extends GSingleBase<ImageFloat64> {
        public GSingle_F64(ImageFloat64 image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageFloat64)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageFloat64)this.image).set(x, y, num.doubleValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageFloat64)this.image).data[index] = value;
        }

        @Override
        public float getF(int index) {
            return (float)((ImageFloat64)this.image).data[index];
        }
    }

    public static class GSingle_F32
    extends GSingleBase<ImageFloat32> {
        public GSingle_F32(ImageFloat32 image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public Number get(int x, int y) {
            return Float.valueOf(((ImageFloat32)this.image).get(x, y));
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageFloat32)this.image).set(x, y, num.floatValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageFloat32)this.image).data[index] = value;
        }

        @Override
        public float getF(int index) {
            return ((ImageFloat32)this.image).data[index];
        }
    }

    public static class GSingle_I64
    extends GSingleBaseInt<ImageSInt64> {
        public GSingle_I64(ImageSInt64 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageSInt64)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageSInt64)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageSInt64)this.image).data[index] = (long)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageSInt64)this.image).data[index];
        }
    }

    public static class GSingle_S32
    extends GSingleBaseInt<ImageSInt32> {
        public GSingle_S32(ImageSInt32 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageSInt32)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageSInt32)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageSInt32)this.image).data[index] = (short)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageSInt32)this.image).data[index];
        }
    }

    public static class GSingle_S16
    extends GSingleBaseInt<ImageSInt16> {
        public GSingle_S16(ImageSInt16 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageSInt16)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageSInt16)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageSInt16)this.image).data[index] = (short)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageSInt16)this.image).data[index];
        }
    }

    public static class GSingle_U16
    extends GSingleBaseInt<ImageUInt16> {
        public GSingle_U16(ImageUInt16 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageUInt16)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageUInt16)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageUInt16)this.image).data[index] = (short)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageUInt16)this.image).data[index] & 0xFFFF;
        }
    }

    public static class GSingle_S8
    extends GSingleBaseInt<ImageSInt8> {
        public GSingle_S8(ImageSInt8 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageSInt8)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageSInt8)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageSInt8)this.image).data[index] = (byte)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageSInt8)this.image).data[index];
        }
    }

    public static class GSingle_U8
    extends GSingleBaseInt<ImageUInt8> {
        public GSingle_U8(ImageUInt8 image) {
            super(image);
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageUInt8)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageUInt8)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            ((ImageUInt8)this.image).data[index] = (byte)value;
        }

        @Override
        public float getF(int index) {
            return ((ImageUInt8)this.image).data[index] & 0xFF;
        }
    }

    public static class Border_F64
    extends GSingleBorder<ImageBorder_F64> {
        public Border_F64(ImageBorder_F64 image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageBorder_F64)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageBorder_F64)this.image).set(x, y, num.floatValue());
        }

        @Override
        public void set(int index, float value) {
            throw new RuntimeException("Operation not supported by inner data type");
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Operation not supported by inner data type");
        }
    }

    public static class Border_F32
    extends GSingleBorder<ImageBorder_F32> {
        public Border_F32(ImageBorder_F32 image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public Number get(int x, int y) {
            return Float.valueOf(((ImageBorder_F32)this.image).get(x, y));
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageBorder_F32)this.image).set(x, y, num.floatValue());
        }

        @Override
        public void set(int index, float value) {
            throw new RuntimeException("Operation not supported by inner data type");
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Operation not supported by inner data type");
        }
    }

    public static class Border_I32
    extends GSingleBorder<ImageBorder_I32> {
        public Border_I32(ImageBorder_I32 image) {
            super(image);
        }

        @Override
        public boolean isFloatingPoint() {
            return false;
        }

        @Override
        public Number get(int x, int y) {
            return ((ImageBorder_I32)this.image).get(x, y);
        }

        @Override
        public void set(int x, int y, Number num) {
            ((ImageBorder_I32)this.image).set(x, y, num.intValue());
        }

        @Override
        public void set(int index, float value) {
            throw new RuntimeException("Operation not supported by inner data type");
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Operation not supported by inner data type");
        }
    }
}

