/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.List;

class PaintHelper {
    static final int MULTI_MAX_FRACTIONS = 12;
    private static final int MULTI_TEXTURE_SIZE = 16;
    private static final int MULTI_CACHE_SIZE = 256;
    private static final float FULL_TEXEL_Y = 0.00390625f;
    private static final float HALF_TEXEL_Y = 0.001953125f;
    private static final FloatBuffer stopVals = BufferUtil.newFloatBuffer(48);
    private static final ByteBuffer bgraColors = BufferUtil.newByteBuffer(64);
    private static final Image colorsImg = Image.fromByteBgraPreData(bgraColors, 16, 1);
    private static final int[] previousColors = new int[16];
    private static long cacheOffset = -1L;
    private static Texture gradientCacheTexture = null;
    private static final Affine3D scratchXform3D = new Affine3D();

    PaintHelper() {
    }

    static Texture getGradientTexture(ShaderGraphics shaderGraphics, Gradient gradient) {
        if (gradientCacheTexture == null) {
            gradientCacheTexture = shaderGraphics.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DEFAULT, 16, 256);
            gradientCacheTexture.setWrapMode(Texture.WrapMode.CLAMP_TO_EDGE);
            gradientCacheTexture.setLinearFiltering(true);
        }
        return gradientCacheTexture;
    }

    private static void stopsToImage(List<Stop> list, int n) {
        if (n > 12) {
            throw new RuntimeException("Maximum number of gradient stops exceeded (paint uses " + n + " stops, but max is " + 12 + ")");
        }
        bgraColors.clear();
        Color color = null;
        for (int i = 0; i < 16; ++i) {
            Color color2;
            if (i < n) {
                color = color2 = list.get(i).getColor();
            } else {
                color2 = color;
            }
            color2.putBgraPreBytes(bgraColors);
            int n2 = color2.getIntArgbPre();
            if (n2 == previousColors[i]) continue;
            PaintHelper.previousColors[i] = n2;
        }
        bgraColors.rewind();
    }

    private static int initGradient(Gradient gradient) {
        long l = gradient.getGradientOffset();
        if (l >= 0L && l > cacheOffset - 256L) {
            return (int)(l % 256L);
        }
        List<Stop> list = gradient.getStops();
        int n = gradient.getNumStops();
        PaintHelper.stopsToImage(list, n);
        long l2 = ++cacheOffset;
        gradient.setGradientOffset(l2);
        int n2 = (int)(l2 % 256L);
        gradientCacheTexture.update(colorsImg, 0, n2);
        return n2;
    }

    private static void setMultiGradient(Shader shader, Gradient gradient) {
        List<Stop> list = gradient.getStops();
        int n = gradient.getNumStops();
        stopVals.clear();
        for (int i = 0; i < 12; ++i) {
            stopVals.put(i < n ? list.get(i).getOffset() : 0.0f);
            stopVals.put(i < n - 1 ? 1.0f / (list.get(i + 1).getOffset() - list.get(i).getOffset()) : 0.0f);
            stopVals.put(0.0f);
            stopVals.put(0.0f);
        }
        stopVals.rewind();
        shader.setConstants("fractions", stopVals, 0, 12);
        float f = PaintHelper.initGradient(gradient);
        shader.setConstant("offset", f / 256.0f + 0.001953125f);
    }

    static void setLinearGradient(ShaderGraphics shaderGraphics, Shader shader, LinearGradient linearGradient, float f, float f2, float f3, float f4) {
        BaseTransform baseTransform = linearGradient.getGradientTransformNoClone();
        Affine3D affine3D = scratchXform3D;
        shaderGraphics.getPaintShaderTransform(affine3D);
        if (baseTransform != null) {
            affine3D.concatenate(baseTransform);
        }
        float f5 = f + linearGradient.getX1() * f3;
        float f6 = f2 + linearGradient.getY1() * f4;
        float f7 = f + linearGradient.getX2() * f3;
        float f8 = f2 + linearGradient.getY2() * f4;
        float f9 = f5;
        float f10 = f6;
        affine3D.translate(f9, f10);
        f9 = f7 - f9;
        f10 = f8 - f10;
        double d = Math.sqrt(f9 * f9 + f10 * f10);
        affine3D.rotate(Math.atan2(f10, f9));
        affine3D.scale(d, 1.0);
        if (!affine3D.is2D()) {
            double d2;
            double d3;
            double d4;
            BaseTransform baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
            try {
                baseTransform2 = affine3D.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
            }
            PrismCameraImpl prismCameraImpl = shaderGraphics.getCameraNoClone();
            Vec3d vec3d = new Vec3d();
            PickRay pickRay = new PickRay();
            PickRay pickRay2 = PaintHelper.project(0.0f, 0.0f, prismCameraImpl, baseTransform2, pickRay, vec3d, null);
            PickRay pickRay3 = PaintHelper.project(1.0f, 0.0f, prismCameraImpl, baseTransform2, pickRay, vec3d, null);
            PickRay pickRay4 = PaintHelper.project(0.0f, 1.0f, prismCameraImpl, baseTransform2, pickRay, vec3d, null);
            d2 = pickRay3.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            d3 = pickRay4.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            d4 = pickRay2.getDirectionNoClone().x;
            double d5 = pickRay3.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d6 = pickRay4.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d7 = pickRay2.getDirectionNoClone().z;
            shader.setConstant("gradParams", (float)(d2 *= -pickRay2.getOriginNoClone().z), (float)(d3 *= -pickRay2.getOriginNoClone().z), (float)(d4 *= -pickRay2.getOriginNoClone().z), (float)pickRay2.getOriginNoClone().x);
            shader.setConstant("perspVec", (float)d5, (float)d6, (float)d7);
        } else {
            double d8;
            double d9;
            double d10;
            try {
                affine3D.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d10 = 0.0;
                d9 = 0.0;
                d8 = 0.0;
            }
            d8 = (float)affine3D.getMxx();
            d9 = (float)affine3D.getMxy();
            d10 = (float)affine3D.getMxt();
            shader.setConstant("gradParams", (float)d8, (float)d9, (float)d10, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        PaintHelper.setMultiGradient(shader, linearGradient);
    }

    static void setRadialGradient(ShaderGraphics shaderGraphics, Shader shader, RadialGradient radialGradient, float f, float f2, float f3, float f4) {
        BaseTransform baseTransform;
        float f5;
        Affine3D affine3D = scratchXform3D;
        shaderGraphics.getPaintShaderTransform(affine3D);
        float f6 = radialGradient.getRadius();
        float f7 = radialGradient.getCenterX();
        float f8 = radialGradient.getCenterY();
        float f9 = radialGradient.getFocusAngle();
        float f10 = radialGradient.getFocusDistance();
        if (f10 < 0.0f) {
            f10 = -f10;
            f9 += 180.0f;
        }
        f9 = (float)Math.toRadians(f9);
        if (radialGradient.isProportional()) {
            float f11 = f + f3 / 2.0f;
            float f12 = f2 + f4 / 2.0f;
            f5 = Math.min(f3, f4);
            f7 = (f7 - 0.5f) * f5 + f11;
            f8 = (f8 - 0.5f) * f5 + f12;
            if (f3 != f4 && f3 != 0.0f && f4 != 0.0f) {
                affine3D.translate(f11, f12);
                affine3D.scale(f3 / f5, f4 / f5);
                affine3D.translate(-f11, -f12);
            }
            f6 *= f5;
        }
        if ((baseTransform = radialGradient.getGradientTransformNoClone()) != null) {
            affine3D.concatenate(baseTransform);
        }
        affine3D.translate(f7, f8);
        affine3D.rotate(f9);
        affine3D.scale(f6, f6);
        try {
            affine3D.invert();
        }
        catch (Exception exception) {
            affine3D.setToScale(0.0, 0.0, 0.0);
        }
        if (!affine3D.is2D()) {
            PrismCameraImpl prismCameraImpl = shaderGraphics.getCameraNoClone();
            Vec3d vec3d = new Vec3d();
            PickRay pickRay = new PickRay();
            PickRay pickRay2 = PaintHelper.project(0.0f, 0.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            PickRay pickRay3 = PaintHelper.project(1.0f, 0.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            PickRay pickRay4 = PaintHelper.project(0.0f, 1.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            double d = pickRay3.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d2 = pickRay4.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d3 = pickRay2.getDirectionNoClone().x;
            double d4 = pickRay3.getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d5 = pickRay4.getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d6 = pickRay2.getDirectionNoClone().y;
            d *= -pickRay2.getOriginNoClone().z;
            d2 *= -pickRay2.getOriginNoClone().z;
            d3 *= -pickRay2.getOriginNoClone().z;
            d4 *= -pickRay2.getOriginNoClone().z;
            d5 *= -pickRay2.getOriginNoClone().z;
            d6 *= -pickRay2.getOriginNoClone().z;
            double d7 = pickRay3.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d8 = pickRay4.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d9 = pickRay2.getDirectionNoClone().z;
            shader.setConstant("perspVec", (float)d7, (float)d8, (float)d9);
            shader.setConstant("m0", (float)d, (float)d2, (float)d3, (float)pickRay2.getOriginNoClone().x);
            shader.setConstant("m1", (float)d4, (float)d5, (float)d6, (float)pickRay2.getOriginNoClone().y);
        } else {
            float f13 = (float)affine3D.getMxx();
            f5 = (float)affine3D.getMxy();
            float f14 = (float)affine3D.getMxt();
            shader.setConstant("m0", f13, f5, f14, 0.0f);
            float f15 = (float)affine3D.getMyx();
            float f16 = (float)affine3D.getMyy();
            float f17 = (float)affine3D.getMyt();
            shader.setConstant("m1", f15, f16, f17, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        f10 = Math.min(f10, 0.99f);
        float f18 = 1.0f - f10 * f10;
        float f19 = 1.0f / f18;
        shader.setConstant("precalc", f10, f18, f19);
        PaintHelper.setMultiGradient(shader, radialGradient);
    }

    static void setImagePattern(ShaderGraphics shaderGraphics, Shader shader, ImagePattern imagePattern, float f, float f2, float f3, float f4) {
        float f5 = f + imagePattern.getX() * f3;
        float f6 = f2 + imagePattern.getY() * f4;
        float f7 = f5 + imagePattern.getWidth() * f3;
        float f8 = f6 + imagePattern.getHeight() * f4;
        Affine3D affine3D = scratchXform3D;
        shaderGraphics.getPaintShaderTransform(affine3D);
        affine3D.translate(f5, f6);
        affine3D.scale(f7 - f5, f8 - f6);
        try {
            affine3D.invert();
        }
        catch (Exception exception) {
            affine3D.setToScale(0.0, 0.0, 0.0);
        }
        if (!affine3D.is2D()) {
            PrismCameraImpl prismCameraImpl = shaderGraphics.getCameraNoClone();
            Vec3d vec3d = new Vec3d();
            PickRay pickRay = new PickRay();
            PickRay pickRay2 = PaintHelper.project(0.0f, 0.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            PickRay pickRay3 = PaintHelper.project(1.0f, 0.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            PickRay pickRay4 = PaintHelper.project(0.0f, 1.0f, prismCameraImpl, affine3D, pickRay, vec3d, null);
            double d = pickRay3.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d2 = pickRay4.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d3 = pickRay2.getDirectionNoClone().x;
            double d4 = pickRay3.getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d5 = pickRay4.getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d6 = pickRay2.getDirectionNoClone().y;
            d *= -pickRay2.getOriginNoClone().z;
            d2 *= -pickRay2.getOriginNoClone().z;
            d3 *= -pickRay2.getOriginNoClone().z;
            d4 *= -pickRay2.getOriginNoClone().z;
            d5 *= -pickRay2.getOriginNoClone().z;
            d6 *= -pickRay2.getOriginNoClone().z;
            double d7 = pickRay3.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d8 = pickRay4.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d9 = pickRay2.getDirectionNoClone().z;
            shader.setConstant("perspVec", (float)d7, (float)d8, (float)d9);
            shader.setConstant("xParams", (float)d, (float)d2, (float)d3, (float)pickRay2.getOriginNoClone().x);
            shader.setConstant("yParams", (float)d4, (float)d5, (float)d6, (float)pickRay2.getOriginNoClone().y);
        } else {
            float f9 = (float)affine3D.getMxx();
            float f10 = (float)affine3D.getMxy();
            float f11 = (float)affine3D.getMxt();
            shader.setConstant("xParams", f9, f10, f11, 0.0f);
            float f12 = (float)affine3D.getMyx();
            float f13 = (float)affine3D.getMyy();
            float f14 = (float)affine3D.getMyt();
            shader.setConstant("yParams", f12, f13, f14, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        Texture texture = shaderGraphics.getResourceFactory().getCachedTexture(imagePattern.getImage());
        float f15 = texture.getPhysicalWidth();
        float f16 = texture.getPhysicalHeight();
        float f17 = (float)texture.getContentX() / f15;
        float f18 = (float)texture.getContentY() / f16;
        float f19 = (float)texture.getContentWidth() / f15;
        float f20 = (float)texture.getContentHeight() / f16;
        shader.setConstant("content", f17, f18, f19, f20);
    }

    static PickRay project(float f, float f2, PrismCameraImpl prismCameraImpl, BaseTransform baseTransform, PickRay pickRay, Vec3d vec3d, Point2D point2D) {
        pickRay = prismCameraImpl.computePickRay(f, f2, pickRay);
        return pickRay.project(baseTransform, prismCameraImpl instanceof PrismPerspectiveCameraImpl, vec3d, point2D);
    }
}

