/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class EquationsBFGS {
    public static void naiveInverseUpdate(DenseMatrix64F H, DenseMatrix64F s, DenseMatrix64F y) {
        SimpleMatrix _y = new SimpleMatrix(y);
        SimpleMatrix _s = new SimpleMatrix(s);
        SimpleMatrix B = new SimpleMatrix(H);
        SimpleMatrix I = SimpleMatrix.identity((int)_y.getNumElements());
        double p = 1.0 / _y.dot((SimpleBase)_s);
        SimpleMatrix A1 = (SimpleMatrix)I.minus(((SimpleMatrix)_s.mult(_y.transpose())).scale(p));
        SimpleMatrix A2 = (SimpleMatrix)I.minus(((SimpleMatrix)_y.mult(_s.transpose())).scale(p));
        SimpleMatrix SS = (SimpleMatrix)((SimpleMatrix)_s.mult(_s.transpose())).scale(p);
        SimpleMatrix M = (SimpleMatrix)((SimpleMatrix)((SimpleMatrix)A1.mult((SimpleBase)B)).mult((SimpleBase)A2)).plus((SimpleBase)SS);
        H.set((D1Matrix64F)M.getMatrix());
    }

    public static void inverseUpdate(DenseMatrix64F H, DenseMatrix64F s, DenseMatrix64F y, DenseMatrix64F tempV0, DenseMatrix64F tempV1) {
        int N;
        double alpha = VectorVectorMult.innerProdA((D1Matrix64F)y, (D1Matrix64F)H, (D1Matrix64F)y);
        double p = 1.0 / VectorVectorMult.innerProd((D1Matrix64F)s, (D1Matrix64F)y);
        tempV0.numRows = N = H.numCols;
        tempV0.numCols = 1;
        tempV1.numRows = 1;
        tempV1.numCols = N;
        CommonOps.mult((RowD1Matrix64F)H, (RowD1Matrix64F)y, (RowD1Matrix64F)tempV0);
        CommonOps.multTransA((RowD1Matrix64F)y, (RowD1Matrix64F)H, (RowD1Matrix64F)tempV1);
        VectorVectorMult.rank1Update((double)(-p), (DenseMatrix64F)H, (DenseMatrix64F)tempV0, (DenseMatrix64F)s);
        VectorVectorMult.rank1Update((double)(-p), (DenseMatrix64F)H, (DenseMatrix64F)s, (DenseMatrix64F)tempV1);
        VectorVectorMult.rank1Update((double)(p * alpha * p + p), (DenseMatrix64F)H, (DenseMatrix64F)s, (DenseMatrix64F)s);
    }

    public static void conjugateUpdateD(DenseMatrix64F C, DenseMatrix64F d, DenseMatrix64F y, double step, DenseMatrix64F tempV0) {
        DenseMatrix64F z = tempV0;
        CommonOps.multTransA((RowD1Matrix64F)C, (RowD1Matrix64F)y, (RowD1Matrix64F)z);
        double dTd = VectorVectorMult.innerProd((D1Matrix64F)d, (D1Matrix64F)d);
        double dTz = VectorVectorMult.innerProd((D1Matrix64F)d, (D1Matrix64F)z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }

    public static void conjugateUpdateC(DenseMatrix64F C, DenseMatrix64F d, DenseMatrix64F y, double step, DenseMatrix64F tempV0, DenseMatrix64F tempV1) {
        DenseMatrix64F z = tempV0;
        DenseMatrix64F d_bar = tempV1;
        CommonOps.multTransA((RowD1Matrix64F)C, (RowD1Matrix64F)y, (RowD1Matrix64F)z);
        double dTd = VectorVectorMult.innerProd((D1Matrix64F)d, (D1Matrix64F)d);
        double dTz = VectorVectorMult.innerProd((D1Matrix64F)d, (D1Matrix64F)z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }
}

