/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.CoupledJacobian;
import org.ddogleg.optimization.impl.TrustRegionStep;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class TrustRegionLeastSquares {
    private TrustRegionStep stepAlg;
    private double fx;
    private double fx_prev;
    private DenseMatrix64F J = new DenseMatrix64F(1, 1);
    private DenseMatrix64F x = new DenseMatrix64F(1, 1);
    private DenseMatrix64F candidate = new DenseMatrix64F(1, 1);
    private DenseMatrix64F xdelta = new DenseMatrix64F(1, 1);
    private DenseMatrix64F residuals = new DenseMatrix64F(1, 1);
    private DenseMatrix64F candidateResiduals = new DenseMatrix64F(1, 1);
    private DenseMatrix64F gradient = new DenseMatrix64F(1, 1);
    private double regionRadius;
    private double maxRadius;
    private double gtol;
    private double ftol;
    private CoupledJacobian function;
    private int mode = 0;
    private boolean updated;

    public TrustRegionLeastSquares(double maxRadius, TrustRegionStep stepAlg) {
        this.maxRadius = maxRadius;
        this.stepAlg = stepAlg;
    }

    public void setFunction(CoupledJacobian function) {
        this.function = function;
        int m = function.getM();
        int n = function.getN();
        this.x.reshape(n, 1);
        this.candidate.reshape(n, 1);
        this.xdelta.reshape(n, 1);
        this.J.reshape(m, n);
        this.residuals.reshape(m, 1);
        this.candidateResiduals.reshape(m, 1);
        this.gradient.reshape(n, 1);
        this.stepAlg.init(n, m);
    }

    public void setConvergence(double ftol, double gtol) {
        if (ftol < 0.0 || ftol >= 1.0) {
            throw new IllegalArgumentException("0 <= ftol < 1");
        }
        if (gtol < 0.0) {
            throw new IllegalArgumentException("gtol < 0 ");
        }
        this.gtol = gtol;
        this.ftol = ftol;
    }

    public void initialize(double[] initial) {
        System.arraycopy(initial, 0, this.x.data, 0, this.x.numRows);
        this.function.setInput(this.x.data);
        this.function.computeFunctions(this.residuals.data);
        this.fx = this.cost(this.residuals);
        this.fx_prev = 0.0;
        this.regionRadius = this.maxRadius;
        this.mode = 0;
    }

    public boolean iterate() {
        this.updated = false;
        if (this.mode == 0) {
            this.function.computeJacobian(this.J.data);
            CommonOps.multTransA((RowD1Matrix64F)this.J, (RowD1Matrix64F)this.residuals, (RowD1Matrix64F)this.gradient);
            double gnorm = CommonOps.elementMaxAbs((D1Matrix64F)this.gradient);
            if (gnorm <= this.gtol || Math.abs(this.fx - this.fx_prev) <= this.ftol * Math.max(this.fx, this.fx_prev)) {
                this.mode = 2;
                return true;
            }
            this.stepAlg.setInputs(this.x, this.residuals, this.J, this.gradient, this.fx);
            this.mode = 1;
            this.fx_prev = this.fx;
        } else if (this.mode == 1) {
            if (this.findStep()) {
                this.mode = 0;
            }
        } else {
            throw new RuntimeException("Has already converged");
        }
        return false;
    }

    private boolean findStep() {
        boolean acceptCandidate;
        this.stepAlg.computeStep(this.regionRadius, this.xdelta);
        CommonOps.add((D1Matrix64F)this.x, (D1Matrix64F)this.xdelta, (D1Matrix64F)this.candidate);
        this.function.setInput(this.candidate.data);
        this.function.computeFunctions(this.candidateResiduals.data);
        double fxp = this.cost(this.candidateResiduals);
        double actual = this.fx - fxp;
        double predicted = this.stepAlg.predictedReduction();
        if (actual == 0.0 || predicted == 0.0) {
            acceptCandidate = true;
        } else {
            double reductionRatio = actual / predicted;
            if (reductionRatio < 0.25) {
                this.regionRadius = 0.5 * this.regionRadius;
            } else if (reductionRatio > 0.75) {
                double r = NormOps.normF((D1Matrix64F)this.xdelta);
                this.regionRadius = Math.max(this.regionRadius, 3.0 * r);
            }
            boolean bl = acceptCandidate = reductionRatio > 0.0;
        }
        if (acceptCandidate) {
            DenseMatrix64F temp = this.x;
            this.x = this.candidate;
            this.candidate = temp;
            temp = this.candidateResiduals;
            this.candidateResiduals = this.residuals;
            this.residuals = temp;
            this.fx = fxp;
            this.updated = true;
        }
        return acceptCandidate;
    }

    private double cost(DenseMatrix64F residuals) {
        return 0.5 * SpecializedOps.elementSumSq((D1Matrix64F)residuals);
    }

    public double[] getParameters() {
        return this.x.data;
    }

    public double getError() {
        return this.fx;
    }

    public boolean isConverged() {
        return this.mode == 2;
    }

    public boolean isUpdated() {
        return this.updated;
    }
}

