/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.impl.SturmSequence;

public class FindRealRootsSturm {
    private SturmSequence sturm;
    private double[] roots;
    private int numRoots;
    private double searchRadius;
    private double boundTolerance;
    private int maxBoundIterations;
    private int maxRefineIterations;
    Bound region0 = new Bound();
    Bound region1 = new Bound();
    Bound region2 = new Bound();

    public FindRealRootsSturm(int maxCoefficients, double searchRadius, double boundTolerance, int maxBoundIterations, int maxRefineIterations) {
        if (Double.isInfinite(searchRadius)) {
            searchRadius = -1.0;
        }
        this.sturm = new SturmSequence(maxCoefficients);
        this.searchRadius = searchRadius;
        this.boundTolerance = boundTolerance;
        this.maxBoundIterations = maxBoundIterations;
        this.maxRefineIterations = maxRefineIterations;
        this.roots = new double[maxCoefficients];
    }

    public double[] getRoots() {
        return this.roots;
    }

    public int getNumberOfRoots() {
        return this.numRoots;
    }

    public int getMaxRoots() {
        return this.roots.length;
    }

    public void process(Polynomial poly) {
        this.sturm.initialize(poly);
        this.numRoots = this.searchRadius <= 0.0 ? this.sturm.countRealRoots(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) : this.sturm.countRealRoots(-this.searchRadius, this.searchRadius);
        if (this.numRoots == 0) {
            return;
        }
        if (this.searchRadius <= 0.0) {
            this.handleAllRoots();
        } else {
            this.boundEachRoot(-this.searchRadius, this.searchRadius, 0, this.numRoots);
        }
        for (int i = 0; i < this.numRoots; ++i) {
            this.roots[i] = PolynomialOps.refineRoot(poly, this.roots[i], this.maxRefineIterations);
        }
    }

    private void handleAllRoots() {
        int N;
        double width;
        int target;
        int totalFound = 0;
        double r = 1.0;
        int iter = 0;
        while (iter++ < this.maxBoundIterations && (totalFound = this.sturm.countRealRoots(-r, r)) <= 0) {
            r = 2.0 * r * r;
        }
        if (Double.isInfinite(r)) {
            throw new RuntimeException("r is infinite");
        }
        if (iter >= this.maxBoundIterations) {
            throw new RuntimeException("Too many iterations when searching center region");
        }
        this.boundEachRoot(-r, r, 0, totalFound);
        if (totalFound < this.numRoots && (target = this.sturm.countRealRoots(Double.NEGATIVE_INFINITY, -r)) > 0) {
            double upper = -r;
            width = r;
            iter = 0;
            while (iter < this.maxBoundIterations && target > 0) {
                N = this.sturm.countRealRoots(upper - width, upper);
                if (N != 0) {
                    this.boundEachRoot(upper - width, upper, totalFound, N);
                    target -= N;
                    totalFound += N;
                }
                upper -= width;
                width = 2.0 * width * width;
            }
            if (iter >= this.maxBoundIterations) {
                throw new RuntimeException("Too many iterations when searching lower region");
            }
        }
        if (totalFound < this.numRoots && (target = this.sturm.countRealRoots(r, Double.POSITIVE_INFINITY)) > 0) {
            double lower = r;
            width = r;
            iter = 0;
            while (iter < this.maxBoundIterations && target > 0) {
                N = this.sturm.countRealRoots(lower, lower + width);
                if (N != 0) {
                    this.boundEachRoot(lower, lower + width, totalFound, N);
                    target -= N;
                    totalFound += N;
                }
                lower += width;
                width = 2.0 * width * width;
            }
            if (iter >= this.maxBoundIterations) {
                throw new RuntimeException("Too many iterations when searching upper region");
            }
        }
    }

    private void bisectionRoot(double l, double u, int index) {
        int iter = 0;
        while (u - l > this.boundTolerance * Math.abs(l) && iter++ < this.maxBoundIterations) {
            double m = (l + u) / 2.0;
            int numRoots = this.sturm.countRealRoots(m, u);
            if (numRoots == 1) {
                l = m;
                continue;
            }
            u = m;
        }
        this.roots[index] = (l + u) / 2.0;
    }

    private void boundEachRoot(double l, double u, int startIndex, int numRoots) {
        int iter = 0;
        double allUpper = u;
        int root = 0;
        int lastFound = 0;
        double lastUpper = u;
        while (root < numRoots && iter++ < this.maxBoundIterations) {
            double m = (l + u) / 2.0;
            int found = this.sturm.countRealRoots(l, m);
            if (found == 0) {
                l = m;
            } else if (found == 1) {
                this.bisectionRoot(l, m, startIndex + root++);
                l = m;
                u = lastUpper = allUpper;
                lastFound = 0;
                iter = 0;
            } else {
                lastFound = found;
                lastUpper = u = m;
            }
            if (l == u) {
                throw new RuntimeException("Lower and upper bounds are the same");
            }
            if (iter < this.maxBoundIterations) continue;
            for (int i = 0; i < lastFound; ++i) {
                this.roots[startIndex + root++] = m;
            }
            l = lastUpper;
            u = lastUpper = allUpper;
            lastFound = 0;
            iter = 0;
        }
        if (iter >= this.maxBoundIterations) {
            throw new RuntimeException("Too many iterations finding upper and lower bounds");
        }
    }

    private static class Bound {
        double l;
        double u;

        private Bound() {
        }
    }
}

