/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_I32 {
    public int[] data;
    public int size;

    public GrowQueue_I32(int maxSize) {
        this.data = new int[maxSize];
        this.size = 0;
    }

    public GrowQueue_I32() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I32 queue) {
        if (this.size + queue.size > this.data.length) {
            int[] temp = new int[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void add(int value) {
        this.push(value);
    }

    public void push(int val) {
        if (this.size == this.data.length) {
            int[] temp = new int[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void removeHead(int total) {
        for (int j = total; j < this.size; ++j) {
            this.data[j - total] = this.data[j];
        }
        this.size -= total;
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new int[size];
        }
        this.size = size;
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new int[size];
        }
    }

    public void fill(int value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public int size() {
        return this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }
}

