/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.common;

import com.amazon.epub.reader.plat.PlatformFactory;
import com.amazon.epub.reader.util.KprProcessBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class CommonUtils {
    private static final Logger LOG = Logger.getLogger(CommonUtils.class.getName());
    private static final String LOG_DIR = ".kindle";
    private static final String DOWNLOAD_DIR = System.getProperty("user.dir") + File.separator;
    public static final String PREVIEWR_LOCK_FILE = DOWNLOAD_DIR + "previewer.lock";
    public static final String UPDATE_FILE_NAME = DOWNLOAD_DIR + "update.jar";
    public static final String UPDATE_EXE_FILE_NAME_WIN = DOWNLOAD_DIR + "KindlePreviewer.exe";
    public static final String UPDATE_EXE_FILE_NAME_MAC = DOWNLOAD_DIR + "Kindle Previewer";
    public static final String DOWNLOAD_EXE_FILE_NAME_MAC = DOWNLOAD_DIR + "KindlePreviewer";
    public static final String UPDATE_COMPLETE_FILE = DOWNLOAD_DIR + "update.complete";
    public static final String TRANSCODE_LOCK_FILE = "transcode.lock";
    private static final int MAX_FILE_COPY_BUFFER_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName) {
        InputStream ip = CommonUtils.class.getClassLoader().getResourceAsStream(fileName);
        if (ip == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(ip);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, " Unable to load properties file ", e);
            Properties properties = null;
            return properties;
        }
        finally {
            if (ip != null) {
                try {
                    ip.close();
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, " Error while closing the stream", e);
                }
            }
        }
        return props;
    }

    public static boolean deleteDirectory(String dirName) {
        if (dirName == null) {
            return false;
        }
        File dirFile = new File(dirName);
        if (!dirFile.exists()) {
            return false;
        }
        if (!CommonUtils.deleteDirectoryWithoutLogging(dirFile)) {
            LOG.log(Level.SEVERE, "Error while deleting directory");
            return false;
        }
        return true;
    }

    private static boolean deleteDirectoryWithoutLogging(File dirFile) {
        if (dirFile == null || !dirFile.exists()) {
            return false;
        }
        File[] tempFiles = dirFile.listFiles();
        if (tempFiles != null) {
            for (int i = 0; i < tempFiles.length; ++i) {
                if (tempFiles[i].isDirectory()) {
                    CommonUtils.deleteDirectoryWithoutLogging(new File(tempFiles[i].getAbsolutePath()));
                    continue;
                }
                if (tempFiles[i].delete()) continue;
                return false;
            }
        }
        return dirFile.delete();
    }

    public static boolean deleteDirectoryOnExit(String dirName) {
        if (!CommonUtils.deleteDirectoryWithoutLoggingOnExit(dirName)) {
            LOG.log(Level.SEVERE, "Error while deleting directory on Exit " + dirName);
            return false;
        }
        return true;
    }

    private static boolean deleteDirectoryWithoutLoggingOnExit(String dirName) {
        if (dirName == null) {
            return false;
        }
        File dirFile = new File(dirName);
        if (!dirFile.exists()) {
            return false;
        }
        dirFile.deleteOnExit();
        File[] tempFiles = dirFile.listFiles();
        if (tempFiles != null) {
            for (int i = 0; i < tempFiles.length; ++i) {
                if (tempFiles[i].isDirectory()) {
                    CommonUtils.deleteDirectoryWithoutLoggingOnExit(tempFiles[i].getAbsolutePath());
                    continue;
                }
                tempFiles[i].deleteOnExit();
            }
        }
        return true;
    }

    public static synchronized FileLock getFileLock(String fileName, boolean isShared) {
        FileLock lock = null;
        File file = new File(fileName);
        try {
            RandomAccessFile rFile = new RandomAccessFile(file, "rw");
            FileChannel channel = rFile.getChannel();
            lock = channel.tryLock(0L, Long.MAX_VALUE, isShared);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while aquiring file lock for file ", e);
        }
        return lock;
    }

    public static synchronized void releaseFileLock(FileLock lock, String filename) {
        try {
            lock.release();
            lock.channel().close();
            CommonUtils.deleteFile(filename);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error while releaseing lock ", e);
        }
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (!file.delete()) {
            LOG.log(Level.SEVERE, "Error while deleting file ");
            return false;
        }
        return true;
    }

    public static Thread createAndRunDaemonThread(Runnable runnable) {
        Thread thread = null;
        if (runnable != null) {
            thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
        }
        return thread;
    }

    public static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, " exception while waiting ", e);
        }
    }

    public static String getFileExt(String filename) {
        String fileExt = filename.substring(filename.lastIndexOf(46) + 1);
        return fileExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String inFile, String outFile) {
        File inputFile = new File(inFile);
        File outputFile = new File(outFile);
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            if (outputFile.exists()) {
                if (!outputFile.isDirectory()) {
                    CommonUtils.deleteFile(outFile);
                } else {
                    LOG.log(Level.SEVERE, "Output File is a directory ");
                    boolean bl = false;
                    return bl;
                }
            }
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            int length = (int)(inputFile.length() > 0x100000L ? 0x100000L : inputFile.length());
            byte[] buf = new byte[length];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.SEVERE, "File is not found in given path", e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception while copying the file from source to destination", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Exception while copying the file from source to destination", e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Exception while copying the file from source to destination", e);
                }
            }
        }
        return true;
    }

    public static Thread copyFileInThread(final String inFile, final String outFile) {
        return new Thread(new Runnable(){

            public void run() {
                CommonUtils.copyFile(inFile, outFile);
            }
        });
    }

    public static boolean canConnectToURL(URL u) {
        try {
            URLConnection uc = u.openConnection();
            uc.connect();
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Trying can Connect To URL retruned error");
            return false;
        }
    }

    public static boolean checkForContentLengthFromURL(URL u, File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            URLConnection uc = u.openConnection();
            uc.connect();
            if ((long)uc.getContentLength() == file.length()) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "can Connect To URL retruned error", e);
            return false;
        }
        return false;
    }

    public static boolean writeByteArrayToFile(String filePath, byte[] buffer) {
        if (buffer != null && filePath != null) {
            File file = new File(filePath);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            try {
                FileOutputStream fos = new FileOutputStream(filePath);
                fos.write(buffer);
                fos.close();
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.SEVERE, "writing touch image failed", e);
                return false;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "writing touch image failed", e);
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean checkFileExt(String fileName, String ext) {
        return CommonUtils.getFileExt(fileName).equals(ext);
    }

    public static String copyAndGetFileName(String fileName, String destDir) {
        String copiedFile = destDir + File.separator + CommonUtils.getLocalFileName(fileName);
        Thread copyThread = CommonUtils.copyFileInThread(fileName, copiedFile);
        copyThread.start();
        while (copyThread.isAlive()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return copiedFile;
    }

    private static String getLocalFileName(String fileName) {
        String DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        Calendar calendar = Calendar.getInstance();
        String fileExt = CommonUtils.getFileExt(fileName).toLowerCase();
        if (CommonUtils.checkFileExt(fileName, "prc")) {
            fileExt = "mobi";
        }
        return sdf.format(calendar.getTime()) + "." + fileExt;
    }

    public static void openUrl(String url) {
        List command = PlatformFactory.getPlatform().openURLCommand(url);
        KprProcessBuilder procBuilder = new KprProcessBuilder(command, false);
        Process proc = null;
        try {
            proc = procBuilder.start();
            proc.waitFor();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unexpected Error While Executing exec Command", e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Interrupted Exception", e);
        }
    }

    static {
        Logger logger = Logger.getLogger("");
        try {
            File logDir = new File(System.getProperty("user.home") + File.separator + LOG_DIR);
            if (!logDir.exists()) {
                if (!logDir.isDirectory()) {
                    logDir.delete();
                }
                logDir.mkdir();
            }
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                logger.removeHandler(handlers[i]);
            }
            FileHandler fh = new FileHandler("%h/.kindle/kindlepreview.log", 2000000, 5, true);
            fh.setLevel(Level.INFO);
            fh.setEncoding("UTF-8");
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

