/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.androidsdk;

import com.amazon.ebook.androidsdk.AndroidSDKBookMetadata;
import com.amazon.ebook.androidsdk.AndroidSDKException;
import com.amazon.ebook.androidsdk.AndroidSDKGuideItem;
import com.amazon.ebook.androidsdk.AndroidSDKResource;
import com.amazon.ebook.androidsdk.BookMetadata;
import com.amazon.ebook.androidsdk.GuideItem;
import com.amazon.ebook.androidsdk.MetadataProvider;
import com.amazon.ebook.androidsdk.Resource;

class AndroidSDKMetadataProvider
implements MetadataProvider {
    private long handle;
    private String mobifilePath;
    private static final int GUIDEITEM_LIST_HANDLE_INDEX = 0;
    private static final int GUIDEITEM_LIST_COUNT_INDEX = 1;

    public AndroidSDKMetadataProvider() {
        this.init();
    }

    public BookMetadata getBookMetadata() throws AndroidSDKException {
        AndroidSDKBookMetadata bookmetadatainst = new AndroidSDKBookMetadata();
        this.getbookmetadata(bookmetadatainst);
        return bookmetadatainst;
    }

    public GuideItem[] getGuideItems() throws AndroidSDKException {
        long[] guideItemMetadata = new long[2];
        this.loadallguideitem(guideItemMetadata);
        long guideItemHandle = guideItemMetadata[0];
        long totalGuideItem = guideItemMetadata[1];
        GuideItem[] guideItems = new AndroidSDKGuideItem[(int)totalGuideItem];
        int i = 0;
        while ((long)i < totalGuideItem) {
            guideItems[i] = new AndroidSDKGuideItem();
            ++i;
        }
        this.copyguideitems((AndroidSDKGuideItem[])guideItems, guideItemHandle);
        this.deleteallguideitem(guideItemHandle);
        return guideItems;
    }

    public GuideItem getGuideItem(String type) throws AndroidSDKException {
        AndroidSDKGuideItem guideItem = new AndroidSDKGuideItem();
        this.getguideitem(guideItem, type);
        return guideItem;
    }

    public boolean hasBigCoverArt() {
        return this.hasbigcoverart();
    }

    public Resource getBigCoverArt() throws AndroidSDKException {
        AndroidSDKResource coverImage = new AndroidSDKResource();
        this.getbigcoverart(coverImage);
        return coverImage;
    }

    public Resource getCoverArt() throws AndroidSDKException {
        AndroidSDKResource thumbnail = new AndroidSDKResource();
        this.getcoverart(thumbnail);
        return thumbnail;
    }

    public String getExtraHeaderValueAsString(int key) throws AndroidSDKException {
        return this.getextraheaderasstring(key);
    }

    public int getExtraHeaderValueAsUINT32(int key) throws AndroidSDKException {
        return this.getextraheaderasuint32(key);
    }

    public Resource getExtraHeaderValueAsResource(int key) throws AndroidSDKException {
        AndroidSDKResource resource = new AndroidSDKResource();
        this.getextraheaderasresource(resource, key);
        return resource;
    }

    public void dispose() {
        this.deletemetadataprovider();
        this.init();
    }

    protected void finalize() {
        this.dispose();
    }

    private void init() {
        this.handle = 0L;
    }

    private native void loadallguideitem(long[] var1);

    private native void copyguideitems(AndroidSDKGuideItem[] var1, long var2);

    private native void deleteallguideitem(long var1);

    private native void getguideitem(AndroidSDKGuideItem var1, String var2);

    private native void getbookmetadata(AndroidSDKBookMetadata var1);

    private native String getextraheaderasstring(int var1);

    private native int getextraheaderasuint32(int var1);

    private native void getextraheaderasresource(AndroidSDKResource var1, int var2);

    private native void deletemetadataprovider();

    private native boolean hasbigcoverart();

    private native void getbigcoverart(AndroidSDKResource var1);

    private native void getcoverart(AndroidSDKResource var1);
}

