/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.androidsdk;

import com.amazon.ebook.androidsdk.AndroidSDKException;
import com.amazon.ebook.androidsdk.AndroidSDKResource;
import com.amazon.ebook.androidsdk.Resource;
import com.amazon.ebook.androidsdk.TableOfContentsEntry;

class AndroidSDKTableOfContentsEntry
implements TableOfContentsEntry {
    public static int TOC_PARENT_NOT_FOUND = 36;
    public static int TOC_FIRST_CHILD_NOT_FOUND = 37;
    public static int TOC_LAST_CHILD_NOT_FOUND = 38;
    public static int TOC_NEXT_ENTRY_NOT_FOUND = 45;
    public static int TOC_PREV_ENTRY_NOT_FOUND = 46;
    private long handle;
    private static final int RESOURCE_LIST_HANDLE_INDEX = 0;
    private static final int RESOURCE_LIST_COUNT_INDEX = 1;

    public AndroidSDKTableOfContentsEntry() {
        this.init();
    }

    public int getLevel() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        return this.getlevel(this.handle);
    }

    public int getLength() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        return this.getlength(this.handle);
    }

    public int getPosition() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        return this.getposition(this.handle);
    }

    public String getNodeClass() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        return this.getnodeclass(this.handle);
    }

    public String getLabel() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        return this.getlabel(this.handle);
    }

    public String[] getAuthors() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        String[] authors = this.getauthors(this.handle);
        return authors;
    }

    public String[] getDescription() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        String[] descriptions = this.getdescription(this.handle);
        return descriptions;
    }

    public Resource[] getImages() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error AndroidSDKTableOfContentsEntry not initialized");
        }
        long[] resourceMetadata = new long[2];
        this.loadResources(resourceMetadata);
        long resourceHandle = resourceMetadata[0];
        long totalResource = resourceMetadata[1];
        Resource[] resources = new AndroidSDKResource[(int)totalResource];
        int i = 0;
        while ((long)i < totalResource) {
            resources[i] = new AndroidSDKResource();
            ++i;
        }
        this.copyResources((AndroidSDKResource[])resources, resourceHandle);
        this.deleteResources(resourceHandle);
        return resources;
    }

    public TableOfContentsEntry getFirstChild() throws AndroidSDKException {
        long result = 0L;
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        AndroidSDKTableOfContentsEntry tableOfContentsEntryInst = new AndroidSDKTableOfContentsEntry();
        result = this.getfirstchild(tableOfContentsEntryInst, this.handle);
        if (result == (long)TOC_FIRST_CHILD_NOT_FOUND) {
            return null;
        }
        if (result != 0L) {
            throw new AndroidSDKException("Error getFirstChild Native call unsuccessful");
        }
        return tableOfContentsEntryInst;
    }

    public TableOfContentsEntry getLastChild() throws AndroidSDKException {
        long result = 0L;
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        AndroidSDKTableOfContentsEntry tableOfContentsEntryInst = new AndroidSDKTableOfContentsEntry();
        result = this.getlastchild(tableOfContentsEntryInst, this.handle);
        if (result == (long)TOC_LAST_CHILD_NOT_FOUND) {
            return null;
        }
        if (result != 0L) {
            throw new AndroidSDKException("Error getLastChild Native call unsuccessful");
        }
        return tableOfContentsEntryInst;
    }

    public TableOfContentsEntry[] getChildren() throws AndroidSDKException {
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        TableOfContentsEntry[] tocHandles = this.getchildren(this.handle);
        return tocHandles;
    }

    public TableOfContentsEntry getParent() throws AndroidSDKException {
        long result = 0L;
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        AndroidSDKTableOfContentsEntry tableOfContentsEntryInst = new AndroidSDKTableOfContentsEntry();
        result = this.getparent(tableOfContentsEntryInst, this.handle);
        if (result == (long)TOC_PARENT_NOT_FOUND) {
            return null;
        }
        if (result != 0L) {
            throw new AndroidSDKException("Error getparent Native call unsuccessful");
        }
        return tableOfContentsEntryInst;
    }

    public TableOfContentsEntry getNextEntry() throws AndroidSDKException {
        long result = 0L;
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        AndroidSDKTableOfContentsEntry tableOfContentsEntryInst = new AndroidSDKTableOfContentsEntry();
        result = this.getnextentry(tableOfContentsEntryInst, this.handle);
        if (result == (long)TOC_NEXT_ENTRY_NOT_FOUND) {
            return null;
        }
        if (result != 0L) {
            throw new AndroidSDKException("Error getNextEntry Native call unsuccessful");
        }
        return tableOfContentsEntryInst;
    }

    public TableOfContentsEntry getPreviousEntry() throws AndroidSDKException {
        long result = 0L;
        if (this.handle == 0L) {
            throw new AndroidSDKException("Error TableOfContentsEntry not initialized");
        }
        AndroidSDKTableOfContentsEntry tableOfContentsEntryInst = new AndroidSDKTableOfContentsEntry();
        result = this.getpreviousentry(tableOfContentsEntryInst, this.handle);
        if (result == (long)TOC_PREV_ENTRY_NOT_FOUND) {
            return null;
        }
        if (result != 0L) {
            throw new AndroidSDKException("Error getPreviousEntry Native call unsuccessful");
        }
        return tableOfContentsEntryInst;
    }

    public void dispose() {
        this.deletetableofcontentsentry(this.handle);
        this.init();
    }

    protected void finalize() {
        this.dispose();
    }

    private void init() {
        this.handle = 0L;
    }

    private native int getlevel(long var1);

    private native int getlength(long var1);

    private native int getposition(long var1);

    private native String getnodeclass(long var1);

    private native String getlabel(long var1);

    private native String[] getauthors(long var1);

    private native String[] getdescription(long var1);

    private native String[] getimages(long var1);

    private native long getfirstchild(AndroidSDKTableOfContentsEntry var1, long var2);

    private native long getlastchild(AndroidSDKTableOfContentsEntry var1, long var2);

    private native AndroidSDKTableOfContentsEntry[] getchildren(long var1);

    private native long getparent(AndroidSDKTableOfContentsEntry var1, long var2);

    private native long getnextentry(AndroidSDKTableOfContentsEntry var1, long var2);

    private native long getpreviousentry(AndroidSDKTableOfContentsEntry var1, long var2);

    private native void loadResources(long[] var1);

    private native void copyResources(AndroidSDKResource[] var1, long var2);

    private native void deleteResources(long var1);

    private native void deletetableofcontentsentry(long var1);
}

