/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.epub.reader.plat.mac;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformMacintoshLauncher {
    private static final String LOG_DIR = ".kindle";
    private static Application myApplication = Application.getApplication();
    private static final Logger logger = Logger.getLogger(PlatformMacintoshLauncher.class.getName());
    private static String mobiFileName = "";

    private static void registerCallback() {
        myApplication.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleOpenFile(ApplicationEvent e) {
                if (mobiFileName.equals("")) {
                    mobiFileName = e.getFilename() == null ? "" : e.getFilename();
                } else {
                    mobiFileName = mobiFileName + " " + (e.getFilename() == null ? "" : e.getFilename());
                }
            }
        });
    }

    private static void openPreviewer() {
        new Thread(new Runnable(){

            public void run() {
                String kindlePreviewerPath = System.getProperty("user.dir") + File.separator + "Kindle Previewer";
                logger.info("Kindle Previewer Launcher path is " + kindlePreviewerPath);
                List<String> command = mobiFileName.equals("") ? Arrays.asList(kindlePreviewerPath) : Arrays.asList(kindlePreviewerPath, mobiFileName);
                mobiFileName = "";
                ProcessBuilder pb = new ProcessBuilder(command);
                Process proc = null;
                try {
                    proc = pb.start();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    logger.log(Level.SEVERE, "Exception while invoking the shell script file", e1);
                }
            }
        }).start();
    }

    public static void main(String[] args) {
        PlatformMacintoshLauncher.registerCallback();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Exception while sleeping for handleOpenFile to finish", e);
        }
        PlatformMacintoshLauncher.openPreviewer();
    }
}

