/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.htmlreader.impl;

import com.amazon.ebook.booklet.htmlreader.impl.HTMLElement;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutElement;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutPageInfo;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutScreenInfo;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLJSONPageElementReader;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLPanelElement;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLPanelPage;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLRendererFixedLayout;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLVirtualPanelPage;
import com.amazon.kindlepreview.common.a.a.a;
import com.amazon.kindlepreview.common.a.f;
import com.kindlepreview.amazon.system.drawing.Rectangle;
import java.io.ByteArrayInputStream;

public class HTMLFixedLayoutBookNavigator {
    private static final com.amazon.kindlepreview.common.utils.a.f LOG = com.amazon.kindlepreview.common.utils.a.f.a("HTMLFixedLayoutBookNavigator");
    private static final String ORIENTATION_UNLOCKED = "unlocked";
    private static boolean ANIMATE_VIRTUAL_PANELS = false;
    private static final int MAX_STRETCHED_RATIO = 120;
    private static final int NON_STRETCHED_RATIO = 100;
    private boolean isRegionMag = false;
    private boolean panelViewMode = false;
    private boolean virtualPanelMode = false;
    private HTMLVirtualPanelPage virtualPanelPage;
    private final double virtualPanelZoomRatio = 2.0 / (1.0 + this.getOverlapRatio());
    private boolean showPageOnEnter = true;
    private final boolean showPageOnExit = false;
    private boolean duringShowPageOnEnter = false;
    private boolean duringShowPageOnExit = false;
    private final boolean delayPNZFlash = true;
    private int currentWidth;
    private int currentHeight;
    private a book;
    private String magnifiedVirtalPanel;

    public HTMLFixedLayoutBookNavigator(int n2, int n3) {
        this.currentWidth = n2;
        this.currentHeight = n3;
    }

    public void setScreenBounds(int n2, int n3) {
        boolean bl = this.currentWidth > this.currentHeight;
        boolean bl2 = n2 > n3;
        this.currentWidth = n2;
        this.currentHeight = n3;
        this.virtualPanelPage.setScreenBounds(n2, n3);
        if (bl != bl2) {
            this.changeOrientation();
        }
    }

    public void open(a a2) {
        this.book = a2;
        this.isRegionMag = this.book.y();
        this.showPageOnEnter = this.book.v();
        this.panelViewMode = false;
        this.virtualPanelMode = false;
        this.virtualPanelPage = new HTMLVirtualPanelPage(this.book, this.book.w(), this.book.f(), this.currentWidth, this.currentHeight);
        this.duringShowPageOnEnter = false;
        this.duringShowPageOnExit = false;
    }

    public void close() {
        try {
            HTMLRendererFixedLayout.closeUri();
        }
        catch (Exception exception) {
            LOG.b("Failure to acknowledge close book", exception);
        }
    }

    public void goToInternalPosition(int n2) {
        HTMLRendererFixedLayout.gotoPosition(n2);
        this.panelViewMode = false;
        this.virtualPanelMode = false;
        this.virtualPanelPage.exitPanelMode();
        this.duringShowPageOnEnter = false;
        this.duringShowPageOnExit = false;
    }

    public HTMLFixedLayoutScreenInfo getScreenInfo() {
        HTMLElement[] hTMLElementArray;
        byte[] byArray = HTMLRendererFixedLayout.getPageElements();
        if (byArray == null || byArray.length == 0) {
            HTMLElement[] hTMLElementArray2 = new HTMLElement[]{};
            return new HTMLFixedLayoutScreenInfo(hTMLElementArray2);
        }
        HTMLJSONPageElementReader hTMLJSONPageElementReader = new HTMLJSONPageElementReader(this.book, new ByteArrayInputStream(byArray));
        boolean bl = this.book.z();
        boolean bl2 = hTMLJSONPageElementReader.isZoomed();
        boolean bl3 = hTMLJSONPageElementReader.isPreviousPageAvailable();
        boolean bl4 = hTMLJSONPageElementReader.isNextPageAvailable();
        int n2 = hTMLJSONPageElementReader.getPageStartPosition();
        int n3 = hTMLJSONPageElementReader.getPageEndPosition();
        HTMLFixedLayoutPageInfo[] hTMLFixedLayoutPageInfoArray = hTMLJSONPageElementReader.getPages();
        int n4 = hTMLJSONPageElementReader.getPanelPage();
        int n5 = hTMLJSONPageElementReader.getPanelNumber();
        String string = hTMLJSONPageElementReader.getMagnifiedVirtualPanel();
        HTMLPanelPage hTMLPanelPage = new HTMLPanelPage(hTMLFixedLayoutPageInfoArray, n4, n5, bl);
        int n6 = hTMLFixedLayoutPageInfoArray.length;
        Rectangle rectangle = new Rectangle(0, 0, this.currentWidth, this.currentHeight);
        if (n5 > 0 && this.book.o() != 2 || this.isVirtualPanelMode()) {
            int n7 = bl2 ? n6 + 1 : n6;
            hTMLElementArray = new HTMLElement[n7];
            if (n6 == 1) {
                hTMLElementArray[0] = new HTMLFixedLayoutElement(this.book, n2, n3, rectangle);
            } else {
                hTMLElementArray[0] = new HTMLFixedLayoutElement(this.book, n2, n3, bl, rectangle);
                hTMLElementArray[1] = new HTMLFixedLayoutElement(this.book, n2, n3, !bl, rectangle);
            }
        } else {
            int n8;
            int n9 = 0;
            for (n8 = 0; n8 < n6; ++n8) {
                n9 += hTMLFixedLayoutPageInfoArray[n8].getPanelElements().length;
            }
            hTMLElementArray = new HTMLElement[n9];
            n8 = 0;
            for (int i2 = 0; i2 < n6; ++i2) {
                for (int i3 = 0; i3 < hTMLFixedLayoutPageInfoArray[i2].getPanelElements().length; ++i3) {
                    hTMLElementArray[n8] = hTMLFixedLayoutPageInfoArray[i2].getPanelElements()[i3];
                    ++n8;
                }
            }
        }
        return new HTMLFixedLayoutScreenInfo(hTMLElementArray, bl2, bl3, bl4, n2, n3, hTMLFixedLayoutPageInfoArray, hTMLPanelPage, n4, n5, this.magnifiedVirtalPanel);
    }

    public boolean isNextPageAvailable() {
        if (this.panelViewMode && this.getScreenInfo().isNextPanelAvailable()) {
            return true;
        }
        if (this.virtualPanelMode && this.isNextVirtualPanelAvail()) {
            return true;
        }
        return this.getScreenInfo().isNextPageAvailable();
    }

    public boolean isPrevPageAvailable() {
        if (this.panelViewMode && this.getScreenInfo().isPreviousPanelAvailable()) {
            return true;
        }
        if (this.virtualPanelMode && this.isPrevVirtualPanelAvail()) {
            return true;
        }
        return this.getScreenInfo().isPreviousPageAvailable();
    }

    private void nextPagePanelMode() {
        if (this.panelViewMode && this.isNextPageAvailable()) {
            if (this.showPageOnEnter) {
                this.duringShowPageOnEnter = true;
                HTMLRendererFixedLayout.nextPage();
            } else {
                HTMLRendererFixedLayout.nextPagePanel(1, this.book.v());
            }
        }
    }

    private void previousPagePanelMode() {
        if (this.panelViewMode && this.isPrevPageAvailable()) {
            HTMLRendererFixedLayout.previousPagePanel(-1, this.book.v());
        }
    }

    private void nextPageVirtualPanelMode() {
        if (this.isNextPageAvailable()) {
            if (this.showPageOnEnter) {
                this.duringShowPageOnEnter = true;
                this.virtualPanelPage.exitPanelMode();
                HTMLRendererFixedLayout.nextPage();
            } else if (this.virtualPanelPage.gotoNextPageSetFirstPanel()) {
                HTMLRendererFixedLayout.nextPageVirtualPanel(this.virtualPanelPage.getCurrentPanel(), this.getVirtualPanelViewRatio());
            } else {
                this.virtualPanelPage.exitPanelMode();
                HTMLRendererFixedLayout.nextPage();
            }
        }
    }

    private void previousPageVirtualPanelMode() {
        if (this.isPrevPageAvailable()) {
            if (this.virtualPanelPage.gotoPreviousPageSetLastPanel()) {
                this.enterVirtualPanelMode();
                HTMLRendererFixedLayout.previousPageVirtualPanel(this.virtualPanelPage.getCurrentPanel(), this.getVirtualPanelViewRatio());
            } else {
                this.virtualPanelPage.exitPanelMode();
                HTMLRendererFixedLayout.previousPage();
                if (this.showPageOnEnter) {
                    this.duringShowPageOnEnter = true;
                }
            }
        } else {
            this.virtualPanelPage.exitPanelMode();
        }
    }

    private void nextPageInternalPanelMode() {
        if (this.panelViewMode) {
            this.nextPagePanelMode();
        }
    }

    private void previousPageInternalPanelMode() {
        if (this.showPageOnEnter && this.getScreenInfo().getPanelNumber() != 0) {
            this.duringShowPageOnEnter = true;
            this.showPageInPanelMode();
        } else {
            this.previousPagePanelMode();
        }
    }

    public void nextPageInternal() {
        if (this.duringShowPageOnExit && this.panelViewMode) {
            this.enterPanelViewMode();
            this.nextPagePanelMode();
        } else if (this.duringShowPageOnEnter && this.panelViewMode) {
            this.enterPanelViewMode();
            if (this.getScreenInfo().getLastPanelNumber() == 0) {
                this.nextPageInternalPanelMode();
            } else {
                this.gotoFirstPanel();
            }
        } else if (this.duringShowPageOnEnter && this.virtualPanelMode) {
            this.enterVirtualPanelMode();
            if (this.virtualPanelPage.isPanelAvailable()) {
                this.gotoFirstVirtualPanel();
            } else {
                this.virtualPanelPage.exitPanelMode();
                this.nextPageVirtualPanelMode();
            }
        } else if (this.duringShowPageOnExit && this.virtualPanelMode) {
            this.enterVirtualPanelMode();
            this.nextPageVirtualPanelMode();
        } else if (this.panelViewMode) {
            if (this.getScreenInfo().isNextPanelAvailable()) {
                HTMLRendererFixedLayout.gotoPanel(this.getScreenInfo().getNextPanelPage(), this.getScreenInfo().getNextPanelNumber(), this.book.v());
            } else {
                this.nextPageInternalPanelMode();
            }
        } else if (this.virtualPanelMode) {
            if (this.virtualPanelPage.isNextPanelAvailable()) {
                String string = this.virtualPanelPage.getCurrentPanel();
                int n2 = this.virtualPanelPage.getCurrentPage();
                this.virtualPanelPage.nextPanel();
                this.gotoVirtualPanel(this.getVirtualPanelViewRatio(), string, n2, this.virtualPanelPage.getCurrentPanel(), this.virtualPanelPage.getCurrentPage());
            } else {
                this.nextPageVirtualPanelMode();
            }
        } else if (this.isNextPageAvailable()) {
            HTMLRendererFixedLayout.nextPage();
        }
    }

    public void previousPageInternal() {
        if (this.duringShowPageOnEnter && this.panelViewMode) {
            this.enterPanelViewMode();
            this.previousPagePanelMode();
        } else if (this.duringShowPageOnExit && this.panelViewMode) {
            this.enterPanelViewMode();
            if (this.getScreenInfo().getLastPanelNumber() == 0) {
                this.previousPageInternalPanelMode();
            } else {
                this.gotoLastPanel();
            }
        } else if (this.duringShowPageOnEnter && this.virtualPanelMode) {
            this.enterVirtualPanelMode();
            this.previousPageVirtualPanelMode();
        } else if (this.duringShowPageOnExit && this.virtualPanelMode) {
            this.enterVirtualPanelMode();
            if (this.virtualPanelPage.isPanelAvailable()) {
                this.gotoLastVirtualPanel();
            } else {
                this.virtualPanelPage.exitPanelMode();
                this.previousPageVirtualPanelMode();
            }
        } else if (this.panelViewMode) {
            if (this.getScreenInfo().isPreviousPanelAvailable()) {
                HTMLRendererFixedLayout.gotoPanel(this.getScreenInfo().getPreviousPanelPage(), this.getScreenInfo().getPreviousPanelNumber(), this.book.v());
            } else {
                this.previousPageInternalPanelMode();
            }
        } else if (this.virtualPanelMode) {
            if (this.virtualPanelPage.isPreviousPanelAvailable()) {
                String string = this.virtualPanelPage.getCurrentPanel();
                int n2 = this.virtualPanelPage.getCurrentPage();
                this.virtualPanelPage.previousPanel();
                this.gotoVirtualPanel(this.getVirtualPanelViewRatio(), string, n2, this.virtualPanelPage.getCurrentPanel(), this.virtualPanelPage.getCurrentPage());
            } else if (this.showPageOnEnter && this.virtualPanelPage.isPanelAvailable()) {
                this.duringShowPageOnEnter = true;
                this.showPageInPanelMode();
            } else {
                this.previousPageVirtualPanelMode();
            }
        } else if (this.isPrevPageAvailable()) {
            HTMLRendererFixedLayout.previousPage();
        }
    }

    private void enterPanelViewMode() {
        this.panelViewMode = true;
        this.duringShowPageOnEnter = false;
        this.duringShowPageOnExit = false;
    }

    private void enterVirtualPanelMode() {
        this.virtualPanelMode = true;
        this.duringShowPageOnExit = false;
        this.duringShowPageOnEnter = false;
    }

    private void gotoVirtualPanel(double d2, String string, int n2, String string2, int n3) {
        this.enterVirtualPanelMode();
        HTMLRendererFixedLayout.gotoPanelVirtual(n3, string2, d2);
    }

    public void fitPage() {
        double d2 = 0.0;
        boolean bl = false;
        HTMLRendererFixedLayout.zoom(0.0, 0, 0, false);
    }

    public void panPage(int n2, int n3, boolean bl) {
        if (this.getScreenInfo().a) {
            HTMLRendererFixedLayout.pan(n2, n3, bl);
        }
    }

    public void zoomPage(double d2, int n2, int n3, boolean bl) {
        HTMLRendererFixedLayout.zoom(d2, n2, n3, bl);
    }

    public boolean isValidZoom(boolean bl, double d2, double d3, boolean bl2) {
        HTMLFixedLayoutScreenInfo hTMLFixedLayoutScreenInfo = this.getScreenInfo();
        if (hTMLFixedLayoutScreenInfo == null) {
            return false;
        }
        return hTMLFixedLayoutScreenInfo.a || d3 > 1.0 || !bl2;
    }

    public void handleZoom(boolean bl, double d2, double d3, int n2, int n3, int n4, int n5, boolean bl2) {
        if (!bl) {
            this.zoomPage(d3, n4, n5, bl2);
        }
    }

    public boolean isAllowPageTurnInZoom() {
        return true;
    }

    public boolean isDoubleTapHandledByElementInZoom() {
        return true;
    }

    public void gotoFirstPanel() {
        this.gotoPanel(this.getScreenInfo().getFirstPanelPage(), this.getScreenInfo().getFirstPanelNumber());
    }

    private void gotoLastPanel() {
        this.gotoPanel(this.getScreenInfo().getLastPanelPage(), this.getScreenInfo().getLastPanelNumber());
    }

    public void gotoPanel(f f2) {
        if (f2 instanceof HTMLPanelElement) {
            this.gotoPanel(((HTMLPanelElement)f2).getPage(), ((HTMLPanelElement)f2).getPanelNumber());
        } else if (f2 instanceof HTMLFixedLayoutElement) {
            this.gotoFirstPanel();
        }
    }

    public void gotoPanel(int n2, int n3) {
        HTMLRendererFixedLayout.gotoPanel(n2, n3, this.book.v());
        this.enterPanelViewMode();
    }

    public void gotoPanelPosition(int n2, int n3) {
        HTMLRendererFixedLayout.gotoPanelPosition(n2, n3, this.book.v());
        this.enterPanelViewMode();
    }

    public void gotoVirtualPanel(int n2, int n3) {
        if (this.virtualPanelPage.isPanelAvailable()) {
            if (n2 >= 0 && n3 >= 0) {
                this.virtualPanelPage.gotoPanel(n2, n3);
                this.gotoVirtualPanel(this.virtualPanelPage.getCurrentPage(), this.virtualPanelPage.getCurrentPanel());
            } else {
                this.gotoFirstVirtualPanel();
            }
        } else {
            this.enterVirtualPanelMode();
            this.duringShowPageOnEnter = true;
            this.duringShowPageOnExit = true;
        }
    }

    private void gotoFirstVirtualPanel() {
        this.virtualPanelPage.gotoFirstPanel();
        this.gotoVirtualPanel(this.virtualPanelPage.getCurrentPage(), this.virtualPanelPage.getCurrentPanel());
    }

    private void gotoLastVirtualPanel() {
        this.virtualPanelPage.gotoLastPanel();
        this.gotoVirtualPanel(this.virtualPanelPage.getCurrentPage(), this.virtualPanelPage.getCurrentPanel());
    }

    private void gotoVirtualPanel(int n2, String string) {
        this.enterVirtualPanelMode();
        this.gotoVirtualPanel(this.getVirtualPanelViewRatio(), null, n2, string, n2);
    }

    public void exitPanel() {
        this.showPageInPanelMode();
        this.panelViewMode = false;
        this.virtualPanelMode = false;
        this.duringShowPageOnEnter = false;
        this.duringShowPageOnExit = false;
    }

    private void showPageInPanelMode() {
        HTMLRendererFixedLayout.exitPanel();
        this.virtualPanelPage.exitPanelMode();
    }

    public boolean isPanelMode() {
        return this.panelViewMode;
    }

    public boolean isVirtualPanelMode() {
        return this.virtualPanelMode;
    }

    private boolean isShowPageInAnyPanelMode() {
        return this.isVirtualPanelMode() && this.getCurrentVirtualPanel() <= 0 || this.isShowPageInPanelMode();
    }

    public int getCurrentVirtualPanel() {
        return this.virtualPanelPage.a();
    }

    public boolean isShowPageInPanelMode() {
        return this.isPanelMode() && this.getScreenInfo().getPanelNumber() == 0;
    }

    public void changeOrientation() {
        if (!this.isRegionMag) {
            this.virtualPanelPage.changeOrientation();
        }
        if (!this.isShowPageInAnyPanelMode()) {
            if (this.isVirtualPanelMode()) {
                this.gotoVirtualPanel(this.virtualPanelPage.getCurrentPage(), this.virtualPanelPage.getCurrentPanel());
            } else if (this.isPanelMode()) {
                this.gotoPanel(this.getScreenInfo().getPanelPage(), this.getScreenInfo().getPanelNumber());
            }
        }
    }

    public void setViewingPageInfo(boolean bl, boolean bl2, HTMLFixedLayoutPageInfo[] hTMLFixedLayoutPageInfoArray, String string) {
        if (!this.isRegionMag) {
            this.virtualPanelPage.setViewingPageInfo(bl, bl2, hTMLFixedLayoutPageInfoArray, string);
        }
    }

    private boolean isNextVirtualPanelAvail() {
        return this.virtualPanelPage.isNextPanelAvailable();
    }

    private boolean isPrevVirtualPanelAvail() {
        return this.virtualPanelPage.isPreviousPanelAvailable();
    }

    private double getVirtualPanelViewRatio() {
        return this.virtualPanelZoomRatio;
    }

    private double getOverlapRatio() {
        return 0.2;
    }
}

