/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.htmlreader.impl;

import com.amazon.ebook.booklet.htmlreader.impl.HTMLElement;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutPageInfo;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLJSONUtil;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLLinkObject;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLPanelElement;
import com.amazon.kindlepreview.common.a.a.a;
import com.amazon.kindlepreview.common.utils.a.f;
import com.kindlepreview.amazon.system.drawing.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class HTMLJSONPageElementReader {
    private static final f LOG = f.a("HTMLJSONPageElementReader");
    private final String KEY_IS_ZOOMED = "is_zoomed";
    private final String KEY_MAGNIFIED_VPANEL = "magnified_vpanel";
    private final String KEY_PAGES = "pages";
    private final String KEY_PREVIOUS_PAGE = "previous_page";
    private final String KEY_NEXT_PAGE = "next_page";
    private final String KEY_PREVIOUS_PAGE_POS = "prev_page_start_pos";
    private final String KEY_NEXT_PAGE_POS = "next_page_start_pos";
    private final String KEY_START_POS = "start_position";
    private final String KEY_END_POS = "end_position";
    private final String KEY_PAGE_NUMBER = "page_number";
    private final String KEY_IS_DPS = "is_dps";
    private final String KEY_PANELS = "panels";
    private final String KEY_PANEL_NUMBER = "panel_number";
    private final String KEY_X = "x";
    private final String KEY_Y = "y";
    private final String KEY_WIDTH = "width";
    private final String KEY_HEIGHT = "height";
    private final String KEY_IS_MAGNIFIED = "is_magnified";
    private final String KEY_LINKS = "links";
    private final String KEY_LINK_ADDR = "link_addr";
    private HTMLFixedLayoutPageInfo[] pages;
    private int panelPage;
    private int panelNumber;
    private int pageStartPosition;
    private int pageEndPosition;
    private boolean isZoomed;
    private boolean isPrevPageAvail;
    private boolean isNextPageAvail;
    private String magnifiedVPanel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLJSONPageElementReader(a a2, InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            JSONObject jSONObject = (JSONObject)JSONValue.parse((Reader)inputStreamReader);
            this.isZoomed = this.readBool(jSONObject, "is_zoomed");
            this.magnifiedVPanel = this.readString(jSONObject, "magnified_vpanel");
            this.readPages(a2, jSONObject);
            if (this.pages != null && this.pages.length > 0) {
                this.isPrevPageAvail = this.pages[0].hasPreviousPage();
                this.isNextPageAvail = this.pages[this.pages.length - 1].hasNextPage();
                this.pageStartPosition = this.pages[0].getStartPosition();
                this.pageEndPosition = this.pages[this.pages.length - 1].getEndPosition();
            }
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                LOG.b("error in closing the input stream", iOException);
            }
        }
    }

    private void readPages(a a2, JSONObject jSONObject) {
        JSONArray jSONArray = HTMLJSONUtil.getJSONArrayValue(jSONObject, "pages");
        this.readPages(a2, jSONArray);
    }

    private void readPages(a a2, JSONArray jSONArray) {
        int n2;
        n2 = jSONArray != null ? (n2 = jSONArray.size()) : 0;
        this.pages = new HTMLFixedLayoutPageInfo[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = (JSONObject)jSONArray.get(i2);
            int n3 = this.readInt(jSONObject, "page_number");
            boolean bl = this.readBool(jSONObject, "previous_page");
            boolean bl2 = this.readBool(jSONObject, "next_page");
            int n4 = this.readInt(jSONObject, "start_position");
            int n5 = this.readInt(jSONObject, "end_position");
            boolean bl3 = this.readBool(jSONObject, "is_dps");
            JSONArray jSONArray2 = HTMLJSONUtil.getJSONArrayValue(jSONObject, "panels");
            HTMLPanelElement[] hTMLPanelElementArray = this.readPanels(a2, n3, n4, n5, jSONArray2);
            jSONArray2 = HTMLJSONUtil.getJSONArrayValue(jSONObject, "links");
            HTMLElement[] hTMLElementArray = this.readLinks(a2, n3, n4, n5, jSONArray2);
            this.pages[i2] = new HTMLFixedLayoutPageInfo(n3, bl, bl2, n4, n5, bl3, hTMLPanelElementArray, hTMLElementArray);
        }
    }

    private HTMLElement[] readLinks(a a2, int n2, int n3, int n4, JSONArray jSONArray) {
        int n5;
        n5 = jSONArray != null ? (n5 = jSONArray.size()) : 0;
        HTMLElement[] hTMLElementArray = new HTMLElement[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            JSONObject jSONObject = (JSONObject)jSONArray.get(i2);
            String string = this.readString(jSONObject, "link_addr");
            int n6 = this.readInt(jSONObject, "x");
            int n7 = this.readInt(jSONObject, "y");
            int n8 = this.readInt(jSONObject, "width");
            int n9 = this.readInt(jSONObject, "height");
            Rectangle rectangle = new Rectangle(n6, n7, n8, n9);
            HTMLLinkObject hTMLLinkObject = new HTMLLinkObject(string, i2 + 1, false, false, 3);
            ArrayList<HTMLLinkObject> arrayList = new ArrayList<HTMLLinkObject>();
            arrayList.add(hTMLLinkObject);
            hTMLElementArray[i2] = new HTMLElement(n3, n4, a2, null, arrayList, rectangle);
        }
        return hTMLElementArray;
    }

    private HTMLPanelElement[] readPanels(a a2, int n2, int n3, int n4, JSONArray jSONArray) {
        int n5;
        n5 = jSONArray != null ? (n5 = jSONArray.size()) : 0;
        HTMLPanelElement[] hTMLPanelElementArray = new HTMLPanelElement[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            JSONObject jSONObject = (JSONObject)jSONArray.get(i2);
            int n6 = this.readInt(jSONObject, "panel_number");
            int n7 = this.readInt(jSONObject, "x");
            int n8 = this.readInt(jSONObject, "y");
            int n9 = this.readInt(jSONObject, "width");
            int n10 = this.readInt(jSONObject, "height");
            boolean bl = this.readBool(jSONObject, "is_magnified");
            Rectangle rectangle = new Rectangle(n7, n8, n9, n10);
            hTMLPanelElementArray[i2] = new HTMLPanelElement(a2, n2, n6, n3, n4, rectangle);
            if (!bl) continue;
            this.panelPage = n2;
            this.panelNumber = n6;
        }
        return hTMLPanelElementArray;
    }

    private String readString(JSONObject jSONObject, String string) {
        String string2 = HTMLJSONUtil.getStringValue(jSONObject, string);
        if (string2 == null) {
            LOG.b("Invalid response - missing " + string);
            throw new NullPointerException();
        }
        return string2;
    }

    private int readInt(JSONObject jSONObject, String string) {
        Integer n2 = HTMLJSONUtil.getIntValue(jSONObject, string);
        if (n2 == null) {
            LOG.b("Invalid response - missing " + string);
            throw new NullPointerException();
        }
        return n2;
    }

    private boolean readBool(JSONObject jSONObject, String string) {
        Boolean bl = HTMLJSONUtil.getBoolValue(jSONObject, string);
        if (bl == null) {
            LOG.b("Invalid response - missing " + string);
            throw new NullPointerException();
        }
        return bl;
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public String getMagnifiedVirtualPanel() {
        return this.magnifiedVPanel;
    }

    public boolean isNextPageAvailable() {
        return this.isNextPageAvail;
    }

    public boolean isPreviousPageAvailable() {
        return this.isPrevPageAvail;
    }

    public HTMLFixedLayoutPageInfo[] getPages() {
        return this.pages;
    }

    public int getPageStartPosition() {
        return this.pageStartPosition;
    }

    public int getPageEndPosition() {
        return this.pageEndPosition;
    }

    public int getPanelPage() {
        return this.panelPage;
    }

    public int getPanelNumber() {
        return this.panelNumber;
    }
}

