/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.htmlreader.impl;

import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutPageInfo;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLFixedLayoutScreenInfo;
import com.amazon.ebook.booklet.htmlreader.impl.HTMLPanelElement;
import com.amazon.kindlepreview.common.a.a;
import com.amazon.kindlepreview.common.a.f;
import com.kindlepreview.amazon.system.drawing.Rectangle;

public class HTMLVirtualPanelPage {
    private static final com.amazon.kindlepreview.common.utils.a.f LOG = com.amazon.kindlepreview.common.utils.a.f.a("HTMLVirtualPanelPage");
    public static final String PANEL_TOP_RIGHT = "tr";
    public static final String PANEL_TOP_LEFT = "tl";
    public static final String PANEL_BOTTOM_RIGHT = "br";
    public static final String PANEL_BOTTOM_LEFT = "bl";
    public static final String PANEL_TOP = "top";
    public static final String PANEL_BOTTOM = "bottom";
    public static final int TOP_RIGHT = 1;
    public static final int TOP_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int BOTTOM_LEFT = 4;
    public static final int TOP = 5;
    public static final int BOTTOM = 6;
    private static final int UNLOCKED = 0;
    private static final int PORTRAIT = 1;
    private static final int LANDSCAPE = 2;
    private com.amazon.kindlepreview.common.a.a.a book;
    private int writingMode;
    private int bookOrientation;
    private int midWidth;
    private int midHeight;
    private int viewingPageCount = 1;
    private int[] viewingPageNumbers = null;
    private boolean[] pagesBlank = null;
    private boolean isNextPageAvailable = false;
    private boolean isPreviousPageAvailable = false;
    private int panelIndex = -1;
    private int[] panelProgression;
    private int[] defaultPanelProgression;
    private static final int[] EMPTY_PANEL_PROGRESSION = new int[0];
    private static final int[] SINGLE_PAGE_HORIZONTAL_LTR_PROGRESSION = new int[]{2, 1, 4, 3};
    private static final int[] SINGLE_PAGE_HORIZONTAL_RTL_PROGRESSION = new int[]{1, 2, 3, 4};
    private static final int[] SINGLE_PAGE_VERTICAL_LTR_PROGRESSION = new int[]{2, 4, 1, 3};
    private static final int[] SINGLE_PAGE_VERTICAL_RTL_PROGRESSION = new int[]{1, 3, 2, 4};
    private static final int[] DOUBLE_PAGE_LTR_PROGRESSION = new int[]{2, 4, 1, 3};
    private static final int[] DOUBLE_PAGE_RTL_PROGRESSION = new int[]{1, 3, 2, 4};
    private static final int[] DOUBLE_PAGE_ONE_PAGE_VIEW_LTR_PROGRESSION = new int[]{2, 4};
    private static final int[] DOUBLE_PAGE_ONE_PAGE_VIEW_RTL_PROGRESSION = new int[]{1, 3};
    private static final int[] DOUBLE_PAGE_SINGLE_CENTER_PROGRESSION = new int[]{5, 6};
    protected HTMLPanelElement panelTL;
    protected HTMLPanelElement panelTR;
    protected HTMLPanelElement panelBL;
    protected HTMLPanelElement panelBR;
    protected HTMLPanelElement panelTop;
    protected HTMLPanelElement panelBottom;
    protected a clickMap;

    public HTMLVirtualPanelPage(com.amazon.kindlepreview.common.a.a.a a2, int n2, String string, int n3, int n4) {
        this.book = a2;
        this.writingMode = n2;
        if ("portrait".equalsIgnoreCase(string)) {
            this.bookOrientation = 1;
        } else if ("landscape".equalsIgnoreCase(string)) {
            this.bookOrientation = 2;
        } else {
            this.bookOrientation = 0;
            if (!com.amazon.kindlepreview.common.utils.a.a(string)) {
                LOG.c("Unknown orientation lock: " + string);
            }
        }
        this.setScreenBounds(n3, n4);
        this.resetPanelProgression(this.getDefaultPageCount(), -1);
        this.resetVirtualPanels();
    }

    public void setScreenBounds(int n2, int n3) {
        this.midWidth = n2 / 2;
        this.midHeight = n3 / 2;
    }

    private void resetVirtualPanels() {
        Rectangle rectangle = new Rectangle(0, 0, this.midWidth * 2, this.midHeight * 2);
        this.panelTL = new HTMLPanelElement(this.book, 0, 2, 0, 0, new Rectangle(rectangle.x, rectangle.y, this.midWidth, this.midHeight));
        this.panelTR = new HTMLPanelElement(this.book, 0, 1, 0, 0, new Rectangle(rectangle.x + this.midWidth, rectangle.y, this.midWidth, this.midHeight));
        this.panelBL = new HTMLPanelElement(this.book, 0, 4, 0, 0, new Rectangle(rectangle.x, rectangle.y + this.midHeight, this.midWidth, this.midHeight));
        this.panelBR = new HTMLPanelElement(this.book, 0, 3, 0, 0, new Rectangle(rectangle.x + this.midWidth, rectangle.y + this.midHeight, this.midWidth, this.midHeight));
        this.panelTop = new HTMLPanelElement(this.book, 0, 5, 0, 0, new Rectangle(rectangle.x, rectangle.y, rectangle.width, this.midHeight));
        this.panelBottom = new HTMLPanelElement(this.book, 0, 6, 0, 0, new Rectangle(rectangle.x, rectangle.y + this.midHeight, rectangle.width, this.midHeight));
        f[] fArray = new HTMLPanelElement[this.panelProgression.length];
        block8: for (int i2 = 0; i2 < this.panelProgression.length; ++i2) {
            switch (this.panelProgression[i2]) {
                case 2: {
                    fArray[i2] = this.panelTL;
                    continue block8;
                }
                case 1: {
                    fArray[i2] = this.panelTR;
                    continue block8;
                }
                case 4: {
                    fArray[i2] = this.panelBL;
                    continue block8;
                }
                case 3: {
                    fArray[i2] = this.panelBR;
                    continue block8;
                }
                case 5: {
                    fArray[i2] = this.panelTop;
                    continue block8;
                }
                case 6: {
                    fArray[i2] = this.panelBottom;
                    continue block8;
                }
            }
        }
        this.clickMap = new a(fArray);
    }

    private void resetPanelProgression(int n2, int n3) {
        if (this.bookOrientation != 0 || this.midWidth < this.midHeight) {
            this.panelProgression = this.isBlankPage(0) ? EMPTY_PANEL_PROGRESSION : this.getSinglePageProgression();
            this.defaultPanelProgression = this.getSinglePageProgression();
        } else if (n2 == 1) {
            this.panelProgression = this.isBlankPage(0) ? EMPTY_PANEL_PROGRESSION : DOUBLE_PAGE_SINGLE_CENTER_PROGRESSION;
            this.defaultPanelProgression = this.isLeftToRight() ? DOUBLE_PAGE_LTR_PROGRESSION : DOUBLE_PAGE_RTL_PROGRESSION;
        } else {
            boolean bl = this.isBlankPage(0);
            boolean bl2 = this.isBlankPage(1);
            this.panelProgression = bl && bl2 ? EMPTY_PANEL_PROGRESSION : (this.isLeftToRight() ? (bl ? DOUBLE_PAGE_ONE_PAGE_VIEW_RTL_PROGRESSION : (bl2 ? DOUBLE_PAGE_ONE_PAGE_VIEW_LTR_PROGRESSION : DOUBLE_PAGE_LTR_PROGRESSION)) : (bl ? DOUBLE_PAGE_ONE_PAGE_VIEW_LTR_PROGRESSION : (bl2 ? DOUBLE_PAGE_ONE_PAGE_VIEW_RTL_PROGRESSION : DOUBLE_PAGE_RTL_PROGRESSION)));
            this.defaultPanelProgression = this.isLeftToRight() ? DOUBLE_PAGE_LTR_PROGRESSION : DOUBLE_PAGE_RTL_PROGRESSION;
        }
    }

    private int[] getSinglePageProgression() {
        switch (this.writingMode) {
            case 2: {
                return SINGLE_PAGE_HORIZONTAL_RTL_PROGRESSION;
            }
            case 5: {
                return SINGLE_PAGE_VERTICAL_LTR_PROGRESSION;
            }
            case 4: {
                return SINGLE_PAGE_VERTICAL_RTL_PROGRESSION;
            }
        }
        return SINGLE_PAGE_HORIZONTAL_LTR_PROGRESSION;
    }

    public void changeOrientation() {
        if (this.bookOrientation != 0) {
            return;
        }
        int n2 = this.panelIndex >= 0 ? this.panelProgression[this.panelIndex] : -1;
        int n3 = this.getCurrentPage();
        int n4 = this.getDefaultPageCount();
        this.resetPanelProgression(n4, this.viewingPageNumbers == null || this.viewingPageNumbers.length == 0 ? -1 : this.viewingPageNumbers[0]);
        this.resetVirtualPanels();
        if (this.panelIndex >= 0) {
            if (this.midWidth > this.midHeight) {
                this.panelIndex = n2 == 2 || n2 == 1 ? 0 : 1;
                if (n4 > this.viewingPageNumbers.length) {
                    this.viewingPageNumbers = new int[]{n3, n3};
                }
            } else {
                if (n2 == 2 || n2 == 1) {
                    this.panelIndex = 0;
                } else {
                    int n5 = this.panelIndex = this.isHorizontal() ? 2 : 1;
                }
                if (this.viewingPageNumbers.length > n4) {
                    this.viewingPageNumbers = new int[]{n3};
                }
            }
            if (this.panelIndex >= this.panelProgression.length) {
                this.panelProgression = this.defaultPanelProgression;
            }
            this.viewingPageCount = n4;
        }
    }

    public void pageTurnedForward() {
        this.pageTurned(true);
    }

    public void pageTurnedBackward() {
        this.pageTurned(false);
    }

    private void pageTurned(boolean bl) {
        int n2;
        if (this.viewingPageNumbers[0] == 0 && !bl) {
            return;
        }
        if (this.isDefaultTwoPageView() && this.viewingPageNumbers.length == 1) {
            if (bl) {
                return;
            }
            n2 = this.viewingPageNumbers[0];
            this.viewingPageNumbers = new int[]{n2, n2 + 1};
        }
        n2 = bl ? this.viewingPageNumbers.length : (this.viewingPageNumbers[0] - this.viewingPageNumbers.length < 0 ? this.viewingPageNumbers[0] : this.viewingPageNumbers.length);
        for (int i2 = 0; i2 < this.viewingPageNumbers.length; ++i2) {
            this.viewingPageNumbers[i2] = bl ? this.viewingPageNumbers[i2] + n2 : this.viewingPageNumbers[i2] - n2;
        }
    }

    private int getDefaultPageCount() {
        return this.isDefaultTwoPageView() ? 2 : 1;
    }

    public void setViewingPageInfo(boolean bl, boolean bl2, HTMLFixedLayoutPageInfo[] hTMLFixedLayoutPageInfoArray, String string) {
        int n2;
        int n3 = hTMLFixedLayoutPageInfoArray.length;
        this.isNextPageAvailable = bl;
        this.isPreviousPageAvailable = bl2;
        this.pagesBlank = new boolean[n3];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = hTMLFixedLayoutPageInfoArray[n2].getPage();
            try {
                this.pagesBlank[n2] = HTMLFixedLayoutScreenInfo.a(this.book, nArray[n2]);
                continue;
            }
            catch (Exception exception) {
                this.pagesBlank[n2] = false;
            }
        }
        this.viewingPageNumbers = nArray;
        this.viewingPageCount = n3;
        this.resetPanelProgression(n3, this.viewingPageNumbers[0]);
        this.resetVirtualPanels();
        n2 = -1;
        if (PANEL_TOP_RIGHT.equals(string)) {
            n2 = 1;
        } else if (PANEL_TOP_LEFT.equals(string)) {
            n2 = 2;
        } else if (PANEL_BOTTOM_RIGHT.equals(string)) {
            n2 = 3;
        } else if (PANEL_BOTTOM_LEFT.equals(string)) {
            n2 = 4;
        } else if (PANEL_TOP.equals(string)) {
            n2 = 5;
        } else if (PANEL_BOTTOM.equals(string)) {
            n2 = 6;
        }
        this.resetPanelIndex(n2);
    }

    private int getPanelOnOppositePage(int n2) {
        switch (n2) {
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 4;
            }
        }
        return n2;
    }

    private void resetPanelIndex(int n2) {
        this.panelIndex = -1;
        for (int i2 = 0; i2 < this.panelProgression.length; ++i2) {
            if (this.panelProgression[i2] != n2) continue;
            this.panelIndex = i2;
            break;
        }
    }

    private boolean isTwoPageView() {
        return this.viewingPageCount == 2;
    }

    private boolean isDefaultTwoPageView() {
        return this.midWidth > this.midHeight && this.bookOrientation == 0;
    }

    private String convertToUserPanelNumber(int n2) {
        String string = null;
        switch (n2) {
            case 1: {
                string = PANEL_TOP_RIGHT;
                break;
            }
            case 3: {
                string = PANEL_BOTTOM_RIGHT;
                break;
            }
            case 4: {
                string = PANEL_BOTTOM_LEFT;
                break;
            }
            case 5: {
                string = PANEL_TOP;
                break;
            }
            case 6: {
                string = PANEL_BOTTOM;
                break;
            }
            default: {
                string = PANEL_TOP_LEFT;
            }
        }
        return string;
    }

    private int convertToUserPageNumber(int n2) {
        int n3 = this.viewingPageNumbers[0];
        if (this.isTwoPageView()) {
            n3 = this.isLeftToRight() ? (n2 == 2 || n2 == 4 ? this.viewingPageNumbers[0] : this.viewingPageNumbers[1]) : (n2 == 2 || n2 == 4 ? this.viewingPageNumbers[1] : this.viewingPageNumbers[0]);
        }
        return n3;
    }

    public String getCurrentPanel() {
        if (this.panelIndex >= 0) {
            return this.convertToUserPanelNumber(this.panelProgression[this.panelIndex]);
        }
        return PANEL_TOP_LEFT;
    }

    int a() {
        if (this.panelIndex >= 0) {
            return this.panelProgression[this.panelIndex];
        }
        return -1;
    }

    public int getCurrentPage() {
        if (this.panelIndex >= 0) {
            return this.convertToUserPageNumber(this.panelProgression[this.panelIndex]);
        }
        return -1;
    }

    public void gotoPanel(int n2, int n3) {
        HTMLPanelElement hTMLPanelElement = (HTMLPanelElement)this.clickMap.a(n2, n3);
        if (hTMLPanelElement == null) {
            this.gotoFirstPanel();
        } else {
            int n4 = hTMLPanelElement.getPanelNumber();
            this.resetPanelIndex(n4);
        }
    }

    public boolean isPanelAvailable() {
        return this.panelProgression != null && this.panelProgression.length > 0;
    }

    public void gotoFirstPanel() {
        if (this.isPanelAvailable()) {
            this.panelIndex = 0;
        }
    }

    public void gotoLastPanel() {
        if (this.isPanelAvailable()) {
            this.panelIndex = this.panelProgression.length - 1;
        }
    }

    public boolean gotoNextPageSetFirstPanel() {
        block7: {
            int n2;
            if (!this.isNextPageAvailable) {
                return false;
            }
            this.panelProgression = this.defaultPanelProgression;
            int n3 = n2 = this.isTwoPageView() ? this.viewingPageNumbers[1] : this.viewingPageNumbers[0];
            if (this.isDefaultTwoPageView()) {
                try {
                    if (!HTMLFixedLayoutScreenInfo.a(this.book, n2 + 1)) {
                        this.panelIndex = 0;
                        break block7;
                    }
                    if (!HTMLFixedLayoutScreenInfo.a(this.book, n2 + 2)) {
                        this.panelIndex = 2;
                        break block7;
                    }
                    this.panelIndex = -1;
                }
                catch (Exception exception) {
                    this.panelIndex = 0;
                }
            } else {
                this.panelIndex = this.getNextNonBlankSkeleton(n2) >= 0 ? 0 : -1;
            }
        }
        return this.panelIndex >= 0;
    }

    public boolean gotoPreviousPageSetLastPanel() {
        block7: {
            if (!this.isPreviousPageAvailable) {
                return false;
            }
            this.panelProgression = this.defaultPanelProgression;
            int n2 = this.viewingPageNumbers[0];
            if (this.isDefaultTwoPageView()) {
                try {
                    if (!HTMLFixedLayoutScreenInfo.a(this.book, n2 - 1)) {
                        this.panelIndex = this.panelProgression.length - 1;
                        break block7;
                    }
                    if (!HTMLFixedLayoutScreenInfo.a(this.book, n2 - 2)) {
                        this.panelIndex = this.panelProgression.length - 3;
                        break block7;
                    }
                    this.panelIndex = -1;
                }
                catch (Exception exception) {
                    this.panelIndex = this.panelProgression.length - 1;
                }
            } else {
                this.panelIndex = this.getPreviousNonBlankSkeleton(n2) >= 0 ? this.panelProgression.length - 1 : -1;
            }
        }
        return this.panelIndex >= 0;
    }

    private int getNextNonBlankSkeleton(int n2) {
        int n3 = n2;
        boolean bl = false;
        do {
            ++n3;
            try {
                bl = HTMLFixedLayoutScreenInfo.a(this.book, n3);
            }
            catch (Exception exception) {
                return -1;
            }
        } while (bl);
        return n3;
    }

    private int getPreviousNonBlankSkeleton(int n2) {
        int n3 = n2;
        boolean bl = false;
        do {
            --n3;
            try {
                bl = HTMLFixedLayoutScreenInfo.a(this.book, n3);
            }
            catch (Exception exception) {
                return -1;
            }
        } while (bl);
        return n3;
    }

    public void exitPanelMode() {
        this.panelIndex = -1;
    }

    public boolean isNextPanelAvailable() {
        return this.panelIndex < this.panelProgression.length - 1;
    }

    public boolean isPreviousPanelAvailable() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        if (this.isNextPanelAvailable()) {
            ++this.panelIndex;
        }
    }

    public void previousPanel() {
        if (this.isPreviousPanelAvailable()) {
            --this.panelIndex;
        }
    }

    private boolean isLeftToRight() {
        return (this.writingMode & 1) != 0;
    }

    private boolean isHorizontal() {
        return (this.writingMode & 2) != 0;
    }

    private boolean isBlankPage(int n2) {
        if (this.pagesBlank != null && n2 < this.pagesBlank.length && n2 >= 0) {
            return this.pagesBlank[n2];
        }
        return false;
    }
}

