/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.epub.reader.plat;

import com.amazon.epub.reader.c.g;
import com.amazon.epub.reader.font.engine.FreeTypeFontManager;
import com.amazon.epub.reader.plat.b;
import com.amazon.epub.reader.plat.c;
import com.amazon.epub.reader.swt.SWTReader;
import com.amazon.epub.reader.swt.d;
import com.amazon.epub.reader.swt.j;
import com.amazon.epub.reader.wrapper.BookViewManager_Iphone;
import com.amazon.kindlepreview.common.reader.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.miginfocom.swt.MigLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class a {
    protected Display iDisplay;
    protected List<SWTReader> iReaders = new ArrayList<SWTReader>();
    protected static final Logger LOG = Logger.getLogger(a.class.getName());
    protected final Properties configProps;
    private final Map<String, String> iFilters;
    private boolean iIsInitialized;
    private final String[] iArgs;
    private final FileLock previewerLock;
    private String OSName;
    private String OSVersion;
    private static String ffmpegPath = "";
    protected static boolean restart;
    private String kprID;
    private static int defaultDeviceMode;
    private static String defaultOrientation;
    private static boolean isUdcDisabled;

    public a(String[] stringArray, Properties properties) throws com.amazon.kindlepreview.common.utils.h {
        if (properties == null) {
            throw new IllegalStateException("cofiguration properties is null");
        }
        this.iArgs = stringArray;
        this.configProps = properties;
        this.iFilters = Collections.unmodifiableMap(this.getStandardFilters());
        this.cleanStartup();
        this.previewerLock = com.amazon.a.a.a(com.amazon.a.a.a, true);
        this.OSName = System.getProperty("os.name").toLowerCase();
        this.OSVersion = System.getProperty("os.version").toLowerCase();
        restart = this.setEnvironmentVariables();
        if (restart) {
            return;
        }
        FreeTypeFontManager.init(72);
        com.amazon.kindlepreview.common.reader.c.a();
        BookViewManager_Iphone.U();
        this.checkUUID();
    }

    void a(FileLock fileLock) {
        try {
            fileLock.release();
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Error while releaseing lock ", exception);
            com.amazon.a.a.c(com.amazon.a.a.a);
        }
    }

    public String getKprID() {
        return this.kprID;
    }

    private void checkUUID() {
        Object object;
        String string = System.getProperty("user.dir") + File.separator + "lib" + File.separator + "kpr.id";
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                LOG.info("[File Not Found Exception] unable to find uuid file");
            }
        }
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                object = new FileInputStream(string);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.info("[File Not Found Exception] unable to find uuid file");
            }
            catch (IOException iOException) {
                LOG.info("[IOException ] unable to load from uuid file");
            }
        }
        this.kprID = properties.getProperty("KPR_ID");
        object = new Properties();
        if (this.kprID == null) {
            this.kprID = UUID.randomUUID().toString();
            ((Properties)object).put("KPR_ID", this.kprID);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ((Properties)object).store(fileOutputStream, null);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.log(Level.INFO, "Exception while creating the file to write the uuid", fileNotFoundException);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Exception while writing the uuid into the file", iOException);
            }
        }
        j.d();
        j.c();
    }

    private void cleanStartup() {
        FileLock fileLock = com.amazon.a.a.a(com.amazon.a.a.a, false);
        if (fileLock != null) {
            com.amazon.a.a.b(System.getProperty("user.dir") + File.separator + "LocalLib");
            this.a(fileLock);
            return;
        }
    }

    public String getconfigProperty(String string) {
        return this.configProps.getProperty(string);
    }

    public synchronized void startReading() {
        if (this.iIsInitialized) {
            throw new IllegalStateException("Reading can be started only once");
        }
        this.iIsInitialized = true;
        if (this.iArgs.length == 0) {
            this.newReaderWindow();
        } else {
            for (int i2 = 0; i2 < this.iArgs.length; ++i2) {
                this.newReaderWindow(this.iArgs[i2]);
            }
        }
    }

    public Display getDisplay() {
        return this.iDisplay;
    }

    protected Map<String, String> getStandardFilters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.isEPUBConversionSupported()) {
            hashMap.put("Books", com.amazon.kindlepreview.common.utils.d.b());
        } else {
            hashMap.put("Books", com.amazon.kindlepreview.common.utils.d.a());
        }
        return hashMap;
    }

    public Map<String, String> getFileFilters() {
        return this.iFilters;
    }

    public boolean isEPUBConversionSupported() {
        String string = this.configProps.getProperty("EPUB_SUPPORT", "true");
        return string.equalsIgnoreCase("true");
    }

    public abstract c getPlatformUpdateInfo();

    public SWTReader newReaderWindow() {
        return this.newReaderWindow(null);
    }

    public SWTReader newReaderWindow(String string) {
        return this.newReaderWindow(string, false, com.amazon.kindlepreview.common.reader.c.w);
    }

    public SWTReader newReaderWindow(String string, boolean bl, h h2) {
        SWTReader sWTReader = new SWTReader(this.iDisplay, bl, h2);
        this.iReaders.add(sWTReader);
        b.a();
        sWTReader.run(string);
        return sWTReader;
    }

    public boolean closeReaderWindow(SWTReader sWTReader) {
        return this.closeReaderWindow(sWTReader, false);
    }

    public boolean closeReaderWindow(SWTReader sWTReader, boolean bl) {
        File file;
        Thread thread = null;
        if (b.a != null && b.a.isAlive()) {
            if (b.a.isAlive()) {
                com.amazon.b.a.i = true;
                if (com.amazon.b.a.j != null) {
                    a.savePreviewerState(SWTReader.transcodeAutomatically);
                }
            }
            file = new File(com.amazon.a.a.b + "_tmp");
            if (com.amazon.b.a.d && file != null && file.exists() && file.length() > 0L && com.amazon.b.a.j != null) {
                thread = new Thread(new Runnable(){

                    public void run() {
                        a.saveSHA1inState(com.amazon.b.a.a(file));
                    }
                });
                thread.start();
            }
        }
        if (com.amazon.b.a.k != null && com.amazon.b.a.k.isAlive()) {
            if (com.amazon.b.a.k.isAlive()) {
                com.amazon.b.a.l = true;
                com.amazon.b.a.b = true;
                com.amazon.b.a.d = true;
                a.savePreviewerState(SWTReader.transcodeAutomatically);
            } else {
                a.saveTranscodingPreviewerState(SWTReader.transcodeAutomatically);
            }
            if (thread != null && thread.isAlive()) {
                LOG.info("Both forced Thread and downloadUpdate Thread is downloading");
            } else {
                file = new File(com.amazon.a.a.b + "_tmp");
                thread = new Thread(new Runnable(){

                    public void run() {
                        a.saveSHA1inState(com.amazon.b.a.a(file));
                    }
                });
                thread.start();
            }
        } else {
            a.saveTranscodingPreviewerState(SWTReader.transcodeAutomatically);
        }
        this.iReaders.remove(sWTReader);
        if (sWTReader != null) {
            sWTReader.closeReader();
        }
        if (this.iReaders.size() <= 0) {
            com.amazon.kindlepreview.common.reader.c.b();
            if (!bl) {
                this.iDisplay.dispose();
            }
        }
        if (thread != null && thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.info("interrupted when waiting for calculating SHA1 of the partially downloaded file ");
            }
        }
        j.p = true;
        return true;
    }

    public static void savePreviewerState(String string) {
        Properties properties = new Properties();
        properties.put("FFmpeg_library_Path", ffmpegPath);
        properties.put("Transcode_Automatically", string);
        properties.put("CHECKEDFORVERISON", com.amazon.b.a.e.toString());
        properties.put("SHOWAUTOUPDATEKEY", String.valueOf(com.amazon.b.a.c));
        properties.put("JARLASTMODIFIED", String.valueOf(com.amazon.b.a.f));
        properties.put("STARTEDDOWNLOADING", String.valueOf(com.amazon.b.a.d));
        properties.put("USERINPUTFORCANDOWNLOAD", String.valueOf(com.amazon.b.a.b));
        properties.put("PARTIALLYDOWNLOADEDFILE", com.amazon.b.a.g);
        properties.put("DEFAULT_DEVICE_MODE", String.valueOf(defaultDeviceMode));
        properties.put("DEFAULT_ORIENTATION", String.valueOf(defaultOrientation));
        properties.put("DISABLE_UDC", String.valueOf(isUdcDisabled));
        File file = new File(System.getProperty("user.dir") + File.separator + "previewerstate.properties");
        File file2 = new File(System.getProperty("user.dir") + File.separator + "previewerstate.properties_temp");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
            a.renameFile(file, file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.INFO, "Exception while creating the file to write the previewer state", fileNotFoundException);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Exception while writing the previewer state into the file", iOException);
        }
    }

    public static void saveTranscodingPreviewerState(String string) {
        com.amazon.b.a.b();
        a.savePreviewerState(string);
    }

    public static void saveSHA1inState(String string) {
        com.amazon.b.a.b();
        com.amazon.b.a.g = string;
        a.savePreviewerState(SWTReader.transcodeAutomatically);
    }

    private static boolean renameFile(File file, File file2) {
        List<String> list = b.b().getExecutionStringForFileRename(file, file2);
        LOG.info("Command String: " + list);
        if (list.isEmpty()) {
            return false;
        }
        LOG.info("building process builder");
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = null;
        int n2 = -1;
        try {
            LOG.info("starting update");
            process = processBuilder.start();
            n2 = process.waitFor();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "exception while running update for KindlePreviewer.exe ", iOException);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.SEVERE, " interrupted while waiting for update process to complete", interruptedException);
        }
        if (n2 != 0) {
            return false;
        }
        boolean bl = file2.delete();
        LOG.info("update file deleted " + bl);
        return true;
    }

    public boolean closePreviewer() {
        ArrayList<SWTReader> arrayList = new ArrayList<SWTReader>(this.iReaders);
        for (SWTReader sWTReader : arrayList) {
            if (this.closeReaderWindow(sWTReader)) continue;
            return false;
        }
        return true;
    }

    public void showErrorMessage(String string, String string2) {
        Shell shell = new Shell(this.iDisplay);
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setText(string2);
        messageBox.setMessage(string);
        messageBox.open();
        shell.dispose();
    }

    public void showUpdateMessage(final String string, final double d2) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell(a.this.iDisplay);
                com.amazon.epub.reader.swt.a.a a2 = new com.amazon.epub.reader.swt.a.a(){

                    protected void a(Shell shell) {
                        shell.setText(SWTReader.getKprMessages().getString("download_update"));
                        MigLayout migLayout = new MigLayout("fill");
                        shell.setLayout((Layout)migLayout);
                        Label label = new Label((Composite)shell, 0);
                        label.setText(string + "\n" + SWTReader.getKprMessages().getString("download_update_question"));
                        label.setLayoutData((Object)"grow, push, span, wrap 20");
                        Link link = new Link((Composite)shell, 0);
                        String string = "<a href=\"" + this.a(d2) + "\">" + SWTReader.getKprMessages().getString("release_notes") + "</a>";
                        link.setText(string);
                        link.setLayoutData((Object)"align left,width 150");
                        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                List<String> list = b.b().openURLCommand(selectionEvent.text);
                                g g2 = new g(list, false);
                                Process process = null;
                                try {
                                    process = g2.b();
                                }
                                catch (IOException iOException) {
                                    LOG.log(Level.WARNING, "Unexpected Error While Executing exec Command", iOException);
                                }
                            }
                        });
                        Button button = new Button((Composite)shell, 8);
                        button.setText(SWTReader.getKprMessages().getString("yes"));
                        button.setLayoutData((Object)"width 60");
                        button.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = true;
                                this.a();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = true;
                            }
                        });
                        shell.setDefaultButton(button);
                        Button button2 = new Button((Composite)shell, 8);
                        button2.setText(SWTReader.getKprMessages().getString("no"));
                        button2.setLayoutData((Object)"width 60");
                        button2.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = false;
                                com.amazon.b.a.c = false;
                                this.a();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = false;
                            }
                        });
                        Button button3 = new Button((Composite)shell, 8);
                        button3.setText(SWTReader.getKprMessages().getString("Remaind_Later"));
                        button3.setLayoutData((Object)"width 120");
                        button3.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = false;
                                this.a();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.b = false;
                            }
                        });
                    }

                    private String a(double d2) {
                        String string = SWTReader.getKprMessages().getString("release_notes_url");
                        try {
                            String string2 = SWTReader.getKprMessages().getString("release_notes_url_version") + d2 + ".txt";
                            URL uRL = new URL(string2);
                            URLConnection uRLConnection = uRL.openConnection();
                            if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                                httpURLConnection.connect();
                                if (httpURLConnection.getResponseCode() == 200) {
                                    httpURLConnection.disconnect();
                                    string = string2;
                                }
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return string;
                    }
                };
                a2.a(shell, 67616);
                Display display = a2.b().getDisplay();
                while (a2.b() != null && !a2.b().isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public abstract List<String> getMailingCommand(String var1);

    public abstract List<String> openURLCommand(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties loadUpdateProperties() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        URL uRL = new URL(b.b().getconfigProperty("PREVIEWER_RELEASE_INFO_URL"));
        inputStream = uRL.openStream();
        properties.load(inputStream);
        Object var6_5 = null;
        if (inputStream == null) return properties;
        try {
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, iOException.getMessage(), iOException);
        }
        return properties;
        {
            catch (Exception exception) {
                LOG.log(Level.SEVERE, " exception while loading update info", exception);
                Properties properties2 = null;
                Object var6_6 = null;
                if (inputStream == null) return properties2;
                try {
                    inputStream.close();
                    return properties2;
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, iOException.getMessage(), iOException);
                }
                return properties2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, iOException.getMessage(), iOException);
            }
            throw throwable;
        }
    }

    protected Double converToDouble(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Double d2 = null;
        try {
            d2 = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, " error coverting double [" + string + "]", numberFormatException);
        }
        return d2;
    }

    public abstract boolean openBookInLocalPlatformReader(String var1);

    public abstract boolean isLocalPlatformReaderAvailable();

    public abstract String getCmdCtrlKey();

    public abstract String getKindleForPlatformString();

    public abstract String getDownloadUrlForKindleForPlatform();

    public abstract int getHeightOfTitleBar();

    public abstract int getHeightOfMenuBar();

    public void openAboutDialog() {
        d.a(this.iDisplay);
    }

    public void openAboutDialog(Shell shell) {
        d.a(shell);
    }

    public void openUpdateOptionDialog(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell2 = new Shell(shell);
                com.amazon.epub.reader.swt.a.a a2 = new com.amazon.epub.reader.swt.a.a(){

                    protected void a(Shell shell) {
                        shell.setText(SWTReader.getKprMessages().getString("Help_Update_Options"));
                        MigLayout migLayout = new MigLayout("fill");
                        shell.setLayout((Layout)migLayout);
                        Label label = new Label((Composite)shell, 0);
                        label.setText(SWTReader.getKprMessages().getString("update_available"));
                        label.setLayoutData((Object)"wrap 10");
                        com.amazon.b.a.a = com.amazon.b.a.h.getBoolean("UPDATEOPTIONDIALOG", true);
                        Button[] buttonArray = new Button[2];
                        buttonArray[0] = new Button((Composite)this.b, 16);
                        buttonArray[0].setText(SWTReader.getKprMessages().getString("update_available_inform"));
                        buttonArray[0].setLayoutData((Object)"wrap");
                        buttonArray[1] = new Button((Composite)this.b, 16);
                        buttonArray[1].setText(SWTReader.getKprMessages().getString("update_available_download"));
                        buttonArray[1].setLayoutData((Object)"wrap");
                        if (com.amazon.b.a.a) {
                            buttonArray[1].setSelection(true);
                        } else {
                            buttonArray[0].setSelection(true);
                        }
                        buttonArray[0].addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.a = false;
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }
                        });
                        buttonArray[1].addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.a = true;
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.a = true;
                            }
                        });
                        Label label2 = new Label((Composite)shell, 0);
                        label2.setLayoutData((Object)"align center");
                        Button button = new Button((Composite)shell, 8);
                        button.setText(SWTReader.getKprMessages().getString("ok"));
                        button.setLayoutData((Object)"width 60");
                        button.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                com.amazon.b.a.h.putBoolean("UPDATEOPTIONDIALOG", com.amazon.b.a.a);
                                this.a();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }
                        });
                        shell.setDefaultButton(button);
                    }
                };
                a2.a(shell2, 67616);
                Display display = a2.b().getDisplay();
                while (a2.b() != null && !a2.b().isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public boolean hasApplicationMenu() {
        return false;
    }

    public abstract void setMenuBackGroundColor(Menu var1);

    public abstract boolean needShellIcon();

    public abstract boolean playMedia(String var1);

    public abstract boolean playMediaWith(String var1);

    public abstract List<String> getExplorerCommand(String var1);

    public abstract String getExeFileName();

    public abstract String getDownloadExeFileName();

    public abstract List<String> getExecutionStringForRename();

    public String getFfmpegPath() {
        return ffmpegPath;
    }

    public void setFfmpegPath(String string) {
        ffmpegPath = string == null ? "" : string;
    }

    public void setDefaultDeviceMode(int n2) {
        defaultDeviceMode = n2;
    }

    public void setDefaultOrientation(String string) {
        defaultOrientation = string;
    }

    public static boolean getUdcDisabled() {
        Object object;
        isUdcDisabled = false;
        String string = System.getProperty("user.dir") + File.separator + "previewerstate.properties";
        File file = new File(string);
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                object = new FileInputStream(string);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.info("[File Not Found Exception] unable to find previewerstate.properties file");
            }
            catch (IOException iOException) {
                LOG.info("[IOException ] unable to load from previewerstate.properties file");
            }
        }
        if ((object = properties.getProperty("DISABLE_UDC")) == null) {
            isUdcDisabled = false;
            return isUdcDisabled;
        }
        isUdcDisabled = ((String)object).equals("true");
        return isUdcDisabled;
    }

    public static void setUdcDisabled(boolean bl) {
        isUdcDisabled = bl;
        a.savePreviewerState(SWTReader.transcodeAutomatically);
    }

    public abstract String getFfmpegFileExtension();

    public abstract String[] getFfmpegPass1Command(String var1, String var2, String var3);

    public abstract String[] getFfmpegPass2Command(String var1, String var2, String var3, String var4);

    public abstract List<String> getExecutionStringForFileRename(File var1, File var2);

    public abstract String getNativeReaderUnAvailableString();

    public abstract String getBookNotOpeningInNativeReaderString();

    public abstract int getTextFontSize();

    public abstract Map<String, String> getEnvironmentVariables();

    public abstract boolean setEnvironmentVariables();

    public abstract boolean isForcedThreadDownloading();

    public abstract boolean isAutoUpdateStartedDownloading();

    public String getOSVersion() {
        return this.OSVersion;
    }

    static {
        defaultDeviceMode = 0;
        defaultOrientation = "Portrait";
        isUdcDisabled = false;
    }
}

