/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.epub.reader.plat.win;

import com.amazon.epub.reader.c.f;
import com.amazon.epub.reader.c.g;
import com.amazon.epub.reader.plat.a;
import com.amazon.epub.reader.plat.c;
import com.amazon.epub.reader.swt.SWTReader;
import com.amazon.kindlepreview.common.utils.h;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformWindows
extends a {
    private final Logger Log = Logger.getLogger(this.getClass().getName());
    private String mazamaInstallDir;

    public PlatformWindows(String[] stringArray, Properties properties) throws h {
        super(stringArray, properties);
        this.iDisplay = new Display();
        this.mazamaInstallDir = null;
        f.a(96);
    }

    @Override
    public List<String> getMailingCommand(String string) {
        return Arrays.asList("cmd", "/c", "start", "mailto:" + string.trim() + "?subject=Kindle%20Previewer%20" + 2.8);
    }

    @Override
    public List<String> openURLCommand(String string) {
        return Arrays.asList("cmd", "/c", "rundll32 url.dll,FileProtocolHandler \"" + string + "\"");
    }

    @Override
    public c getPlatformUpdateInfo() {
        String string;
        Properties properties = this.loadUpdateProperties();
        if (properties == null) {
            return null;
        }
        Double d2 = this.converToDouble(properties.getProperty("Windows_MajorUpdateVersion"));
        Double d3 = this.converToDouble(properties.getProperty("Windows_MinorUpdateVersion"));
        Double d4 = this.converToDouble(properties.getProperty("Windows_ExeUpdateVersion"));
        String string2 = properties.getProperty("Windows_MajorUpdateUrl");
        String string3 = properties.getProperty("Windows_MinorUpdateUrl");
        String string4 = properties.getProperty("Windows_ExeUpdateUrl");
        String string5 = "Windows_PopupUpdateMessage_" + SWTReader.getCurrentLocale().getLanguage().toLowerCase();
        if (SWTReader.getCurrentLocale().getLanguage().equalsIgnoreCase("en")) {
            string5 = "Windows_PopupUpdateMessage";
        }
        if ((string = properties.getProperty(string5)) == null) {
            string = properties.getProperty("Windows_PopupUpdateMessage");
        }
        String string6 = properties.getProperty("Windows_BlackListedOSVersions");
        String string7 = properties.getProperty("Windows_BlackListedUpdateURL");
        return new c(d2 == null ? -1.0 : d2, d3 == null ? -1.0 : d3, d4 == null ? -1.0 : d4, string2, string3, string4, string, string6, string7);
    }

    @Override
    public boolean isLocalPlatformReaderAvailable() {
        boolean bl = this.isNewLocalPlatformReaderAvailable();
        if (!bl) {
            this.mazamaInstallDir = this.readRegistry(this.getMazamaRegistryKeyInCurrentUser(), "InstallDir");
            this.mazamaInstallDir = this.mazamaInstallDir == null ? this.readRegistry(this.getMazamaRegistryKeyInLocalMachine(), "InstallDir") : this.mazamaInstallDir;
            bl = this.mazamaInstallDir != null;
        }
        return bl;
    }

    private String getMazamaRegistryKeyInCurrentUser() {
        return "HKCU\\Software\\Amazon\\KindleForPC";
    }

    private String getMazamaRegistryKeyInLocalMachine() {
        return "HKLM\\Software\\Amazon\\KindleForPC";
    }

    private boolean isNewLocalPlatformReaderAvailable() {
        this.mazamaInstallDir = this.readRegistry(this.getNewMazamaRegistryKeyInCurrentUser(), "InstallDir");
        this.mazamaInstallDir = this.mazamaInstallDir == null ? this.readRegistry(this.getNewMazamaRegistryKeyInLocalMachine(), "InstallDir") : this.mazamaInstallDir;
        boolean bl = this.mazamaInstallDir != null;
        return bl;
    }

    private String getNewMazamaRegistryKeyInCurrentUser() {
        return "HKCU\\Software\\Amazon\\Kindle\\Install";
    }

    private String getNewMazamaRegistryKeyInLocalMachine() {
        return "HKLM\\Software\\Amazon\\Kindle\\Install";
    }

    private String readRegistry(String string, String string2) {
        try {
            List<String> list = Arrays.asList("cmd", "/c", "reg query \"" + string + "\" /v " + string2);
            g g2 = new g(list, true);
            Process process = g2.b();
            process.waitFor();
            String string3 = g2.c();
            if (!string3.contains("REG_SZ")) {
                return null;
            }
            String[] stringArray = string3.split("REG_SZ");
            return stringArray[stringArray.length - 1].trim();
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, " Exception while reading registry ", exception);
            return null;
        }
    }

    @Override
    public boolean openBookInLocalPlatformReader(String string) {
        if (this.mazamaInstallDir == null) {
            return false;
        }
        try {
            String string2 = this.mazamaInstallDir + "\\" + "Kindle.exe";
            File file = new File(string2);
            if (!file.exists()) {
                string2 = this.mazamaInstallDir + "\\" + "KindleForPC.exe";
            }
            LOG.info("executing command: " + string2 + " " + string);
            Runtime.getRuntime().exec(new String[]{string2, string});
            return true;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "error while opening Kindle Previewer ", iOException);
            return false;
        }
    }

    @Override
    public String getCmdCtrlKey() {
        return "Ctrl";
    }

    @Override
    public int getHeightOfTitleBar() {
        return 31;
    }

    @Override
    public int getHeightOfMenuBar() {
        return 20;
    }

    @Override
    public void setMenuBackGroundColor(Menu menu) {
        Class<?> clazz = menu.getClass();
        try {
            Method method = clazz.getDeclaredMethod("setBackground", Color.class);
            method.setAccessible(true);
            Color color = menu.getShell().getDisplay().getSystemColor(22);
            method.invoke((Object)menu, color);
            method.setAccessible(false);
        }
        catch (Exception exception) {
            this.Log.log(Level.WARNING, "Exception while setting the color for MenuBar ", exception);
        }
    }

    @Override
    public boolean needShellIcon() {
        return true;
    }

    @Override
    public String getDownloadUrlForKindleForPlatform() {
        return this.getconfigProperty("KINDLE_FOR_PC_DOWNLOAD_URL");
    }

    @Override
    public String getKindleForPlatformString() {
        return "Kindle_for_PC";
    }

    @Override
    public boolean playMedia(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        List<String> list = Arrays.asList("cmd", "/C", "rundll32 shell32,ShellExec_RunDLL " + file.getAbsolutePath());
        g g2 = new g(list, true);
        try {
            Process process = g2.b();
            int n2 = process.waitFor();
            if (n2 != 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Unexpected Error While trying to play the media file", iOException);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.WARNING, "Interrupted Exception", interruptedException);
        }
        return true;
    }

    @Override
    public boolean playMediaWith(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        String string2 = new String("cmd /C rundll32 shell32,OpenAs_RunDLL " + file.getAbsolutePath());
        try {
            Process process = Runtime.getRuntime().exec(string2);
            int n2 = process.waitFor();
            return n2 == 0;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, " Exception while trying to play the multimedia in openwith mode", iOException);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.WARNING, " Exception while trying to play the multimedia in openwith mode", interruptedException);
        }
        return false;
    }

    @Override
    public List<String> getExplorerCommand(String string) {
        return Arrays.asList("explorer", "\"" + string + "\"");
    }

    @Override
    public String getExeFileName() {
        return com.amazon.a.a.c;
    }

    @Override
    public String getDownloadExeFileName() {
        return com.amazon.a.a.c;
    }

    @Override
    public List<String> getExecutionStringForRename() {
        String string = System.getProperty("os.name").toLowerCase();
        File file = new File(this.getDownloadExeFileName() + "_tmp");
        File file2 = new File(this.getExeFileName());
        return Arrays.asList("cmd", "/C", "copy /Y " + file.getName() + " " + file2.getName());
    }

    @Override
    public String getFfmpegFileExtension() {
        return ".exe";
    }

    @Override
    public String[] getFfmpegPass1Command(String string, String string2, String string3) {
        String string4 = null;
        string4 = string.equals("iPad") ? "720x480" : "360x240";
        return new String[]{string2, "-i", string3, "-r", "23.98", "-s", string4, "-aspect", "16:9", "-b", "1200k", "-threads", "0", "-vcodec", "libx264", "-flags", "+loop", "-cmp", "+chroma", "-me_range", "16", "-qmin", "10", "-qmax", "51", "-sc_threshold", "40", "-i_qfactor", "0.71", "-refs", "1", "-coder", "0", "-subq", "5", "-bt", "100k", "-me_method", "umh", "-trellis", "2", "-y", "-f", "mp4", "-deinterlace", "-bf", "0", "-g", "250", "-keyint_min", "25", "-rc_eq", "'blurCplx^(1-qComp)'", "-qcomp", "0.6", "-qdiff", "4", "-an", "-pass", "1", "NUL"};
    }

    @Override
    public String[] getFfmpegPass2Command(String string, String string2, String string3, String string4) {
        String string5 = null;
        string5 = string.equals("iPad") ? "720x480" : "360x240";
        return new String[]{string2, "-i", string3, "-r", "23.98", "-s", string5, "-aspect", "16:9", "-b", "1200k", "-ab", "128000", "-threads", "0", "-vcodec", "libx264", "-flags", "+loop", "-cmp", "+chroma", "-me_range", "16", "-qmin", "10", "-qmax", "51", "-sc_threshold", "40", "-i_qfactor", "0.71", "-deblockalpha", "0", "-deblockbeta", "0", "-strict", "experimental", "-acodec", "aac", "-ac", "2", "-refs", "1", "-coder", "0", "-subq", "6", "-bt", "100k", "-me_method", "umh", "-trellis", "2", "-y", "-f", "mp4", "-deinterlace", "-bf", "0", "-g", "250", "-keyint_min", "25", "-rc_eq", "'blurCplx^(1-qComp)'", "-qcomp", "0.6", "-qdiff", "4", "-async", "1", "-ar", "44100", "-maxrate", "1000k", "-minrate", "0k", "-bufsize", "2M", "-pass", "2", string4};
    }

    @Override
    public List<String> getExecutionStringForFileRename(File file, File file2) {
        String string = System.getProperty("os.name").toLowerCase();
        return Arrays.asList("cmd", "/C", "copy /Y " + file2.getName() + " " + file.getName());
    }

    @Override
    public String getNativeReaderUnAvailableString() {
        return SWTReader.getKprMessages().getString("native_reader_not_available_win");
    }

    @Override
    public String getBookNotOpeningInNativeReaderString() {
        return SWTReader.getKprMessages().getString("unable_to_open_book_in_native_reader_win");
    }

    @Override
    public int getTextFontSize() {
        return 10;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessEnvironment");
            Field field = clazz.getDeclaredField("theCaseInsensitiveEnvironment");
            field.setAccessible(true);
            return (Map)field.get(null);
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
    }

    @Override
    public boolean setEnvironmentVariables() {
        return false;
    }

    @Override
    public boolean isForcedThreadDownloading() {
        return false;
    }

    @Override
    public boolean isAutoUpdateStartedDownloading() {
        return false;
    }
}

