/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.epub.reader.swt;

import com.amazon.epub.reader.swt.ac;
import com.amazon.epub.reader.swt.b;
import com.amazon.epub.reader.swt.e;
import com.amazon.epub.reader.swt.g;
import com.amazon.epub.reader.swt.h;
import com.amazon.epub.reader.swt.j;
import com.amazon.epub.reader.swt.k;
import com.amazon.epub.reader.swt.m;
import com.amazon.epub.reader.swt.z;
import com.amazon.kindlepreview.common.reader.a.f;
import com.amazon.kindlepreview.common.reader.c;
import com.amazon.kindlepreview.common.reader.d;
import com.amazon.kindlepreview.common.utils.PlatformUtils;
import com.kindlepreview.a.a.a.a.s;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import net.miginfocom.swt.MigLayout;
import net.miginfocom.swt.SwtComponentWrapper;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTReader {
    private final Logger LOG = Logger.getLogger(SWTReader.class.getName());
    public static final String TITLE = " Previewer";
    public static final double VERSION = 2.8;
    public static final double MOBIGEN_VERSION = 6.2;
    public static final int MOBIGEN_BUILD = 43;
    private final boolean stopAsynchronousTasks;
    public static final String LANGUAGE_PREFERENCE_KEY = "LANGUAGE_PREFERENCE_KEY";
    private static final Preferences readerPreferences = Preferences.userNodeForPackage(SWTReader.class);
    private static final Map<String, Locale> localeMap = new LinkedHashMap<String, Locale>();
    private static Locale currentLocale;
    private static ResourceBundle kprMessages;
    private static ResourceBundle languages;
    private static Hashtable<String, Integer> languageIdMap;
    Shell a;
    Display b;
    private boolean isAsin;
    e c;
    b d;
    h e;
    g f;
    k g;
    com.amazon.epub.reader.h.a h;
    public static String transcodeAutomatically;
    boolean i;
    private Logger iLogger = Logger.getLogger(SWTReader.class.getName());
    protected com.amazon.epub.reader.swt.a.a openBookdialog;
    protected Thread openBookThread;
    protected boolean isCompiling;
    protected boolean isOpening;

    public boolean stopAsynchronousTasks() {
        return this.stopAsynchronousTasks;
    }

    public boolean isAsin() {
        return this.isAsin;
    }

    public void setAsin(boolean bl) {
        this.isAsin = bl;
    }

    public SWTReader(Display display, boolean bl, com.amazon.kindlepreview.common.reader.h h2) {
        this.b = display;
        this.openBookdialog = null;
        this.isCompiling = false;
        this.isOpening = false;
        this.a = new Shell(2288);
        this.a.setImages(com.amazon.epub.reader.swt.a.b.a(this.b));
        SwtComponentWrapper.setMinimumSizeZero((boolean)true);
        this.f = new g(this, this.a);
        this.stopAsynchronousTasks = bl;
        this.h = com.amazon.epub.reader.h.c.a(this.a, this);
        j.n = String.valueOf(2.8);
        this.initializeLocaleMap();
        this.addPreferencesListener();
        this.setDefaultLocale();
        this.initializeReader(h2);
        this.initializeSkinScaleFactorFromPref();
        this.a.addShellListener(new ShellListener(){

            public void shellDeactivated(ShellEvent shellEvent) {
            }

            public void shellDeiconified(ShellEvent shellEvent) {
            }

            public void shellIconified(ShellEvent shellEvent) {
            }

            public void shellActivated(ShellEvent shellEvent) {
            }

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = com.amazon.epub.reader.plat.b.b().closeReaderWindow(SWTReader.this);
            }
        });
        this.a.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SWTReader.this.g.e();
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.a, 18);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent dropTargetEvent) {
                if (!(SWTReader.this.i || SWTReader.this.isCompiling || SWTReader.this.isOpening)) {
                    String[] stringArray = null;
                    FileTransfer fileTransfer = FileTransfer.getInstance();
                    if (fileTransfer.isSupportedType(dropTargetEvent.currentDataType)) {
                        stringArray = (String[])dropTargetEvent.data;
                        SWTReader.this.d().a(stringArray[0]);
                        if (stringArray.length > 1) {
                            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                                SWTReader.this.openBookInNewProcess(stringArray[i2]);
                            }
                        }
                    }
                }
            }
        });
        this.loadTranscodingData();
        com.amazon.epub.reader.plat.a.getUdcDisabled();
    }

    private void initScaleFactorForSkin(com.amazon.kindlepreview.common.reader.h h2, String string) {
        int n2 = readerPreferences.getInt(string, 0);
        if (n2 != 0) {
            h2.a(n2);
        }
    }

    private void initializeSkinScaleFactorFromPref() {
        this.initScaleFactorForSkin(com.amazon.kindlepreview.common.reader.c.r, "PAPERWHITE_SCALE_FACTOR");
        this.initScaleFactorForSkin(com.amazon.kindlepreview.common.reader.c.o, "FIRE_SCALE_FACTOR");
        this.initScaleFactorForSkin(com.amazon.kindlepreview.common.reader.c.p, "FIRE_HD_SCALE_FACTOR");
        this.initScaleFactorForSkin(com.amazon.kindlepreview.common.reader.c.q, "FIRE_HD_8_SCALE_FACTOR");
    }

    private String getScalePrefsKeyForSkin(com.amazon.kindlepreview.common.reader.h h2) {
        if (h2 == com.amazon.kindlepreview.common.reader.c.r) {
            return "PAPERWHITE_SCALE_FACTOR";
        }
        if (h2 == com.amazon.kindlepreview.common.reader.c.o) {
            return "FIRE_SCALE_FACTOR";
        }
        if (h2 == com.amazon.kindlepreview.common.reader.c.p) {
            return "FIRE_HD_SCALE_FACTOR";
        }
        if (h2 == com.amazon.kindlepreview.common.reader.c.q) {
            return "FIRE_HD_8_SCALE_FACTOR";
        }
        return null;
    }

    public void saveScaleFactorForSkin(com.amazon.kindlepreview.common.reader.h h2) {
        if (h2 == null || readerPreferences == null) {
            return;
        }
        int n2 = h2.A();
        String string = this.getScalePrefsKeyForSkin(h2);
        if (string != null) {
            readerPreferences.putInt(string, n2);
            try {
                readerPreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                this.iLogger.log(Level.SEVERE, "Error while flushing the preferences to the backing store " + backingStoreException);
            }
        }
    }

    private void initializeLocaleMap() {
        languages = com.amazon.epub.reader.c.c.a("com.amazon.epub.reader.language.resources.languages");
        this.initializeLanguageIdMap();
        localeMap.put("en", new Locale("en", "US"));
        localeMap.put("fr", new Locale("fr", "FR"));
        localeMap.put("de", new Locale("de", "DE"));
        localeMap.put("it", new Locale("it", "IT"));
        localeMap.put("es", new Locale("es", "ES"));
        localeMap.put("pt", new Locale("pt", "PT"));
        localeMap.put("zh", new Locale("zh", "CN"));
        localeMap.put("ja", new Locale("ja", "JA"));
    }

    private void initializeLanguageIdMap() {
        languageIdMap = new Hashtable();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.amazon.epub.reader.language.resources.languageidmap");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            languageIdMap.put(string, Integer.decode(resourceBundle.getString(string)));
        }
    }

    private void setDefaultLocale() {
        this.iLogger.log(Level.INFO, "Default System Locale is " + Locale.getDefault().toString());
        String string = readerPreferences.get(LANGUAGE_PREFERENCE_KEY, null);
        currentLocale = string == null ? this.getValidDefaultLocale() : localeMap.get(this.getLanguageFromId(Integer.parseInt(string)));
        j.o = currentLocale.getLanguage();
        kprMessages = com.amazon.epub.reader.c.c.a("com.amazon.epub.reader.language.resources.kprmessages", currentLocale);
        SWTReader.a();
    }

    private Locale getValidDefaultLocale() {
        Locale locale = Locale.getDefault();
        if (!localeMap.containsKey(locale.getLanguage())) {
            locale = localeMap.get("en");
        }
        return locale;
    }

    private String getLanguageFromId(int n2) {
        String string = "en";
        for (String string2 : languageIdMap.keySet()) {
            int n3 = languageIdMap.get(string2);
            if (n2 != n3) continue;
            return string2;
        }
        return string;
    }

    private void addPreferencesListener() {
        readerPreferences.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (SWTReader.LANGUAGE_PREFERENCE_KEY.equals(preferenceChangeEvent.getKey())) {
                    currentLocale = (Locale)localeMap.get(SWTReader.this.getLanguageFromId(Integer.parseInt(preferenceChangeEvent.getNewValue())));
                    kprMessages = com.amazon.epub.reader.c.c.a("com.amazon.epub.reader.language.resources.kprmessages", currentLocale);
                    SWTReader.a();
                    com.amazon.epub.reader.a.g();
                    SWTReader.this.c();
                    SWTReader.this.resetViewOnLangChange();
                    SWTReader.this.resetHomePage();
                }
            }
        });
    }

    static void a() {
        com.amazon.kindlepreview.common.reader.c.o.a(SWTReader.getKprMessages().getString("Kindle_for_Android"));
        com.amazon.kindlepreview.common.reader.c.r.a(SWTReader.getKprMessages().getString("Kindle_Touch"));
        com.amazon.kindlepreview.common.reader.c.s.a(SWTReader.getKprMessages().getString("Kindle"));
        com.amazon.kindlepreview.common.reader.c.t.a(SWTReader.getKprMessages().getString("Kindle_DX"));
        com.amazon.kindlepreview.common.reader.c.u.a(SWTReader.getKprMessages().getString("Kindle_for_iPhone"));
        com.amazon.kindlepreview.common.reader.c.v.a(SWTReader.getKprMessages().getString("Kindle_for_iPad"));
    }

    protected void resetViewOnLangChange() {
        this.a.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SWTReader.this.g.j == SWTReader.this.g.k) {
                    SWTReader.this.g.j.b();
                    SWTReader.this.g.j.redraw();
                    SWTReader.this.g.j.update();
                }
                k cfr_ignored_0 = SWTReader.this.g;
                if (k.i == SWTReader.this.g.k) {
                    k cfr_ignored_1 = SWTReader.this.g;
                    k.i.a_();
                    k cfr_ignored_2 = SWTReader.this.g;
                    k.i.redraw();
                    k cfr_ignored_3 = SWTReader.this.g;
                    k.i.update();
                }
                if (SWTReader.this.g != null && SWTReader.this.g.v != null && SWTReader.this.g.y()) {
                    SWTReader.this.g.v.a();
                }
            }
        });
    }

    private void resetHomePage() {
        this.a.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SWTReader.this.g != null && SWTReader.this.g.c != null) {
                    SWTReader.this.g.c.b();
                }
            }
        });
    }

    void b() {
        this.a.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTReader.this.c.e();
            }
        });
    }

    void c() {
        this.a.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTReader.this.c.e();
                SWTReader.this.e.f();
                SWTReader.this.a(SWTReader.this.g.x(), SWTReader.this.g.y());
                if (SWTReader.this.g.y()) {
                    SWTReader.this.g.d();
                    SWTReader.this.c.h(SWTReader.this.g.z().n() && SWTReader.this.g.T.equals((Object)com.amazon.kindlepreview.common.reader.a.e.a));
                }
                SWTReader.this.d.c();
                String string = SWTReader.this.g.z().i() + SWTReader.TITLE;
                if (SWTReader.this.g.x() != null) {
                    string = string + " - " + SWTReader.this.g.x().C().a();
                }
                SWTReader.this.a(string);
                Shell[] shellArray = SWTReader.this.a.getDisplay().getShells();
                for (int i2 = 0; i2 < shellArray.length; ++i2) {
                    if (shellArray[i2].isDisposed()) continue;
                    shellArray[i2].notifyListeners(13, new Event());
                }
            }
        });
    }

    private void loadTranscodingData() {
        String string = System.getProperty("user.dir") + File.separator + "previewerstate.properties";
        File file = new File(string);
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.iLogger.log(Level.INFO, "Exception while searching for properties file", fileNotFoundException);
            }
            catch (IOException iOException) {
                this.iLogger.log(Level.INFO, "Exception while Reading the data into the properties object", iOException);
            }
        }
        if (com.amazon.epub.reader.plat.b.b().getFfmpegPath() == null || com.amazon.epub.reader.plat.b.b().getFfmpegPath().equals("")) {
            com.amazon.epub.reader.plat.b.b().setFfmpegPath(properties.getProperty("FFmpeg_library_Path"));
        }
        transcodeAutomatically = properties.getProperty("Transcode_Automatically") != null ? properties.getProperty("Transcode_Automatically") : "true";
        this.getMenuBar().e().getItem(2).setSelection(Boolean.parseBoolean(transcodeAutomatically));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String string) {
        if (!this.stopAsynchronousTasks) {
            this.a.layout();
            this.a.pack();
            this.a.open();
        }
        if (string != null) {
            try {
                this.d().a(string);
            }
            catch (Exception exception) {
                this.showErrorMessage(kprMessages.getString("could_not_open_book") + string, kprMessages.getString("error_opening_book"));
                this.iLogger.log(Level.WARNING, "Could not open book " + string, exception);
            }
        }
        if (!this.stopAsynchronousTasks) {
            boolean bl = false;
            while (!this.a.isDisposed()) {
                Object var6_6;
                try {
                    block12: {
                        try {
                            if (this.b.readAndDispatch()) break block12;
                            this.b.sleep();
                        }
                        catch (Exception exception) {
                            bl = true;
                            this.iLogger.log(Level.SEVERE, "Unexpected Error", exception);
                            j.p = true;
                            com.amazon.b.a.l = true;
                            if (!this.a.isDisposed()) {
                                String string2 = kprMessages.getString("book_unexpected_error") + kprMessages.getString("contact_amazon");
                                this.showErrorMessage(string2, kprMessages.getString("unexpected_error"));
                            }
                            var6_6 = null;
                            if (!bl || this.a.isDisposed()) continue;
                            this.a.dispose();
                            continue;
                        }
                    }
                    var6_6 = null;
                    if (!bl) continue;
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    if (bl && !this.a.isDisposed()) {
                        this.a.dispose();
                    }
                    throw throwable;
                }
                if (this.a.isDisposed()) continue;
                this.a.dispose();
            }
        }
    }

    public com.amazon.epub.reader.h.a getAsin() {
        return this.h;
    }

    private void initializeReader(com.amazon.kindlepreview.common.reader.h h2) {
        MigLayout migLayout = new MigLayout();
        migLayout.setLayoutConstraints((Object)"fill, gap 0 0, novisualpadding, ins 0");
        this.a.setLayout((Layout)migLayout);
        this.e = new h(this, this.a);
        this.e.a(true);
        this.c = new e(this, this.a);
        this.c.a();
        this.c.a(false);
        this.d = new b(this, this.a);
        this.d.a();
        this.g = new k(this.a, this, h2);
        this.g.a(h2);
        j.a();
        File file = new File(com.amazon.a.a.f);
        if (file.exists()) {
            j.a("1");
            String string = PlatformUtils.getGenericLibPath("touchLibs" + File.separator + "etc" + File.separator + "fonts" + File.separator + "fontconfig");
            File file2 = new File(string);
            if (file2.exists() && file2.isDirectory()) {
                com.amazon.a.a.b(string);
            }
            file.delete();
        }
    }

    public h getMenuBar() {
        return this.e;
    }

    public k getPreviewManager() {
        return this.g;
    }

    z d() {
        ac ac2 = new ac(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(String string) {
                f f2 = com.amazon.kindlepreview.common.utils.d.a(string);
                if (f2 == null) {
                    SWTReader.this.showErrorMessage(kprMessages.getString("unsupported_file_format"), kprMessages.getString("file_error"));
                    SWTReader.this.iLogger.log(Level.INFO, "Error opening book " + string);
                    return;
                }
                if (f2 == com.amazon.kindlepreview.common.reader.a.f.b || f2 == com.amazon.kindlepreview.common.reader.a.f.a || f2 == com.amazon.kindlepreview.common.reader.a.f.c) {
                    try {
                        com.amazon.kindlepreview.common.utils.j j2 = new com.amazon.kindlepreview.common.utils.j();
                        s s2 = new s(string, j2);
                        if (s2.e()) {
                            SWTReader.this.showErrorMessage(kprMessages.getString("encrypted_book"), kprMessages.getString("encrypted_kindle_book"));
                            return;
                        }
                    }
                    catch (com.kindlepreview.a.a.a.a.k k2) {
                        SWTReader.this.showErrorMessage(kprMessages.getString("unsupported_file_format"), kprMessages.getString("file_error"));
                        SWTReader.this.iLogger.log(Level.INFO, "Error opening book", k2);
                        return;
                    }
                }
                SWTReader.this.isAsin = false;
                SWTReader.this.openBookdialog = new com.amazon.epub.reader.swt.a.a(){

                    protected void a(Shell shell) {
                        shell.setLayout((Layout)new MigLayout());
                        shell.setText(kprMessages.getString("opening_eBook"));
                        Label label = new Label((Composite)shell, 0);
                        label.setText(kprMessages.getString("kpr_opening_book"));
                    }
                };
                SWTReader.this.openBookdialog.a(SWTReader.this.a, 67616);
                SWTReader.this.isOpening = true;
                try {
                    SWTReader.this.openBook(string);
                    Object var6_6 = null;
                    SWTReader.this.openBookdialog.a();
                    SWTReader.this.openBookdialog = null;
                    SWTReader.this.isOpening = false;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    SWTReader.this.openBookdialog.a();
                    SWTReader.this.openBookdialog = null;
                    SWTReader.this.isOpening = false;
                    throw throwable;
                }
            }
        };
        return new z(this.a, this, ac2);
    }

    void e() {
        this.d().a();
    }

    void a(String string) {
        this.a.setText(string);
    }

    protected void openGotoUserLocationDialog() {
        if (this.g.x() == null || this.g.x().C() == null) {
            return;
        }
        m.a(this.a, this.g);
    }

    protected void openSearchDialog() {
        m.b(this.a, this.g);
    }

    public void openBookInNewProcess(String string) {
        this.LOG.info("building process builder");
        String string2 = com.amazon.epub.reader.plat.b.b().getExeFileName();
        List<String> list = Arrays.asList(string2, string);
        com.amazon.epub.reader.c.d d2 = new com.amazon.epub.reader.c.d(list, true);
        this.LOG.info("open in new Process command" + list);
        try {
            this.LOG.info("starting open Book in a new window");
            d2.a();
        }
        catch (IOException iOException) {
            this.LOG.log(Level.SEVERE, "exception while running update for KindlePreviewer.exe ", iOException);
            this.showErrorMessage(kprMessages.getString("exception_running_kpr_process"), kprMessages.getString("IO_Error"));
        }
    }

    public void openBook(String string) {
        this.g.n();
        try {
            this.g.a(string);
        }
        catch (com.kindlepreview.a.a.a.a.k k2) {
            this.a(null, false);
            this.iLogger.log(Level.SEVERE, "Rendering library failed to open book ", k2);
            String string2 = k2.getMessage();
            String string3 = string2.equals(com.kindlepreview.a.a.a.a.k.b) ? kprMessages.getString("invalid_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.j) ? kprMessages.getString("unsupported_book_file_format") : (string2.equals(com.kindlepreview.a.a.a.a.k.c) ? kprMessages.getString("corrupted_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.a) ? kprMessages.getString("expired_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.e) ? kprMessages.getString("locked_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.i) ? kprMessages.getString("unsupported_multipart_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.h) ? kprMessages.getString("inactive_book") : (string2.equals(com.kindlepreview.a.a.a.a.k.k) ? kprMessages.getString("wrong_file_format") : (string2.equals(com.kindlepreview.a.a.a.a.k.d) ? kprMessages.getString("unknown_error") : (string2.equals(com.kindlepreview.a.a.a.a.k.f) ? kprMessages.getString("password_required") : (string2.equals(com.kindlepreview.a.a.a.a.k.g) ? kprMessages.getString("book_not_allowed") : kprMessages.getString("unexpected_error_occurred")))))))))));
            this.showErrorMessage(string3, kprMessages.getString("open_error"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.iLogger.log(Level.SEVERE, "Error opening book " + string, exception);
            com.amazon.kindlepreview.common.reader.c.b();
            this.showErrorMessage(kprMessages.getString("error_opening_book") + exception.getMessage(), kprMessages.getString("open_error"));
        }
    }

    public void closeReader() {
        if (this.g != null) {
            this.g.n();
        }
    }

    void a(d d2, boolean bl) {
        this.c.a(bl);
        this.e.a(d2, bl);
    }

    public void showWarningMessage(String string, String string2) {
        this.displayMessage(string2 + "\n" + string, 40);
    }

    public void showErrorMessage(String string, String string2) {
        this.displayMessage(string2 + "\n" + string, 33);
    }

    private void displayMessage(String string, int n2) {
        MessageBox messageBox = new MessageBox(this.a, n2);
        messageBox.setText(this.a.getText());
        messageBox.setMessage(string);
        messageBox.open();
    }

    void a(boolean bl) {
        this.c.d();
    }

    public String getTranscodeAutomatically() {
        return transcodeAutomatically;
    }

    public void setTranscodeAutomatically(String string) {
        transcodeAutomatically = string;
    }

    public static Preferences getReaderpreferences() {
        return readerPreferences;
    }

    public static Map<String, Locale> getLocalemap() {
        return localeMap;
    }

    public static String getLanguageCode(String string) {
        Enumeration<String> enumeration = languages.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string.equals(languages.getString(string2))) continue;
            return string2;
        }
        return "en";
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static ResourceBundle getKprMessages() {
        return kprMessages;
    }

    public static Hashtable<String, Integer> getLanguageIdMap() {
        return languageIdMap;
    }

    public static ResourceBundle getLanguages() {
        return languages;
    }

    public void setIsCompiling(boolean bl) {
        this.isCompiling = bl;
    }

    public Shell getShell() {
        return this.a;
    }

    class a
    extends SelectionAdapter {
        final int a;

        public a(int n2) {
            this.a = n2;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            SWTReader.this.g.b(this.a);
        }
    }
}

