/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindlepreview.common.language;

import com.amazon.kindlepreview.common.language.LanguageTagData;
import com.amazon.kindlepreview.common.language.LookupMatcher;
import com.amazon.kindlepreview.common.language.Subtag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LanguageTag {
    public static final int LANGUAGE = 1;
    public static final int EXTLANG = 2;
    public static final int SCRIPT = 3;
    public static final int REGION = 4;
    public static final int VARIANT = 5;
    public static final int EXTENSION = 6;
    public static final int PRIVATE = 7;
    private static final String[] TYPES = new String[]{"grandfathered", "language", "extlang", "script", "region", "variant"};
    private static final List irregular;
    private static LookupMatcher LOCALE_MATCHER;
    private static Hashtable LOCALES;
    protected static final String[] IRREGULARS;
    private static Hashtable lcidMappings;

    private static boolean isValidSubtag(int n2, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!LanguageTag.checkSubtagContents(n2, string)) {
            return false;
        }
        string = string.toLowerCase(Locale.US);
        switch (n2) {
            case 1: {
                return LanguageTagData.a().b(string);
            }
            case 2: {
                return Arrays.binarySearch(LanguageTagData.a().c, string) >= 0;
            }
            case 3: {
                char[] cArray = string.toCharArray();
                cArray[0] = Character.toUpperCase(cArray[0]);
                string = new String(cArray);
                return Arrays.binarySearch(LanguageTagData.a().d, string) >= 0;
            }
            case 4: {
                return LanguageTagData.a().a(string);
            }
            case 5: {
                return Arrays.binarySearch(LanguageTagData.a().g, string) >= 0;
            }
        }
        return true;
    }

    private static boolean isAlpha(char c2) {
        return c2 > '`' && c2 < '{' || c2 > '@' && c2 < '[';
    }

    private static boolean isDigit(char c2) {
        return c2 > '/' && c2 < '@';
    }

    private static boolean isAlnum(char c2) {
        return LanguageTag.isAlpha(c2) || LanguageTag.isDigit(c2);
    }

    private static Subtag[] parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        Subtag[] subtagArray = new Subtag[stringTokenizer.countTokens()];
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n4 = string2.length();
            if (n4 == 1 && string2.equalsIgnoreCase("x")) {
                n3 = 7;
                subtagArray[n2] = new Subtag(n3, string2);
                bl = true;
                ++n2;
                continue;
            }
            if (n4 == 1 && n2 > 0 && !bl && LanguageTag.isAlnum(string2.charAt(0))) {
                n3 = 6;
                subtagArray[n2] = new Subtag(n3, string2);
                ++n2;
                continue;
            }
            if (LanguageTag.checkSubtagContents(n3, string2)) {
                subtagArray[n2] = new Subtag(n3, string2);
                ++n2;
                if (n3 >= 5) continue;
                ++n3;
                continue;
            }
            if (n2 == 0) {
                return null;
            }
            boolean bl2 = false;
            while (n3 < 6) {
                if (LanguageTag.checkSubtagContents(n3, string2)) {
                    subtagArray[n2] = new Subtag(n3, string2);
                    ++n2;
                    if (n3 < 5) {
                        ++n3;
                    }
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (bl2) continue;
            return null;
        }
        return subtagArray;
    }

    private static boolean checkSubtagContents(int n2, String string) {
        if (string == null) {
            return false;
        }
        int n3 = string.length();
        if (n3 < 2 && n2 != 7) {
            return false;
        }
        if (n3 > 8) {
            return false;
        }
        boolean bl = false;
        if (n2 > 3) {
            bl = true;
        }
        string = string.toLowerCase(Locale.US);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (LanguageTag.isAlpha(c2)) {
                bl4 = true;
                continue;
            }
            if (LanguageTag.isDigit(c2) && bl) {
                if (i2 == 0) {
                    bl2 = true;
                }
                bl3 = true;
                continue;
            }
            return false;
        }
        switch (n2) {
            case 1: {
                return true;
            }
            case 2: {
                return n3 == 3;
            }
            case 3: {
                return n3 == 4;
            }
            case 4: {
                if (bl2 && n3 == 3 && !bl4) {
                    return true;
                }
                return n3 == 2 && !bl3;
            }
            case 5: {
                if (bl2 && n3 < 4) {
                    return false;
                }
                return bl2 || n3 >= 5;
            }
            case 6: {
                return n3 > 1;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean has(int n2, String string) {
        Subtag[] subtagArray = LanguageTag.parse(string);
        if (subtagArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            if (subtagArray[i2].a == n2) {
                return true;
            }
            if (subtagArray[i2].a <= n2) continue;
            return false;
        }
        return false;
    }

    public static String get(int n2, String string) {
        Subtag[] subtagArray = LanguageTag.parse(string);
        if (subtagArray == null) {
            return "";
        }
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            if (subtagArray[i2].a == n2) {
                return subtagArray[i2].b;
            }
            if (subtagArray[i2].a <= n2) continue;
            return "";
        }
        return "";
    }

    public static boolean isWellFormed(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (LanguageTag.isGrandfathered(string)) {
            return true;
        }
        if (irregular.contains(string.toLowerCase(Locale.US))) {
            return true;
        }
        Subtag[] subtagArray = LanguageTag.parse(string);
        if (subtagArray == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            int n2 = subtagArray[i2].a;
            String string2 = subtagArray[i2].b.toLowerCase(Locale.US);
            if (string2.length() == 1) {
                char c2 = string2.charAt(0);
                if (!bl3) {
                    if (c2 == 'x') {
                        bl3 = true;
                        continue;
                    }
                    if (bl && !bl2) {
                        return false;
                    }
                    bl = true;
                    bl2 = false;
                    continue;
                }
            } else if (!LanguageTag.checkSubtagContents(n2, string2)) {
                return false;
            }
            if (!bl) continue;
            bl2 = true;
        }
        return true;
    }

    public static boolean isWellFormed3066Tag(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("-")) {
                if (n2 == 0 || bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (string2.length() > 8) {
                return false;
            }
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if ((n2 != 0 || LanguageTag.isAlpha(string2.charAt(i2))) && LanguageTag.isAlnum(string2.charAt(i2))) continue;
                return false;
            }
            ++n2;
            bl = false;
        }
        return !bl;
    }

    public static String getCanonicalValue(Subtag subtag) {
        String string;
        if (subtag == null) {
            return "";
        }
        switch (subtag.a) {
            case 1: {
                string = "language";
                break;
            }
            case 3: {
                string = "script";
                break;
            }
            case 4: {
                string = "region";
                break;
            }
            case 5: {
                string = "variant";
                break;
            }
            default: {
                string = "";
            }
        }
        String string2 = LanguageTagData.a().a(string, subtag.b.toLowerCase(Locale.US));
        subtag.b = string2 == null ? subtag.b : string2;
        return subtag.normalizeCase();
    }

    public static boolean isGrandfathered(String string) {
        return LanguageTagData.a().a(string, false);
    }

    private static String mapGrandfathered(String string) {
        if (!LanguageTag.isGrandfathered(string)) {
            return string;
        }
        String string2 = LanguageTagData.a().a("grandfathered", string.toLowerCase(Locale.US));
        return string2 == null ? string : string2;
    }

    public static boolean isRedundant(String string) {
        return LanguageTagData.a().a(string, true);
    }

    public static String canonicalize(String string) {
        Subtag[] subtagArray;
        if (string == null || string.length() == 0) {
            return "";
        }
        if (LanguageTag.isGrandfathered(string) && !LanguageTag.isRedundant(string)) {
            string = LanguageTag.mapGrandfathered(string);
        }
        if ((subtagArray = LanguageTag.parse(string)) == null) {
            return string;
        }
        if (!LanguageTag.isWellFormed(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "-";
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            stringBuffer.append(string2);
            stringBuffer.append(LanguageTag.getCanonicalValue(subtagArray[i2]));
        }
        if (LanguageTag.has(2, string) && LanguageTag.isValidSubtag(2, LanguageTag.get(2, string))) {
            return stringBuffer.substring(stringBuffer.indexOf(string2, 1) + 1);
        }
        return stringBuffer.substring(1);
    }

    public static boolean isValid(String string) {
        if (LanguageTag.isGrandfathered(string)) {
            return true;
        }
        if (!LanguageTag.isWellFormed(string)) {
            return false;
        }
        Subtag[] subtagArray = LanguageTag.parse(string);
        if (subtagArray == null) {
            return false;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            String string2 = subtagArray[i2].b.toLowerCase(Locale.US);
            if (string2.length() == 1) {
                char c2 = string2.charAt(0);
                if (bl) continue;
                if (c2 == 'x') {
                    bl = true;
                    continue;
                }
                if (stringBuffer.indexOf(string2) >= 0) {
                    return false;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (LanguageTag.isValidSubtag(subtagArray[i2].a, subtagArray[i2].b)) continue;
            return false;
        }
        return true;
    }

    public static Locale toLocale(String string) {
        if (string == null || string.length() == 0) {
            return new Locale("", "");
        }
        Locale locale = (Locale)LOCALES.get(LOCALE_MATCHER.match(string));
        if (locale == null || locale.getLanguage().equals("")) {
            String string2 = LanguageTag.get(1, string);
            String string3 = LanguageTag.get(4, string);
            String string4 = LanguageTag.get(LanguageTag.has(5, string) ? 5 : 7, string);
            locale = new Locale(string2, string3, string4.toUpperCase(Locale.US));
        }
        return locale;
    }

    public static String toLanguage(Locale locale) {
        if (locale == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(locale.getLanguage());
        if (locale.getCountry().length() > 0) {
            stringBuffer.append('-');
            stringBuffer.append(locale.getCountry());
        }
        if (locale.getVariant().length() > 0) {
            stringBuffer.append("-x-");
            stringBuffer.append(locale.getVariant().toLowerCase(Locale.US));
        }
        return stringBuffer.toString();
    }

    public static String getDefault() {
        return LanguageTag.toLanguage(Locale.getDefault());
    }

    public static boolean filterMatches(String string, String string2) {
        string = LanguageTag.canonicalize(string);
        string2 = LanguageTag.canonicalize(string2);
        int n2 = string.length();
        int n3 = string2.length();
        if (n3 > n2) {
            String string3 = string2;
            string2 = string;
            string = string3;
        } else if (n3 == n2) {
            return string.equalsIgnoreCase(string2);
        }
        return string.startsWith(string2 + '-');
    }

    public static int compare(String string, String string2) {
        Subtag[] subtagArray = LanguageTag.parse(LanguageTag.canonicalize(string));
        Subtag[] subtagArray2 = LanguageTag.parse(LanguageTag.canonicalize(string2));
        if (subtagArray == null && subtagArray2 == null) {
            return 0;
        }
        if (subtagArray == null) {
            return -1;
        }
        if (subtagArray2 == null) {
            return 1;
        }
        for (int i2 = 0; i2 < subtagArray.length; ++i2) {
            if (i2 > subtagArray2.length - 1) {
                return 1;
            }
            int n2 = subtagArray[i2].b.compareToIgnoreCase(subtagArray2[i2].b);
            if (n2 == 0) continue;
            return n2;
        }
        return subtagArray2.length > subtagArray.length ? -1 : 0;
    }

    public static String truncate(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || string.indexOf(45) == -1) {
            return "";
        }
        if (string.startsWith("-")) {
            return "";
        }
        int n3 = string.lastIndexOf(45);
        return n3 > (n2 = string.lastIndexOf(45, n3 - 1)) + 2 || n2 < 0 ? string.substring(0, n3) : string.substring(0, n2);
    }

    public static String fromLCID(int n2) {
        Integer n3;
        if (n2 < 0) {
            return "";
        }
        if (lcidMappings == null) {
            LanguageTag.initLcids();
        }
        if (lcidMappings.containsKey(n3 = new Integer(n2))) {
            return (String)lcidMappings.get(n3);
        }
        return "";
    }

    private static void initLcids() {
        lcidMappings = new Hashtable();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.amazon.kindlepreview.common.language.LcidMappings");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            int n2 = Integer.decode(resourceBundle.getString(string));
            lcidMappings.put(new Integer(n2), string);
            if (lcidMappings.containsKey(new Integer(n2 & 0xFF)) || (string = LanguageTag.get(1, string)) == null) continue;
            lcidMappings.put(new Integer(n2 & 0xFF), string);
        }
    }

    static {
        LOCALES = new Hashtable();
        IRREGULARS = new String[]{"en-gb-oed", "i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo", "i-navajo", "i-pwn", "i-tao", "i-tay", "i-tsu", "sgn-be-fr", "sgn-be-nl", "sgn-ch-de"};
        irregular = new ArrayList();
        for (int i2 = 0; i2 < IRREGULARS.length; ++i2) {
            irregular.add(IRREGULARS[i2]);
        }
        LOCALE_MATCHER = new LookupMatcher("");
        LOCALES.put("", new Locale("", ""));
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i3 = 0; i3 < localeArray.length; ++i3) {
            String string = LanguageTag.toLanguage(localeArray[i3]);
            LOCALE_MATCHER.addLanguage(string);
            LOCALES.put(string, localeArray[i3]);
        }
    }
}

