/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindlepreview.common.language;

import com.amazon.kindlepreview.common.language.LanguageTag;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class LookupMatcher {
    private String root;
    private Set list;

    public LookupMatcher(String string) {
        this(string, "");
    }

    public LookupMatcher(String string, String string2) {
        if (string == null) {
            string = "";
        }
        this.list = this.parseList(string);
        if (string2 == null) {
            string2 = "";
        }
        this.root = string2;
    }

    public Iterator available() {
        return this.list.iterator();
    }

    public void addLanguage(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.list.contains(string)) {
            return;
        }
        this.list.add(string);
    }

    public boolean removeLanguage(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (String string2 : this.list) {
            if (!string2.equalsIgnoreCase(string)) continue;
            this.list.remove(string2);
            return true;
        }
        return false;
    }

    public void setRoot(String string) {
        if (string == null || string.length() == 0) {
            this.root = "";
        }
        this.root = LanguageTag.canonicalize(string);
    }

    public String getRoot() {
        return this.root;
    }

    public String match(String string) {
        if (string == null || string.length() == 0) {
            return this.root;
        }
        if (string.equals("*")) {
            return this.root;
        }
        Set set = this.parseList(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = this.rangeMatch(this.fixExtRange((String)iterator.next()));
            if (string2 == null) continue;
            return string2;
        }
        return this.root;
    }

    private String rangeMatch(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("*")) {
            return null;
        }
        Iterator iterator = this.list.iterator();
        string = string.trim();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.equalsIgnoreCase(string2)) {
                return string;
            }
            if (!string.toLowerCase(Locale.US).startsWith(string2.toLowerCase(Locale.US)) || string2.length() > string.length() || string.charAt(string2.length()) != '-') continue;
            return string2;
        }
        return null;
    }

    private String fixExtRange(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n2 = string.indexOf(42);
        if (n2 < 0) {
            return string;
        }
        if (n2 == 0) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) continue;
            stringBuffer.append('-').append(string2);
            ++n3;
        }
        if (n3 > 0) {
            return stringBuffer.substring(1);
        }
        return "";
    }

    private Set parseList(String string) {
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2) * -1;
            }
        });
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            treeSet.add(((String)stringTokenizer.nextElement()).trim());
        }
        return treeSet;
    }
}

