/*
 * Decompiled with CFR 0.152.
 */
package com.kindlepreview.amazon.system.drawing;

import java.io.Serializable;

public class Rectangle
implements Serializable {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public Rectangle(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public Rectangle(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public boolean contains(int n2, int n3) {
        return n2 > this.x && n2 < this.x + this.width && n3 > this.y && n3 < this.y + this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setLocation(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public Rectangle union(Rectangle rectangle) {
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.x + this.width, rectangle.x + rectangle.width) - n2;
        int n5 = Math.max(this.y + this.height, rectangle.y + rectangle.height) - n3;
        return new Rectangle(n2, n3, n4, n5);
    }

    public void translate(int n2, int n3) {
        this.x += n2;
        this.y += n3;
    }

    public void expand(int n2, int n3) {
        this.x -= n2;
        this.y -= n3;
        this.width += 2 * n2;
        this.height += 2 * n3;
    }

    public void add(Rectangle rectangle) {
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.x + this.width, rectangle.x + rectangle.width) - n2;
        int n5 = Math.max(this.y + this.height, rectangle.y + rectangle.height) - n3;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n2 = 0;
        if (this.x < rectangle.x && this.x + this.width > rectangle.x) {
            n2 = rectangle.x;
        } else if (rectangle.x <= this.x && rectangle.x + rectangle.width > this.x) {
            n2 = this.x;
        } else {
            return new Rectangle(0, 0, -1, -1);
        }
        int n3 = 0;
        if (this.y < rectangle.y && this.y + this.height > rectangle.y) {
            n3 = rectangle.y;
        } else if (rectangle.y <= this.y && rectangle.y + rectangle.height > this.y) {
            n3 = this.y;
        } else {
            return new Rectangle(0, 0, -1, -1);
        }
        int n4 = Math.min(this.x + this.width, rectangle.x + rectangle.width);
        int n5 = Math.min(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        return n2 < this.x + this.width && n3 < this.y + this.height && n2 + n4 > this.x && n3 + n5 > this.y;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            return false;
        }
        return rectangle == this || this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

