/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreePhysicalRowIdPageManager {
    protected RecordFile _file;
    protected PageManager _pageman;

    FreePhysicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this._file = file;
        this._pageman = pageman;
    }

    Location get(int size) throws IOException {
        Location retval = null;
        PageCursor curs = new PageCursor(this._pageman, 4);
        while (curs.next() != 0L) {
            FreePhysicalRowIdPage fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(this._file.get(curs.getCurrent()));
            int slot = fp.getFirstLargerThan(size);
            if (slot != -1) {
                retval = new Location(fp.get(slot));
                fp.get(slot).getSize();
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this._file.release(curs.getCurrent(), false);
                    this._pageman.free((short)4, curs.getCurrent());
                } else {
                    this._file.release(curs.getCurrent(), true);
                }
                return retval;
            }
            this._file.release(curs.getCurrent(), false);
        }
        return null;
    }

    void put(Location rowid, int size) throws IOException {
        FreePhysicalRowIdPage fp;
        BlockIo curBlock;
        PhysicalRowId free = null;
        PageCursor curs = new PageCursor(this._pageman, 4);
        long freePage = 0L;
        while (curs.next() != 0L) {
            freePage = curs.getCurrent();
            curBlock = this._file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            int slot = fp.getFirstFree();
            if (slot != -1) {
                free = fp.alloc(slot);
                break;
            }
            this._file.release(curBlock);
        }
        if (free == null) {
            freePage = this._pageman.allocate((short)4);
            curBlock = this._file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            free = fp.alloc(0);
        }
        free.setBlock(rowid.getBlock());
        free.setOffset(rowid.getOffset());
        ((FreePhysicalRowId)free).setSize(size);
        this._file.release(freePage, true);
    }
}

