/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.DataPage;
import jdbm.recman.FreePhysicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;
import jdbm.recman.RecordHeader;

final class PhysicalRowIdManager {
    private RecordFile file;
    private PageManager pageman;
    private FreePhysicalRowIdPageManager freeman;

    PhysicalRowIdManager(RecordFile file, PageManager pageManager) throws IOException {
        this.file = file;
        this.pageman = pageManager;
        this.freeman = new FreePhysicalRowIdPageManager(file, this.pageman);
    }

    Location insert(byte[] data, int start, int length) throws IOException {
        Location retval = this.alloc(length);
        this.write(retval, data, start, length);
        return retval;
    }

    Location update(Location rowid, byte[] data, int start, int length) throws IOException {
        BlockIo block = this.file.get(rowid.getBlock());
        RecordHeader head = new RecordHeader(block, rowid.getOffset());
        if (length > head.getAvailableSize()) {
            this.file.release(block);
            this.free(rowid);
            rowid = this.alloc(length);
        } else {
            this.file.release(block);
        }
        this.write(rowid, data, start, length);
        return rowid;
    }

    void delete(Location rowid) throws IOException {
        this.free(rowid);
    }

    byte[] fetch(Location rowid) throws IOException {
        PageCursor curs = new PageCursor(this.pageman, rowid.getBlock());
        BlockIo block = this.file.get(curs.getCurrent());
        RecordHeader head = new RecordHeader(block, rowid.getOffset());
        byte[] retval = new byte[head.getCurrentSize()];
        if (retval.length == 0) {
            this.file.release(curs.getCurrent(), false);
            return retval;
        }
        int offsetInBuffer = 0;
        int leftToRead = retval.length;
        int dataOffset = rowid.getOffset() + 8;
        while (leftToRead > 0) {
            int toCopy = 8192 - dataOffset;
            if (leftToRead < toCopy) {
                toCopy = leftToRead;
            }
            System.arraycopy(block.getData(), dataOffset, retval, offsetInBuffer, toCopy);
            offsetInBuffer += toCopy;
            this.file.release(block);
            if ((leftToRead -= toCopy) <= 0) continue;
            block = this.file.get(curs.next());
            dataOffset = 20;
        }
        return retval;
    }

    private Location alloc(int size) throws IOException {
        Location retval = this.freeman.get(size);
        if (retval == null) {
            retval = this.allocNew(size, this.pageman.getLast((short)1));
        }
        return retval;
    }

    private Location allocNew(int size, long start) throws IOException {
        DataPage curPage;
        BlockIo curBlock;
        if (start == 0L) {
            start = this.pageman.allocate((short)1);
            curBlock = this.file.get(start);
            curPage = DataPage.getDataPageView(curBlock);
            curPage.setFirst((short)20);
            RecordHeader hdr = new RecordHeader(curBlock, 20);
            hdr.setAvailableSize(0);
            hdr.setCurrentSize(0);
        } else {
            curBlock = this.file.get(start);
            curPage = DataPage.getDataPageView(curBlock);
        }
        short pos = curPage.getFirst();
        if (pos == 0) {
            this.file.release(curBlock);
            return this.allocNew(size, 0L);
        }
        RecordHeader hdr = new RecordHeader(curBlock, pos);
        while (hdr.getAvailableSize() != 0 && pos < 8192) {
            if ((pos = (short)(pos + (hdr.getAvailableSize() + 8))) == 8192) {
                this.file.release(curBlock);
                return this.allocNew(size, 0L);
            }
            hdr = new RecordHeader(curBlock, pos);
        }
        if (pos == 8) {
            this.file.release(curBlock);
        }
        Location retval = new Location(start, pos);
        int freeHere = 8192 - pos - 8;
        if (freeHere < size) {
            int neededLeft;
            int lastSize = (size - freeHere) % 8172;
            if (8172 - lastSize < 24) {
                size += 8172 - lastSize;
            }
            hdr.setAvailableSize(size);
            this.file.release(start, true);
            for (neededLeft = size - freeHere; neededLeft >= 8172; neededLeft -= 8172) {
                start = this.pageman.allocate((short)1);
                curBlock = this.file.get(start);
                curPage = DataPage.getDataPageView(curBlock);
                curPage.setFirst((short)0);
                this.file.release(start, true);
            }
            if (neededLeft > 0) {
                start = this.pageman.allocate((short)1);
                curBlock = this.file.get(start);
                curPage = DataPage.getDataPageView(curBlock);
                curPage.setFirst((short)(20 + neededLeft));
                this.file.release(start, true);
            }
        } else {
            if (freeHere - size <= 24) {
                size = freeHere;
            }
            hdr.setAvailableSize(size);
            this.file.release(start, true);
        }
        return retval;
    }

    private void free(Location id) throws IOException {
        BlockIo curBlock = this.file.get(id.getBlock());
        DataPage.getDataPageView(curBlock);
        RecordHeader hdr = new RecordHeader(curBlock, id.getOffset());
        hdr.setCurrentSize(0);
        this.file.release(id.getBlock(), true);
        this.freeman.put(id, hdr.getAvailableSize());
    }

    private void write(Location rowid, byte[] data, int start, int length) throws IOException {
        PageCursor curs = new PageCursor(this.pageman, rowid.getBlock());
        BlockIo block = this.file.get(curs.getCurrent());
        RecordHeader hdr = new RecordHeader(block, rowid.getOffset());
        hdr.setCurrentSize(length);
        if (length == 0) {
            this.file.release(curs.getCurrent(), true);
            return;
        }
        int offsetInBuffer = start;
        int leftToWrite = length;
        int dataOffset = rowid.getOffset() + 8;
        while (leftToWrite > 0) {
            int toCopy = 8192 - dataOffset;
            if (leftToWrite < toCopy) {
                toCopy = leftToWrite;
            }
            System.arraycopy(data, offsetInBuffer, block.getData(), dataOffset, toCopy);
            offsetInBuffer += toCopy;
            this.file.release(curs.getCurrent(), true);
            if ((leftToWrite -= toCopy) <= 0) continue;
            block = this.file.get(curs.next());
            dataOffset = 20;
        }
    }
}

