/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;

public final class Provider
implements RecordManagerProvider {
    public RecordManager createRecordManager(String name, Properties options) throws IOException {
        RecordManager recman = new BaseRecordManager(name);
        String value = options.getProperty("jdbm.disableTransactions", "false");
        if (value.equalsIgnoreCase("TRUE")) {
            recman.disableTransactions();
        }
        value = options.getProperty("jdbm.cache.size", "1000");
        int cacheSize = Integer.parseInt(value);
        value = options.getProperty("jdbm.cache.type", "normal");
        if (!value.equalsIgnoreCase("normal")) {
            if (value.equalsIgnoreCase("soft")) {
                throw new IllegalArgumentException("Soft reference cache not implemented");
            }
            if (value.equalsIgnoreCase("weak")) {
                throw new IllegalArgumentException("Weak reference cache not implemented");
            }
            throw new IllegalArgumentException("Invalid cache type: " + value);
        }
        MRU cache = new MRU(cacheSize);
        recman = new CacheRecordManager(recman, cache);
        return recman;
    }
}

