/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.updater;

import com.amazon.common.CommonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteUpdate {
    private final Logger LOG = Logger.getLogger(ExecuteUpdate.class.getName());
    private final int UPDATE_LOCK_RETRY_INTERVAL = 5000;

    public static void main(String[] args) {
        new ExecuteUpdate().execute();
    }

    private void execute() {
        FileLock lock = CommonUtils.getFileLock(CommonUtils.PREVIEWR_LOCK_FILE, false);
        if (lock != null) {
            this.LOG.info("Aquired lock. starting update");
            this.startUpdate();
            this.releaseLock(lock);
            return;
        }
        while (lock == null) {
            lock = CommonUtils.getFileLock(CommonUtils.PREVIEWR_LOCK_FILE, true);
            if (lock == null) {
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.LOG.log(Level.INFO, "Exception while sleeping for lock", e);
                    return;
                }
            }
            this.releaseLock(lock);
        }
    }

    void releaseLock(FileLock lock) {
        try {
            lock.release();
        }
        catch (Exception e) {
            this.LOG.log(Level.INFO, "Error while releaseing lock ", e);
            CommonUtils.deleteFile(CommonUtils.PREVIEWR_LOCK_FILE);
        }
    }

    private void startUpdate() {
        File updateFile = new File(CommonUtils.UPDATE_FILE_NAME);
        if (!updateFile.exists()) {
            this.LOG.info("update.jar does not exits. Returning");
            return;
        }
        List<String> command = this.getExecutionString();
        this.LOG.info("Command String: " + command);
        if (command.isEmpty()) {
            return;
        }
        this.LOG.info("building process builder");
        ProcessBuilder procBuilder = new ProcessBuilder(command);
        Process proc = null;
        int exitValue = -1;
        try {
            this.LOG.info("starting update");
            proc = procBuilder.start();
            this.logOutput(proc);
            exitValue = proc.waitFor();
        }
        catch (IOException e) {
            this.LOG.log(Level.SEVERE, "exception while running update ", e);
            return;
        }
        catch (InterruptedException e) {
            this.LOG.log(Level.SEVERE, " interrupted while waiting for update process to complete", e);
            return;
        }
        if (exitValue != 0) {
            this.LOG.warning("update did not completed successfully. Deleting the update file");
            boolean result = new File(CommonUtils.UPDATE_FILE_NAME).delete();
            this.LOG.info("update file deleted " + result);
            return;
        }
        File file = new File(CommonUtils.UPDATE_COMPLETE_FILE);
        if (file.exists()) {
            this.LOG.info("Update completed succesfully. update.jar file is created. Deleting the update files");
            boolean result = new File(CommonUtils.UPDATE_FILE_NAME).delete();
            this.LOG.info("update file deleted " + result);
        }
    }

    private List<String> getExecutionString() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") >= 0) {
            return Arrays.asList("./jre/bin/java", "-jar", "update.jar");
        }
        if (os.indexOf("mac os x") >= 0) {
            return Arrays.asList("bash", "-c", "java -jar update.jar");
        }
        return new ArrayList<String>();
    }

    private void logOutput(Process proc) {
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        final BufferedReader ipReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        CommonUtils.createAndRunDaemonThread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (errReader.ready()) {
                                ExecuteUpdate.this.LOG.info(errReader.readLine());
                            }
                            if (!ipReader.ready()) continue;
                            ExecuteUpdate.this.LOG.info(ipReader.readLine());
                        }
                    }
                    catch (IOException e) {
                        ExecuteUpdate.this.LOG.log(Level.WARNING, "", e);
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

