/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.htmlreader.impl;

import com.amazon.kindlepreview.common.utils.PlatformUtils;
import com.amazon.kindlepreview.common.utils.c;
import com.amazon.kindlepreview.common.utils.e;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class HTMLRenderer {
    private static final String BASE_COMMAND_URL = "http://127.0.0.1:20450/command/";
    private static final MessageFormat REPLY_ELEMENT_FORMAT = new MessageFormat("{0,number,integer} {1,number,integer}");
    private static final int CONNECTION_TIMEOUT = 1500;
    private static final int DEFAULT_LINE_SPACING = 2;
    private static final Map REQUEST_QUEUE = new LinkedHashMap();
    private static final String REQUEST_QUEUE_PRIMITIVE = "$$primitive";
    private static final String PRIMITIVE_LOAD_URI = "open_uri";
    private static final String PRIMITIVE_CLOSE_URI = "close_uri";
    private static final String PRIMITIVE_NEXT_PAGE = "next_page";
    private static final String PRIMITIVE_PREVIOUS_PAGE = "previous_page";
    private static final String PRIMITIVE_MOVE_TABLE_LEFT = "move_table_left";
    private static final String PRIMITIVE_MOVE_TABLE_RIGHT = "move_table_right";
    private static final String PRIMITIVE_RESET_TABLE = "reset_table";
    private static final String PRIMITIVE_GOTO_POSITION = "goto_position";
    private static final String PRIMITIVE_JUMP_TO_LINK = "jump_to_link";
    private static final String PRIMITIVE_SET_PARAMETERS = "set_parameters";
    private static final String PRIMITIVE_DRAW_PAGE = "draw_page";
    private static final String PRIMITIVE_GOTO_SRL = "go_to_srl";
    private static final String PARAMETER_URI = "uri";
    private static final String PARAMETER_JMPURI = "jmp_uri";
    private static final String PARAMETER_PID = "pid";
    private static final String PARAMETER_POSITION = "position";
    private static final String PARAMETER_WIDTH = "width";
    private static final String PARAMETER_HEIGHT = "height";
    private static final String PARAMETER_LEFT_MARGIN = "left_margin";
    private static final String PARAMETER_RIGHT_MARGIN = "right_margin";
    private static final String PARAMETER_FONT_FAMILY = "font_family";
    private static final String PARAMETER_FONT_SIZE = "font_size";
    private static final String PARAMETER_LINE_SPACING = "line_spacing";
    private static final String PARAMETER_PIXMAP = "pixmap";
    private static final String PARAMETER_SKIP_IMAGE = "skip_image";
    private static final String PARAMETER_SCROLL_HORIZONTALLY = "scroll_horizontally";
    private static byte[] screenMetadata;
    private static byte[] screenImage;
    private static long soupServerPort;
    private static int m_previousCount;
    private static int curPosition;
    private static boolean fileResponse;
    private static String m_filePath;

    private HTMLRenderer() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortClosed() {
        if (soupServerPort == -1L) {
            return true;
        }
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        try {
            URL uRL = new URL("http://127.0.0.1:" + soupServerPort);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(10);
            if (PlatformUtils.isLinuxPlatform()) {
                httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            }
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            bl = true;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return bl;
    }

    private static URL buildCommand(String string, Map map) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer(BASE_COMMAND_URL.replace("20450", String.valueOf(soupServerPort)));
        stringBuffer.append(string);
        if (map != null && !map.isEmpty()) {
            stringBuffer.append('?');
            stringBuffer.append(e.a(map));
        }
        return new URL(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processCommand(URL uRL, boolean bl, boolean bl2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            List<String> list;
            HttpURLConnection httpURLConnection2;
            if (PlatformUtils.isLinuxPlatform()) {
                System.setProperty("http.keepAlive", "false");
            }
            httpURLConnection = httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
            httpURLConnection2.setUseCaches(false);
            if (PlatformUtils.isLinuxPlatform()) {
                httpURLConnection2.setDoInput(true);
                if (!bl) {
                    httpURLConnection2.setRequestProperty("Connection", "close");
                } else {
                    httpURLConnection2.setRequestProperty("Connection", "Keep-Alive");
                }
            }
            httpURLConnection2.connect();
            for (int i2 = 0; httpURLConnection2.getResponseCode() == 503 && i2 < 3; ++i2) {
                HTMLRenderer.teardownConnection(httpURLConnection2);
                httpURLConnection = httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
                httpURLConnection2.setUseCaches(false);
                Thread.sleep(2000L);
                httpURLConnection2.connect();
            }
            if (httpURLConnection2.getResponseCode() != 200) {
                HTMLRenderer.goHome();
                throw new IOException("Failed HTTP request; switching to Home");
            }
            Map<String, List<String>> map = httpURLConnection2.getHeaderFields();
            if (!bl) {
                if (!map.get("WebReader_Status").get(0).equals("OK")) {
                    throw new IOException("Failed remote command");
                }
                if (bl2) {
                    curPosition = Integer.parseInt(map.get("WebReader_Position").get(0).toString());
                } else {
                    Object object2;
                    list = map.get("WebReader_Element");
                    object = REPLY_ELEMENT_FORMAT.parse(list.get(0).toString());
                    int n2 = ((Number)object[0]).intValue();
                    int n3 = ((Number)object[1]).intValue();
                    List<String> list2 = map.get("WebReader_Image");
                    Object[] objectArray = REPLY_ELEMENT_FORMAT.parse(list2.get(0).toString());
                    int n4 = ((Number)objectArray[0]).intValue();
                    int n5 = ((Number)objectArray[1]).intValue();
                    if (n2 != 0 || n3 != n4 || n3 + n5 != httpURLConnection2.getContentLength()) {
                        throw new IOException("Unexpected reply elements (" + n2 + ':' + n3 + ':' + n4 + ':' + n5 + ')');
                    }
                    byte[] byArray = new byte[httpURLConnection2.getContentLength()];
                    if (fileResponse) {
                        object2 = null;
                        File file = new File(m_filePath + map.get("WebReader_RespObj").get(0).toString());
                        if (file.length() != (long)httpURLConnection2.getContentLength()) {
                            throw new IOException("Unexpected reply elements (file length :" + file.length() + "is not equal to content len:" + httpURLConnection2.getContentLength());
                        }
                        try {
                            int n6 = 0;
                            object2 = new BufferedInputStream(new FileInputStream(file));
                            while (n6 < byArray.length) {
                                int n7 = byArray.length - n6;
                                int n8 = ((InputStream)object2).read(byArray, n6, n7);
                                if (n8 <= 0) continue;
                                n6 += n8;
                            }
                        }
                        finally {
                            ((InputStream)object2).close();
                        }
                    } else {
                        object2 = httpURLConnection2.getInputStream();
                        for (int i3 = 0; i3 < httpURLConnection2.getContentLength(); i3 += ((InputStream)object2).read(byArray, i3, byArray.length - i3)) {
                        }
                        ((InputStream)object2).close();
                    }
                    object2 = new byte[n3];
                    System.arraycopy(byArray, n2, object2, 0, n3);
                    byte[] byArray2 = new byte[n5];
                    System.arraycopy(byArray, n4, byArray2, 0, n5);
                    screenMetadata = (byte[])object2;
                    screenImage = byArray2;
                }
            }
            if ((list = map.get("WebReader_RespObj")) != null && list.size() >= 0 && ((File)(object = new File(m_filePath + list.get(0).toString()))).exists()) {
                ((File)object).delete();
            }
            if (httpURLConnection == null) return;
        }
        catch (Exception exception) {
            try {
                throw new IOException(exception.getMessage());
            }
            catch (Throwable throwable) {
                if (httpURLConnection == null) throw throwable;
                HTMLRenderer.teardownConnection(httpURLConnection);
                throw throwable;
            }
        }
        HTMLRenderer.teardownConnection(httpURLConnection);
        return;
    }

    private static synchronized void teardownConnection(HttpURLConnection httpURLConnection) {
        try {
            httpURLConnection.getInputStream().close();
            httpURLConnection.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        httpURLConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean drawPage(String string, boolean bl) {
        boolean bl2 = false;
        try {
            if (!REQUEST_QUEUE.isEmpty()) {
                Object object;
                String string2;
                Object object2;
                Object object3;
                Object object4;
                Map.Entry entry2;
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                LinkedHashMap<Object, Map> linkedHashMap2 = new LinkedHashMap<Object, Map>();
                LinkedHashMap linkedHashMap3 = new LinkedHashMap();
                for (Map.Entry entry2 : REQUEST_QUEUE.entrySet()) {
                    object4 = entry2.getKey();
                    if (object4.toString().equals(PARAMETER_JMPURI)) {
                        object4 = PARAMETER_URI;
                    }
                    if (!(object3 = entry2.getValue()).toString().equals(REQUEST_QUEUE_PRIMITIVE)) {
                        linkedHashMap3.put(object4, object3);
                        continue;
                    }
                    linkedHashMap.put(object4.toString(), linkedHashMap3);
                    linkedHashMap3 = new LinkedHashMap();
                }
                if (!linkedHashMap3.isEmpty()) {
                    linkedHashMap.put(PRIMITIVE_SET_PARAMETERS, linkedHashMap3);
                }
                if ((entry2 = linkedHashMap.entrySet().iterator()).hasNext()) {
                    object4 = (Map.Entry)entry2.next();
                    object3 = object4.getKey().toString();
                    object2 = (Map)object4.getValue();
                    while (entry2.hasNext()) {
                        Iterator iterator;
                        object4 = (Map.Entry)entry2.next();
                        string2 = object4.getKey().toString();
                        object = (Map)object4.getValue();
                        if (object3 == PRIMITIVE_LOAD_URI && string2 == PRIMITIVE_GOTO_POSITION) {
                            iterator = object.entrySet().iterator();
                            HTMLRenderer.copyParameter((Map)object2, iterator);
                            continue;
                        }
                        if (object3 == PRIMITIVE_LOAD_URI && string2 == PRIMITIVE_SET_PARAMETERS) {
                            iterator = object.entrySet().iterator();
                            HTMLRenderer.copyParameter((Map)object2, iterator);
                            continue;
                        }
                        if (object3 == PRIMITIVE_LOAD_URI && string2 == PRIMITIVE_GOTO_SRL) {
                            iterator = object.entrySet().iterator();
                            object2.put(PARAMETER_POSITION, PRIMITIVE_GOTO_SRL);
                            HTMLRenderer.copyParameter((Map)object2, iterator);
                            continue;
                        }
                        linkedHashMap2.put(object3, (Map)object2);
                        object3 = string2;
                        object2 = object;
                    }
                    linkedHashMap2.put(object3, (Map)object2);
                }
                Iterator iterator = linkedHashMap2.entrySet().iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    object3 = object4.getKey();
                    object2 = (Map)object4.getValue();
                    string2 = object3.toString();
                    if (string2.startsWith(PRIMITIVE_PREVIOUS_PAGE)) {
                        string2 = PRIMITIVE_PREVIOUS_PAGE;
                    }
                    object = HTMLRenderer.buildCommand(string2, (Map)object2);
                    HTMLRenderer.processCommand((URL)object, iterator.hasNext(), bl);
                }
                if (screenImage != null && string != null) {
                    c.a(string, screenImage);
                }
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        finally {
            if (!bl2 || !HTMLRenderer.hasOpenURI()) {
                REQUEST_QUEUE.clear();
            }
        }
        return !bl2;
    }

    private static void copyParameter(Map map, Iterator iterator) {
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            map.put(string, string2);
        }
    }

    public static synchronized byte[] getPageElements() {
        return screenMetadata;
    }

    public static synchronized int getCurrentPosition() {
        return curPosition;
    }

    public static synchronized byte[] getPageImage() {
        return screenImage;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized byte[] getContentFromURL(String var0) throws IOException {
        block12: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = new boolean[]{false};
            try {
                var4_4 = new URL(var0);
                var5_7 = (HttpURLConnection)var4_4.openConnection();
                var6_8 = new TimerTask(){

                    public void run() {
                        if (!var3_3[0]) {
                            HTMLRenderer.teardownConnection(var5_7);
                            HTMLRenderer.goHome();
                        }
                    }
                };
                new Timer().schedule(var6_8, new Date(System.currentTimeMillis() + 1500L));
                var5_7.setUseCaches(false);
                var1_1 = var5_7;
                if (var5_7.getResponseCode() != 200) {
                    HTMLRenderer.goHome();
                    throw new IOException("Failed HTTP request; switching to Home");
                }
                var7_9 = var5_7.getErrorStream();
                if (var7_9 == null) {
                    var8_10 = var5_7.getInputStream();
                    var9_11 = var5_7.getContentLength();
                    var2_2 = new byte[var9_11];
                    var8_10.read(var2_2, 0, var9_11);
                } else {
                    HTMLRenderer.goHome();
                }
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (SocketTimeoutException var4_5) {
                HTMLRenderer.goHome();
                break block12;
            }
            catch (Exception var4_6) {
                throw new IOException(var4_6.getMessage());
                {
                    catch (Throwable var10_12) {
                        throw var10_12;
                    }
                }
            }
            finally {
                if (var1_1 != null) {
                    HTMLRenderer.teardownConnection(var1_1);
                }
            }
lbl-1000:
            // 1 sources

            {
                HTMLRenderer.teardownConnection(var1_1);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        var3_3[0] = true;
        return var2_2;
    }

    public static boolean hasOpenURI() {
        if (!REQUEST_QUEUE.isEmpty()) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry entry : REQUEST_QUEUE.entrySet()) {
                Object v2;
                Object object = entry.getKey();
                if (object.toString().equals(PARAMETER_JMPURI)) {
                    object = PARAMETER_URI;
                }
                if (!(v2 = entry.getValue()).toString().equals(REQUEST_QUEUE_PRIMITIVE)) {
                    linkedHashMap.put(object, v2);
                    continue;
                }
                return object.toString().equals(PRIMITIVE_LOAD_URI);
            }
        }
        return false;
    }

    public static synchronized void openUri(String string, String string2, int n2, int n3, int n4, int n5, float f2, String string3) {
        HTMLRenderer.clearQueue();
        REQUEST_QUEUE.put(PARAMETER_URI, string);
        REQUEST_QUEUE.put(PARAMETER_PID, string2);
        REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_FONT_SIZE, new Float(f2));
        if (string3 != null) {
            REQUEST_QUEUE.put(PARAMETER_FONT_FAMILY, string3);
        }
        REQUEST_QUEUE.put(PARAMETER_LINE_SPACING, new Integer(2));
        REQUEST_QUEUE.put(PARAMETER_LEFT_MARGIN, new Integer(n4));
        REQUEST_QUEUE.put(PARAMETER_RIGHT_MARGIN, new Integer(n5));
        REQUEST_QUEUE.put(PRIMITIVE_LOAD_URI, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void closeURI() {
        HTMLRenderer.clearQueue();
        REQUEST_QUEUE.put(PRIMITIVE_CLOSE_URI, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void nextPage() {
        REQUEST_QUEUE.put(PRIMITIVE_NEXT_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void previousPage() {
        if (m_previousCount == 0) {
            REQUEST_QUEUE.put(PRIMITIVE_PREVIOUS_PAGE, REQUEST_QUEUE_PRIMITIVE);
        } else {
            REQUEST_QUEUE.put(PRIMITIVE_PREVIOUS_PAGE + m_previousCount, REQUEST_QUEUE_PRIMITIVE);
        }
        ++m_previousCount;
    }

    public static synchronized void setBounds(int n2, int n3, int n4, int n5) {
        REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_LEFT_MARGIN, new Integer(n4));
        REQUEST_QUEUE.put(PARAMETER_RIGHT_MARGIN, new Integer(n5));
    }

    public static synchronized void setFontFamily(String string) {
        REQUEST_QUEUE.put(PARAMETER_FONT_FAMILY, string);
    }

    public static synchronized void setFontSize(float f2) {
        REQUEST_QUEUE.put(PARAMETER_FONT_SIZE, new Float(f2));
    }

    public static synchronized void setLineSpacing(int n2) {
        REQUEST_QUEUE.put(PARAMETER_LINE_SPACING, new Integer(n2));
    }

    public static synchronized void scrollHorizontally(int n2) {
        REQUEST_QUEUE.put(PARAMETER_SCROLL_HORIZONTALLY, new Integer(n2));
    }

    public static synchronized void gotoPosition(int n2) {
        REQUEST_QUEUE.put(PARAMETER_POSITION, new Integer(n2));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_POSITION, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void jumpToLink(String string) {
        REQUEST_QUEUE.put(PARAMETER_JMPURI, string);
        REQUEST_QUEUE.put(PRIMITIVE_JUMP_TO_LINK, REQUEST_QUEUE_PRIMITIVE);
    }

    private static void goHome() {
    }

    public static void closeBook() {
        HTMLRenderer.drawPage(null, false);
    }

    public static void setSoupServerPort(long l2) {
        soupServerPort = l2;
    }

    public static void clearQueue() {
        m_previousCount = 0;
        REQUEST_QUEUE.clear();
    }

    public static boolean isRQEmpty() {
        return REQUEST_QUEUE.isEmpty();
    }

    public static void gotoSRL() {
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_SRL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static void setFilePath(String string) {
        m_filePath = string;
    }

    public static String getFilePath() {
        return m_filePath;
    }

    public static void setFileResponse(boolean bl) {
        fileResponse = bl;
    }

    public static boolean getFileResponse() {
        return fileResponse;
    }

    static {
        fileResponse = false;
    }
}

