/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.htmlreader.impl;

import com.amazon.kindlepreview.common.utils.c;
import com.amazon.kindlepreview.common.utils.e;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class HTMLRendererFixedLayout {
    private static final String BASE_FIXED_URL = "http://127.0.0.1:20450/fixed/";
    private static final MessageFormat REPLY_ELEMENT_FORMAT = new MessageFormat("{0,number,integer} {1,number,integer}");
    private static final int CONNECTION_TIMEOUT = 1500;
    private static final Map REQUEST_QUEUE = new LinkedHashMap();
    private static final String REQUEST_QUEUE_PRIMITIVE = "$$primitive";
    private static final String PRIMITIVE_LOAD_URI = "open_uri";
    private static final String PRIMITIVE_CLOSE_URI = "close_uri";
    private static final String PRIMITIVE_NEXT_PAGE = "next_page";
    private static final String PRIMITIVE_PREVIOUS_PAGE = "previous_page";
    private static final String PRIMITIVE_GOTO_POSITION = "goto_position";
    private static final String PRIMITIVE_SET_PARAMETERS = "set_parameters";
    private static final String PRIMITIVE_DRAW_PAGE = "draw_page";
    private static final String PRIMITIVE_PAN = "pan";
    private static final String PRIMITIVE_ZOOM = "zoom";
    private static final String PRIMITIVE_GOTO_PANEL = "goto_panel";
    private static final String PRIMITIVE_EXIT_PANEL = "exit_panel";
    private static final String PRIMITIVE_GOTO_SRL = "go_to_srl";
    private static final String PARAMETER_URI = "uri";
    private static final String PARAMETER_PID = "pid";
    private static final String PARAMETER_POSITION = "position";
    private static final String PARAMETER_WIDTH = "width";
    private static final String PARAMETER_HEIGHT = "height";
    private static final String PARAMETER_LEFT_MARGIN = "left_margin";
    private static final String PARAMETER_RIGHT_MARGIN = "right_margin";
    private static final String PARAMETER_FONT_FAMILY = "font_family";
    private static final String PARAMETER_FONT_SIZE = "font_size";
    private static final String PARAMETER_LINE_SPACING = "line_spacing";
    private static final String PARAMETER_PIXMAP = "pixmap";
    private static final String PARAMETER_SKIP_IMAGE = "skip_image";
    private static final String PARAMETER_SCROLL_HORIZONTALLY = "scroll_horizontally";
    private static final String PARAMETER_LTR = "ltr";
    private static final String PARAMETER_LOCK = "lock";
    private static final String PARAMETER_DITHER = "dither";
    private static final String PARAMETER_ZOOM_RATIO = "zoom_ratio";
    private static final String PARAMETER_DELTA_X = "deltaX";
    private static final String PARAMETER_DELTA_Y = "deltaY";
    private static final String PARAMETER_CENTER_X = "centerX";
    private static final String PARAMETER_CENTER_Y = "centerY";
    private static final String PARAMETER_PANEL = "panel";
    private static final String PARAMETER_X = "x";
    private static final String PARAMETER_Y = "y";
    private static final String PARAMETER_PAGE = "page";
    private static final String PARAMETER_FIT_SCREEN = "fit_screen";
    private static final String PARAMETER_SRC_PAGE = "src_page";
    private static final String PARAMETER_SRC_PANEL = "src_panel";
    private static final String PARAMETER_FRAME = "frame";
    private static final String PARAMETER_TOTAL_FRAMES = "total_frames";
    private static byte[] screenMetadata;
    private static byte[] screenImage;
    private static long soupServerPort;
    private static int curPosition;
    private static int curNextPosition;
    private static int curPrevPosition;
    private static boolean fileResponse;
    private static String m_filePath;

    private HTMLRendererFixedLayout() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortClosed() {
        if (soupServerPort == -1L) {
            return true;
        }
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        try {
            URL uRL = new URL("http://127.0.0.1:" + soupServerPort);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(10);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            bl = true;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return bl;
    }

    private static URL buildCommand(String string, Map map) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer(BASE_FIXED_URL.replace("20450", String.valueOf(soupServerPort)));
        stringBuffer.append(string);
        if (map != null && !map.isEmpty()) {
            if (string.equalsIgnoreCase(PRIMITIVE_LOAD_URI) && map.containsKey(PARAMETER_WIDTH) && map.containsKey(PARAMETER_HEIGHT) && map.containsKey(PARAMETER_LOCK)) {
                String string2 = map.get(PARAMETER_LOCK).toString();
                int n2 = new Integer((Integer)map.get(PARAMETER_WIDTH));
                int n3 = new Integer((Integer)map.get(PARAMETER_HEIGHT));
                int n4 = Math.min(n2, n3);
                int n5 = Math.max(n2, n3);
                if (string2 != null && string2.equalsIgnoreCase("portrait")) {
                    map.put(PARAMETER_WIDTH, new Integer(n4));
                    map.put(PARAMETER_HEIGHT, new Integer(n5));
                } else if (string2 != null && string2.equalsIgnoreCase("landscape")) {
                    map.put(PARAMETER_WIDTH, new Integer(n5));
                    map.put(PARAMETER_HEIGHT, new Integer(n4));
                }
            }
            stringBuffer.append('?');
            stringBuffer.append(e.a(map));
        }
        return new URL(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommand(URL uRL, boolean bl) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            List<String> list;
            HttpURLConnection httpURLConnection2;
            httpURLConnection = httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
            httpURLConnection2.setUseCaches(false);
            httpURLConnection2.connect();
            for (int i2 = 0; httpURLConnection2.getResponseCode() == 503 && i2 < 3; ++i2) {
                HTMLRendererFixedLayout.teardownConnection(httpURLConnection2);
                httpURLConnection = httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
                httpURLConnection2.setUseCaches(false);
                Thread.sleep(2000L);
                httpURLConnection2.connect();
            }
            if (httpURLConnection2.getResponseCode() != 200) {
                throw new IOException("Failed HTTP request; switching to Home");
            }
            Map<String, List<String>> map = httpURLConnection2.getHeaderFields();
            if (!map.get("FixedLayoutReader_Status").get(0).equals("OK")) {
                throw new IOException("Failed remote command");
            }
            if (bl) {
                HTMLRendererFixedLayout.updateNextPreviousPositions(map);
            } else {
                Object object2;
                HTMLRendererFixedLayout.updateNextPreviousPositions(map);
                list = map.get("FixedLayoutReader_Element");
                object = REPLY_ELEMENT_FORMAT.parse(list.get(0).toString());
                int n2 = ((Number)object[0]).intValue();
                int n3 = ((Number)object[1]).intValue();
                List<String> list2 = map.get("FixedLayoutReader_Image");
                Object[] objectArray = REPLY_ELEMENT_FORMAT.parse(list2.get(0).toString());
                int n4 = ((Number)objectArray[0]).intValue();
                int n5 = ((Number)objectArray[1]).intValue();
                if (n2 != 0 || n3 != n4 || n3 + n5 != httpURLConnection2.getContentLength()) {
                    throw new IOException("Unexpected reply elements (" + n2 + ':' + n3 + ':' + n4 + ':' + n5 + ')');
                }
                byte[] byArray = new byte[httpURLConnection2.getContentLength()];
                if (fileResponse) {
                    object2 = null;
                    File file = new File(m_filePath + map.get("FixedLayoutReader_RespObj").get(0).toString());
                    if (file.length() != (long)httpURLConnection2.getContentLength()) {
                        throw new IOException("Unexpected reply elements (file length :" + file.length() + "is not equal to content len:" + httpURLConnection2.getContentLength());
                    }
                    try {
                        int n6 = 0;
                        object2 = new BufferedInputStream(new FileInputStream(file));
                        while (n6 < byArray.length) {
                            int n7 = byArray.length - n6;
                            int n8 = ((InputStream)object2).read(byArray, n6, n7);
                            if (n8 <= 0) continue;
                            n6 += n8;
                        }
                    }
                    finally {
                        ((InputStream)object2).close();
                    }
                } else {
                    object2 = httpURLConnection2.getInputStream();
                    for (int i3 = 0; i3 < httpURLConnection2.getContentLength(); i3 += ((InputStream)object2).read(byArray, i3, byArray.length - i3)) {
                    }
                    ((InputStream)object2).close();
                }
                object2 = new byte[n3];
                System.arraycopy(byArray, n2, object2, 0, n3);
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, n4, byArray2, 0, n5);
                screenMetadata = (byte[])object2;
                screenImage = byArray2;
            }
            list = map.get("FixedLayoutReader_RespObj");
            if (list != null && list.size() >= 0 && ((File)(object = new File(m_filePath + list.get(0).toString()))).exists()) {
                ((File)object).delete();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        finally {
            if (httpURLConnection != null) {
                HTMLRendererFixedLayout.teardownConnection(httpURLConnection);
            }
        }
    }

    private static void updateNextPreviousPositions(Map map) {
        List list = (List)map.get("FixedLayoutReader_Position");
        if (list != null && list.size() >= 0) {
            curPosition = Integer.parseInt(list.get(0).toString());
        }
        if ((list = (List)map.get("FixedLayoutReader_NextPosition")) != null && list.size() >= 0) {
            curNextPosition = Integer.parseInt(list.get(0).toString());
        }
        if ((list = (List)map.get("FixedLayoutReader_PrevPosition")) != null && list.size() >= 0) {
            curPrevPosition = Integer.parseInt(list.get(0).toString());
        }
    }

    private static synchronized void teardownConnection(HttpURLConnection httpURLConnection) {
        try {
            httpURLConnection.getInputStream().close();
            httpURLConnection.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        httpURLConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean drawPage(String string, boolean bl) {
        boolean bl2 = false;
        try {
            if (!REQUEST_QUEUE.isEmpty()) {
                Object object;
                Map map;
                Iterator iterator;
                Object object2;
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                LinkedHashMap<Object, Map> linkedHashMap2 = new LinkedHashMap<Object, Map>();
                LinkedHashMap linkedHashMap3 = new LinkedHashMap();
                for (Map.Entry object42 : REQUEST_QUEUE.entrySet()) {
                    Object k2 = object42.getKey();
                    object2 = object42.getValue();
                    if (!object2.toString().equals(REQUEST_QUEUE_PRIMITIVE)) {
                        linkedHashMap3.put(k2, object2);
                        continue;
                    }
                    linkedHashMap.put(k2.toString(), linkedHashMap3);
                    linkedHashMap3 = new LinkedHashMap();
                }
                if (!linkedHashMap3.isEmpty()) {
                    linkedHashMap.put(PRIMITIVE_SET_PARAMETERS, linkedHashMap3);
                }
                if ((iterator = linkedHashMap.entrySet().iterator()).hasNext()) {
                    Map.Entry entry = iterator.next();
                    object2 = entry.getKey().toString();
                    map = (Map)entry.getValue();
                    while (iterator.hasNext()) {
                        Iterator iterator2;
                        Map.Entry entry2 = iterator.next();
                        object = entry2.getKey().toString();
                        Map map2 = (Map)entry2.getValue();
                        if (object2 == PRIMITIVE_LOAD_URI && object == PRIMITIVE_GOTO_POSITION) {
                            iterator2 = map2.entrySet().iterator();
                            HTMLRendererFixedLayout.copyParameter(map, iterator2);
                            continue;
                        }
                        if (object2 == PRIMITIVE_LOAD_URI && object == PRIMITIVE_SET_PARAMETERS) {
                            iterator2 = map2.entrySet().iterator();
                            HTMLRendererFixedLayout.copyParameter(map, iterator2);
                            continue;
                        }
                        if (object2 == PRIMITIVE_LOAD_URI && object == PRIMITIVE_GOTO_SRL) {
                            iterator2 = map2.entrySet().iterator();
                            map.put(PARAMETER_POSITION, PRIMITIVE_GOTO_SRL);
                            HTMLRendererFixedLayout.copyParameter(map, iterator2);
                            continue;
                        }
                        linkedHashMap2.put(object2, map);
                        object2 = object;
                        map = map2;
                    }
                    linkedHashMap2.put(object2, map);
                }
                for (Map.Entry entry : linkedHashMap2.entrySet()) {
                    object2 = entry.getKey();
                    map = (Map)entry.getValue();
                    object = HTMLRendererFixedLayout.buildCommand(object2.toString(), map);
                    HTMLRendererFixedLayout.processCommand((URL)object, bl);
                }
            }
            if (screenImage != null && screenImage.length != 0 && string != null) {
                c.a(string, screenImage);
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        finally {
            if (!bl2 || !HTMLRendererFixedLayout.hasOpenURI()) {
                REQUEST_QUEUE.clear();
            }
        }
        return !bl2;
    }

    private static void copyParameter(Map map, Iterator iterator) {
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            map.put(string, string2);
        }
    }

    public static synchronized byte[] getPageElements() {
        return screenMetadata;
    }

    public static synchronized byte[] getPageImage() {
        return screenImage;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized byte[] getContentFromURL(String var0) throws IOException {
        block12: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = new boolean[]{false};
            try {
                var4_4 = new URL(var0);
                var5_7 = (HttpURLConnection)var4_4.openConnection();
                var6_8 = new TimerTask(){

                    public void run() {
                        if (!var3_3[0]) {
                            HTMLRendererFixedLayout.teardownConnection(var5_7);
                            HTMLRendererFixedLayout.goHome();
                        }
                    }
                };
                new Timer().schedule(var6_8, new Date(System.currentTimeMillis() + 1500L));
                var5_7.setUseCaches(false);
                var1_1 = var5_7;
                if (var5_7.getResponseCode() != 200) {
                    HTMLRendererFixedLayout.goHome();
                    throw new IOException("Failed HTTP request; switching to Home");
                }
                var7_9 = var5_7.getErrorStream();
                if (var7_9 == null) {
                    var8_10 = var5_7.getInputStream();
                    var9_11 = var5_7.getContentLength();
                    var2_2 = new byte[var9_11];
                    var8_10.read(var2_2, 0, var9_11);
                } else {
                    HTMLRendererFixedLayout.goHome();
                }
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (SocketTimeoutException var4_5) {
                HTMLRendererFixedLayout.goHome();
                break block12;
            }
            catch (Exception var4_6) {
                throw new IOException(var4_6.getMessage());
                {
                    catch (Throwable var10_12) {
                        throw var10_12;
                    }
                }
            }
            finally {
                if (var1_1 != null) {
                    HTMLRendererFixedLayout.teardownConnection(var1_1);
                }
            }
lbl-1000:
            // 1 sources

            {
                HTMLRendererFixedLayout.teardownConnection(var1_1);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        var3_3[0] = true;
        return var2_2;
    }

    public static boolean hasOpenURI() {
        if (!REQUEST_QUEUE.isEmpty()) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry entry : REQUEST_QUEUE.entrySet()) {
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!v2.toString().equals(REQUEST_QUEUE_PRIMITIVE)) {
                    linkedHashMap.put(k2, v2);
                    continue;
                }
                return k2.toString().equals(PRIMITIVE_LOAD_URI);
            }
        }
        return false;
    }

    public static synchronized void openUri(String string, String string2, int n2, int n3, boolean bl, String string3) {
        HTMLRendererFixedLayout.clearQueue();
        REQUEST_QUEUE.put(PARAMETER_URI, string);
        REQUEST_QUEUE.put(PARAMETER_PID, string2);
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (string3 != null && string3.equalsIgnoreCase("portrait")) {
            REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n4));
            REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n5));
        } else if (string3 != null && string3.equalsIgnoreCase("landscape")) {
            REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n5));
            REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n4));
        } else {
            REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n2));
            REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n3));
        }
        REQUEST_QUEUE.put(PARAMETER_LTR, bl ? new Integer(1) : new Integer(0));
        if (string3 != null && (string3.equals("portrait") || string3.equals("landscape"))) {
            REQUEST_QUEUE.put(PARAMETER_LOCK, string3);
        } else {
            REQUEST_QUEUE.put(PARAMETER_LOCK, "unlocked");
        }
        REQUEST_QUEUE.put(PRIMITIVE_LOAD_URI, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void nextPage() {
        REQUEST_QUEUE.put(PRIMITIVE_NEXT_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void previousPage() {
        REQUEST_QUEUE.put(PRIMITIVE_PREVIOUS_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void setBounds(int n2, int n3) {
        REQUEST_QUEUE.put(PARAMETER_WIDTH, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_HEIGHT, new Integer(n3));
    }

    public static synchronized void setLineSpacing(int n2) {
        REQUEST_QUEUE.put(PARAMETER_LINE_SPACING, new Integer(n2));
    }

    public static synchronized void gotoPosition(int n2) {
        REQUEST_QUEUE.put(PARAMETER_POSITION, new Integer(n2));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_POSITION, REQUEST_QUEUE_PRIMITIVE);
    }

    private static void goHome() {
    }

    public static void closeBook() {
        HTMLRendererFixedLayout.drawPage(null, false);
    }

    public static void setSoupServerPort(long l2) {
        soupServerPort = l2;
    }

    public static void clearQueue() {
        REQUEST_QUEUE.clear();
    }

    public static synchronized void closeUri() {
        HTMLRendererFixedLayout.clearQueue();
        REQUEST_QUEUE.put(PRIMITIVE_CLOSE_URI, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void pan(int n2, int n3, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_DELTA_X, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_DELTA_Y, new Integer(n3));
        int n4 = bl ? 1 : 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n4));
        REQUEST_QUEUE.put(PRIMITIVE_PAN, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void zoom(double d2, int n2, int n3, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_CENTER_X, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_CENTER_Y, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_ZOOM_RATIO, new Double(d2));
        int n4 = bl ? 1 : 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n4));
        REQUEST_QUEUE.put(PRIMITIVE_ZOOM, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void nextPagePanel(int n2, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_PANEL, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_FIT_SCREEN, bl ? new Integer(1) : new Integer(0));
        int n3 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n3));
        REQUEST_QUEUE.put(PRIMITIVE_NEXT_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void previousPagePanel(int n2, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_PANEL, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_FIT_SCREEN, bl ? new Integer(1) : new Integer(0));
        int n3 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n3));
        REQUEST_QUEUE.put(PRIMITIVE_PREVIOUS_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void nextPageVirtualPanel(String string, double d2) {
        REQUEST_QUEUE.put(PARAMETER_PANEL, string);
        REQUEST_QUEUE.put(PARAMETER_ZOOM_RATIO, new Double(d2));
        int n2 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n2));
        REQUEST_QUEUE.put(PRIMITIVE_NEXT_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void previousPageVirtualPanel(String string, double d2) {
        REQUEST_QUEUE.put(PARAMETER_PANEL, string);
        REQUEST_QUEUE.put(PARAMETER_ZOOM_RATIO, new Double(d2));
        int n2 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n2));
        REQUEST_QUEUE.put(PRIMITIVE_PREVIOUS_PAGE, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void gotoPanel(int n2, int n3, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_PAGE, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_PANEL, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_FIT_SCREEN, bl ? new Integer(1) : new Integer(0));
        int n4 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n4));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_PANEL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void gotoPanelPosition(int n2, int n3, boolean bl) {
        REQUEST_QUEUE.put(PARAMETER_X, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_Y, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_FIT_SCREEN, bl ? new Integer(1) : new Integer(0));
        int n4 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n4));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_PANEL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void gotoPanelVirtual(int n2, String string, double d2) {
        REQUEST_QUEUE.put(PARAMETER_PAGE, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_PANEL, string);
        REQUEST_QUEUE.put(PARAMETER_ZOOM_RATIO, new Double(d2));
        int n3 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n3));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_PANEL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void gotoPanelVirtualTransition(int n2, String string, int n3, String string2, double d2, int n4, int n5) {
        REQUEST_QUEUE.put(PARAMETER_PAGE, new Integer(n2));
        REQUEST_QUEUE.put(PARAMETER_PANEL, string);
        REQUEST_QUEUE.put(PARAMETER_SRC_PAGE, new Integer(n3));
        REQUEST_QUEUE.put(PARAMETER_SRC_PANEL, string2);
        REQUEST_QUEUE.put(PARAMETER_ZOOM_RATIO, new Double(d2));
        REQUEST_QUEUE.put(PARAMETER_FRAME, new Integer(n4));
        REQUEST_QUEUE.put(PARAMETER_TOTAL_FRAMES, new Integer(n5));
        int n6 = n4 != n5 ? 1 : 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n6));
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_PANEL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static synchronized void exitPanel() {
        int n2 = 4;
        REQUEST_QUEUE.put(PARAMETER_DITHER, new Integer(n2));
        REQUEST_QUEUE.put(PRIMITIVE_EXIT_PANEL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static boolean isRQEmpty() {
        return REQUEST_QUEUE.isEmpty();
    }

    public static void gotoSRL() {
        REQUEST_QUEUE.put(PRIMITIVE_GOTO_SRL, REQUEST_QUEUE_PRIMITIVE);
    }

    public static void setFilePath(String string) {
        m_filePath = string;
    }

    public static String getFilePath() {
        return m_filePath;
    }

    public static void setFileResponse(boolean bl) {
        fileResponse = bl;
    }

    public static boolean getFileResponse() {
        return fileResponse;
    }

    public static synchronized int getCurrentPosition() {
        return curPosition;
    }

    public static synchronized int getCurrentNextPosition() {
        return curNextPosition;
    }

    public static synchronized int getCurrentPreviousPosition() {
        return curPrevPosition;
    }

    static {
        fileResponse = false;
    }
}

