/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.epub.reader.font.engine;

import com.amazon.epub.reader.font.engine.FreeTypeFontData;
import com.amazon.epub.reader.font.engine.FreeTypeGlyph;
import com.amazon.epub.reader.font.engine.a;
import com.amazon.kindlepreview.common.language.LanguageTag;
import com.amazon.kindlepreview.common.reader.c;
import com.amazon.kindlepreview.common.reader.h;
import com.amazon.kindlepreview.common.utils.PlatformUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FreeTypeFontManager {
    private static final String JNI_LIB = "lib";
    private static final String JNI_FILE = "fontlib.jni";
    private static final String DX_JNI_FILE = "fontlibDX.jni";
    private static final Object[] FONT_MAP_RESOURCE_CACHE = new Object[1];
    private static final Logger LOG = Logger.getLogger(FreeTypeFontManager.class.getName());
    private final long fontLibHandle;
    private final Map<String, Map<Integer, a>> fontCacheMap;
    private final Map<String, Long> fontHandleMap;
    private final long fontLibHandleDX;
    private final Map<String, Map<Integer, a>> fontCacheMapDX;
    private final Map<String, Long> fontHandleMapDX;
    private int platformDpi;
    private static FreeTypeFontManager instance;

    private native FreeTypeGlyph getGlyphRaster(char var1, long var2, int var4, int var5);

    private native FreeTypeGlyph getGlyphRasterDX(char var1, long var2, int var4, int var5);

    private native long loadNativeFont(long var1, String var3);

    private native long loadNativeFontDX(long var1, String var3);

    private native long loadFontFromFontData(long var1, byte[] var3, int var4);

    private native long loadFontFromFontDataDX(long var1, byte[] var3, int var4);

    private native String getPrimaryFontValue(long var1);

    private native String getPrimaryFontValueDX(long var1);

    private native long initNativeLibrary();

    private native long initNativeLibraryDX();

    private native FreeTypeFontData getFontData(long var1, int var3, int var4);

    private native FreeTypeFontData getFontDataDX(long var1, int var3, int var4);

    public static FreeTypeFontManager getInstance() {
        return instance;
    }

    public static void init(int n2) {
        if (instance == null) {
            try {
                PlatformUtils.loadJNILib(JNI_FILE);
                PlatformUtils.loadJNILib(DX_JNI_FILE);
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Exception while loading the library", throwable);
                throw new IllegalStateException(throwable);
            }
            instance = new FreeTypeFontManager(n2);
        }
    }

    public void setDPI(int n2) {
        this.platformDpi = n2;
    }

    private FreeTypeFontManager(int n2) {
        this.platformDpi = n2;
        this.fontCacheMap = new HashMap<String, Map<Integer, a>>();
        this.fontHandleMap = new HashMap<String, Long>();
        this.fontLibHandle = this.initNativeLibrary();
        this.fontCacheMapDX = new HashMap<String, Map<Integer, a>>();
        this.fontHandleMapDX = new HashMap<String, Long>();
        this.fontLibHandleDX = this.initNativeLibraryDX();
        if (this.fontLibHandle == -1L || this.fontLibHandleDX == -1L) {
            throw new IllegalStateException("Unable to load the Freetype font library");
        }
    }

    public FreeTypeGlyph getGlyph(h h2, char c2, a a2) {
        if (h2 == c.t) {
            return this.getGlyphRasterDX(c2, a2.d(), a2.g(), this.platformDpi);
        }
        return this.getGlyphRaster(c2, a2.d(), a2.g(), this.platformDpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public a getFont(h h2, String string, int n2, boolean bl, boolean bl2) {
        Object object;
        String string2;
        String string3 = this.internalFontName(h2, string, bl, bl2);
        if (h2 == c.t) {
            Object object2;
            if (!this.fontCacheMapDX.containsKey(string3)) {
                object2 = this;
                synchronized (object2) {
                    if (!this.fontCacheMapDX.containsKey(string3)) {
                        this.fontCacheMapDX.put(string3, new HashMap());
                    }
                }
            }
            if (!(object2 = this.fontCacheMapDX.get(string3)).containsKey(n2)) {
                FreeTypeFontManager freeTypeFontManager = this;
                synchronized (freeTypeFontManager) {
                    if (!object2.containsKey(n2)) {
                        object2.put(n2, this.loadFont(h2, string, n2, bl, bl2));
                    }
                }
            }
            return (a)object2.get(n2);
        }
        String string4 = "";
        if (h2 == c.r) {
            string4 = "_touch";
        }
        if (!this.fontCacheMap.containsKey(string2 = string3 + string4)) {
            object = this;
            synchronized (object) {
                if (!this.fontCacheMap.containsKey(string2)) {
                    this.fontCacheMap.put(string2, new HashMap());
                }
            }
        }
        if (!(object = this.fontCacheMap.get(string2)).containsKey(n2)) {
            FreeTypeFontManager freeTypeFontManager = this;
            synchronized (freeTypeFontManager) {
                if (!object.containsKey(n2)) {
                    object.put(n2, this.loadFont(h2, string, n2, bl, bl2));
                }
            }
        }
        return (a)object.get(n2);
    }

    private a loadFont(h h2, String string, int n2, boolean bl, boolean bl2) {
        String string2 = this.internalFontName(h2, string, bl, bl2);
        if (h2 == c.t) {
            if (!this.fontHandleMapDX.containsKey(string2)) {
                byte[] byArray = this.loadFontFileData(string2);
                long l2 = this.loadFontFromFontDataDX(this.fontLibHandleDX, byArray, 0);
                if (l2 == -1L) {
                    throw new IllegalArgumentException("font " + string + (bl ? " bold" : " ") + (bl2 ? " italic" : " ") + " of size " + n2 + " can't be loaded");
                }
                this.fontHandleMapDX.put(string2, l2);
            }
            long l3 = this.fontHandleMapDX.get(string2);
            FreeTypeFontData freeTypeFontData = this.getFontDataDX(l3, n2, this.platformDpi);
            return new a(h2, string, l3, freeTypeFontData, bl, bl2);
        }
        if (!this.fontHandleMap.containsKey(string2)) {
            byte[] byArray = this.loadFontFileData(string2);
            long l4 = this.loadFontFromFontData(this.fontLibHandle, byArray, 0);
            if (l4 == -1L) {
                throw new IllegalArgumentException("font " + string + (bl ? " bold" : " ") + (bl2 ? " italic" : " ") + " of size " + n2 + " can't be loaded");
            }
            this.fontHandleMap.put(string2, l4);
        }
        long l5 = this.fontHandleMap.get(string2);
        FreeTypeFontData freeTypeFontData = this.getFontData(l5, n2, this.platformDpi);
        return new a(h2, string, l5, freeTypeFontData, bl, bl2);
    }

    private byte[] loadFontFileData(String string) {
        InputStream inputStream = null;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = this.reprocessData(byteArrayOutputStream.toByteArray());
            return byArray2;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Exception while loading font file", exception);
            throw new IllegalStateException("Cant read font file. Can't proceed further", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Exception while closing stream", iOException);
                }
            }
        }
    }

    private byte[] reprocessData(byte[] byArray) throws Exception {
        int n2;
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n3 = n2 - 13;
            if (n3 < 0) {
                n3 += byArray.length;
            }
            byArray2[n3] = byArray[n2];
        }
        n2 = byArray.length;
        byte[] byArray3 = new byte[byArray.length];
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        for (int i2 = 0; i2 < n2; i2 += n6) {
            n6 = n4 + n5;
            n4 = n5;
            n5 = n6;
            int n7 = i2 + n6;
            if (n7 > n2) {
                n7 = n2;
            }
            int n8 = i2;
            int n9 = n7 - 1;
            while (n8 < n7) {
                byArray3[n8++] = byArray2[n9--];
            }
        }
        return byArray3;
    }

    private String internalFontName(h h2, String string, boolean bl, boolean bl2) {
        Object object;
        String string2;
        String string3 = PlatformUtils.getGenericLibPath("touchLibs" + File.separator + "etc" + File.separator + "fonts" + File.separator + "fonts" + File.separator + "c" + File.separator + "a" + File.separator + "r" + File.separator);
        String string4 = string.toLowerCase();
        if (string4.endsWith("-aa")) {
            string4 = string4.substring(0, string4.length() - 3);
        }
        String string5 = "";
        if (h2 == c.r) {
            string5 = ".touch";
        }
        if ((string2 = "" + (bl ? ".bold" : "") + (bl2 ? ".italic" : "")).length() == 0) {
            string2 = ".plain";
        }
        String string6 = string4 + string5 + string2;
        String string7 = "";
        try {
            object = null;
            if (null != FONT_MAP_RESOURCE_CACHE[0]) {
                object = (ResourceBundle)FONT_MAP_RESOURCE_CACHE[0];
            } else {
                FreeTypeFontManager.FONT_MAP_RESOURCE_CACHE[0] = ResourceBundle.getBundle("com.amazon.epub.reader.font.resources.FontMaps", LanguageTag.toLocale(""));
                object = (ResourceBundle)FONT_MAP_RESOURCE_CACHE[0];
            }
            string7 = (String)((ResourceBundle)object).getObject(string6);
        }
        catch (MissingResourceException missingResourceException) {
            LOG.log(Level.SEVERE, "Exception while loading the font, Font name " + string + " is not present", missingResourceException);
            throw new IllegalArgumentException("Fonts can't be loaded" + missingResourceException.getMessage());
        }
        object = string3 + string7;
        return object;
    }
}

