/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindlepreview.common.utils;

import com.amazon.kindlepreview.common.utils.f;
import com.amazon.kindlepreview.common.utils.g;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.management.VMManagement;

public class PlatformUtils {
    private static Logger iLogger = Logger.getLogger("PlatformUtils");
    private static String libPath = null;
    private static boolean overRideRunAsService = false;

    public static void setLibPath(String string) {
        libPath = string;
    }

    public static void setServiceOverride() {
        overRideRunAsService = true;
    }

    public static f getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        f f2 = f.a;
        if (string.indexOf("windows") >= 0) {
            f2 = f.b;
        } else if (string.indexOf("linux") >= 0) {
            f2 = f.c;
        } else if (string.indexOf("mac os x") >= 0) {
            f2 = f.d;
        } else {
            iLogger.log(Level.WARNING, "Unknown or unsupported platform identified by Kindle Previewer");
        }
        return f2;
    }

    public static String getJavaProcId() {
        f f2 = PlatformUtils.getPlatform();
        if (f2 == f.c || f2 == f.d) {
            return "";
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            Field field = runtimeMXBean.getClass().getDeclaredField("jvm");
            field.setAccessible(true);
            VMManagement vMManagement = (VMManagement)field.get(runtimeMXBean);
            Method method = vMManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            method.setAccessible(true);
            Integer n2 = (Integer)method.invoke((Object)vMManagement, new Object[0]);
            return String.valueOf(n2);
        }
        catch (Exception exception) {
            iLogger.log(Level.WARNING, " Exception while trying to find java proc id", exception);
            return "-1";
        }
    }

    public static boolean isLeopard() {
        if (PlatformUtils.getPlatform() != f.d) {
            return false;
        }
        List<String> list = Arrays.asList("sw_vers");
        g g2 = new g(list, true);
        Process process = null;
        try {
            process = g2.a();
            int n2 = process.waitFor();
            if (n2 != 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            iLogger.log(Level.WARNING, "Failed to identify if platform is Mac Leopard", iOException);
        }
        catch (InterruptedException interruptedException) {
            iLogger.log(Level.WARNING, "Failed to identify if platform is Mac Leopard", interruptedException);
        }
        String string = g2.b();
        return string != null && string.contains("10.5");
    }

    public static boolean isMacLion() {
        if (PlatformUtils.getPlatform() != f.d) {
            return false;
        }
        String string = System.getProperty("os.version");
        return string != null && string.toLowerCase().contains("10.8");
    }

    static String a() {
        String string = System.getProperty("user.dir") + File.separator + "LocalLib";
        File file = new File(string);
        if (!file.exists() || file.exists() && !file.isDirectory()) {
            file.mkdir();
        }
        string = string + File.separator;
        return string;
    }

    private static String getDevLibFolder() {
        String string = ".." + File.separator + "KindlePreviewNative";
        string = string + File.separator + "lib" + File.separator;
        switch (PlatformUtils.getPlatform()) {
            case b: {
                string = string + "Win32";
                break;
            }
            case d: {
                string = string + "mac";
                break;
            }
        }
        String string2 = new File(string).getAbsolutePath();
        string2 = string2 + File.separator;
        return string2;
    }

    public static String getGenericLibPath(String string) {
        if (libPath != null) {
            return libPath + File.separator + string;
        }
        String string2 = System.getProperty("user.dir");
        if (new File(string2 = string2 + File.separator + "lib" + File.separator + string).exists()) {
            return string2;
        }
        return PlatformUtils.getDevLibFolder() + string;
    }

    public static String getFontFilePath(String string) {
        if (libPath != null) {
            return libPath + File.separator + "touchLibs" + File.separator + "etc" + File.separator + "fonts" + File.separator + "fonts" + File.separator + string;
        }
        String string2 = System.getProperty("user.dir");
        if (new File(string2 = string2 + File.separator + "lib" + File.separator + "touchLibs" + File.separator + "etc" + File.separator + "fonts" + File.separator + "fonts" + File.separator + string).exists()) {
            return string2;
        }
        return PlatformUtils.getDevLibFolder() + File.separator + "touchLibs" + File.separator + "etc" + File.separator + "fonts" + File.separator + "fonts" + File.separator + string;
    }

    public static void loadJNILib(String string) {
        if (libPath != null) {
            try {
                System.load(libPath + File.separator + string);
            }
            catch (Throwable throwable) {
                iLogger.log(Level.SEVERE, "Failed to load JNI library " + string, throwable);
                throw new IllegalStateException(throwable);
            }
            return;
        }
        String string2 = "";
        String string3 = System.getProperty("user.dir");
        string2 = new File(string3 = string3 + File.separator + "lib" + File.separator + string).exists() ? string3 : PlatformUtils.getDevLibFolder() + string;
        try {
            System.load(string2);
        }
        catch (Throwable throwable) {
            iLogger.log(Level.SEVERE, "Failed to load JNI library " + string2, throwable);
            throw new IllegalStateException(throwable);
        }
    }

    public static boolean runAsBookViewService() {
        return overRideRunAsService || PlatformUtils.getPlatform() == f.c || PlatformUtils.getPlatform() == f.a;
    }

    public static boolean webReaderSupportsPortOption() {
        return PlatformUtils.getPlatform() == f.c || PlatformUtils.getPlatform() == f.a;
    }

    public static boolean isLinuxPlatform() {
        return PlatformUtils.getPlatform() == f.c;
    }
}

