/* Demo Note:  This demo uses a FileProgress class that handles the UI for displaying the file name and percent complete.
The FileProgress class is not part of SWFUpload.
*/


/* **********************
   Event Handlers
   These are my custom event handlers to make my
   web application behave the way I went when SWFUpload
   completes different tasks.  These aren't part of the SWFUpload
   package.  They are part of my application.  Without these none
   of the actions SWFUpload makes will show up in my application.
   ********************** */
function fileQueued(file) {
	try {
	   //ļǷ
	   for(var i=0;i<file.index;i++)
	   {
	      var file_i = this.getFile(i);//alert(file_i.modificationdate==file.modificationdate)
	      if(file_i.filestatus !=SWFUpload.FILE_STATUS.CANCELLED && file_i.name==file.name && file_i.size==file.size && file_i.creationdate.getTime()==file.creationdate.getTime() && file_i.modificationdate.getTime()==file.modificationdate.getTime())
	      {
	      	 var msg1 = sprintf(td_lang.inc.msg_114,file.name);
	         alert(msg1);
	         this.cancelUpload(file.id);
	         return;
	      }
	      
	   }
	   
	   //OAòϴĳЩļʱ򣬽м
	   var fileType = file.type.toLowerCase().substr(1);
	   if(oa_upload_limit == 1 && (oa_limit_type.indexOf(fileType+",")==0 || oa_limit_type.indexOf(","+fileType+",")>0))
	   {
	   	  var msg2 = sprintf(td_lang.inc.msg_115,fileType);
	      alert(msg2);
	      this.cancelUpload(file.id);
	      return;
	   }
	   
		var progress = new FileProgress(file, this.customSettings.progressTarget);
//		progress.setStatus("ȴϴ...");//pending...
		progress.toggleCancel(true, this);
	} catch (ex) {
		this.debug(ex);
	}

}

function fileQueueError(file, errorCode, message) {
	try {
		if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
			var msg3 = sprintf(td_lang.inc.msg_116,message);
			alert(td_lang.module.msg_35+"\n" + (message === 0 ? "" : msg3));
			return;
		}

		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);

		switch (errorCode) {
		case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			var msg4 = sprintf(td_lang.inc.msg_117,Math.ceil(file.size/1024/1024),this.settings['file_size_limit']);
			progress.setStatus(msg4);
			this.debug("Error Code: File too big, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			progress.setStatus(td_lang.module.msg_47);//"ϴ0ֽļ"
			this.debug("Error Code: Zero byte file, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			progress.setStatus(td_lang.module.msg_48);//"Чļ"
			this.debug("Error Code: Invalid File Type, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		default:
			if (file !== null) {
				progress.setStatus(td_lang.module.msg_49 + message);//"δ֪"
			}
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
        this.debug(ex);
    }
    progress.setCancelled();
}

function fileDialogComplete(numFilesSelected, numFilesQueued) {
	try {
		if (numFilesSelected > 0) {
			document.getElementById(this.customSettings.uploadArea).style.display='block';
		    if (this.getStats().files_queued > 0) {
			   document.getElementById(this.customSettings.startButtonId).disabled = false;
			   document.getElementById(this.customSettings.cancelButtonId).disabled = false;
			}else{            
			   document.getElementById(this.customSettings.cancelButtonId).disabled = false;
            }
		}
		//window.scrollTo(0,document.getElementById(this.customSettings.uploadArea).offsetHeight)
		
		/* I want auto start the upload and I can do that here */
		//this.startUpload();
	} catch (ex)  {
        this.debug(ex);
	}
}

function uploadStart(file) {
	try {
		/* I don't want to do any file validation or anything,  I'll just update the UI and
		return true to indicate that the upload should start.
		It's important to update the UI here because in Linux no uploadProgress events are called. The best
		we can do is say we are uploading.
		 */
		document.getElementById(this.customSettings.startButtonId).disabled = true;
		var progress = new FileProgress(file, this.customSettings.progressTarget);
//		progress.setStatus("ϴ...");
		progress.toggleCancel(true, this);
	}
	catch (ex) {
	   this.debug(ex);
	}
	
	return true;
}

function uploadProgress(file, bytesLoaded, bytesTotal) {
	try {
		var percent = Math.ceil((bytesLoaded / bytesTotal) * 100);

		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setProgress(percent);
//		progress.setStatus("ϴ... "+percent+"%");
	} catch (ex) {
		this.debug(ex);
	}
}

function uploadSuccess(file, serverData) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.toggleCancel(false);
		if(serverData.substr(0,5)=="-ERR ")
		{
		   progress.setError();
		   progress.setStatus( td_lang.module.msg_50+ serverData.substr(5));//"ϴʧܣ"
		   
		   var stats=this.getStats();
		   stats.successful_uploads--;
		   stats.upload_errors++;
		   this.setStats(stats);
		}
		else
		{
		   progress.setComplete();
//		   progress.setStatus("ϴɡ");
		}

	} catch (ex) {
		this.debug(ex);
	}
}

function uploadError(file, errorCode, message) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);

		switch (errorCode) {
		case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
			progress.setStatus( td_lang.module.msg_51+ message);//"HTTP"
			this.debug("Error Code: HTTP Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
			progress.setStatus( td_lang.module.msg_52+ message);//"ϴʧܣ"
			this.debug("Error Code: Upload Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.IO_ERROR:
			progress.setStatus( td_lang.module.msg_53+ message);//"(IO)"
			this.debug("Error Code: IO Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
			progress.setStatus( td_lang.module.msg_54+ message);//"ȫ"
			this.debug("Error Code: Security Error, File name: " + file.name + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
			progress.setStatus( td_lang.module.msg_55+ message);//"ﵽϴƣ"
			this.debug("Error Code: Upload Limit Exceeded, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			progress.setStatus( td_lang.module.msg_56+ message);//"޷֤ϴ"
			this.debug("Error Code: File Validation Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			// If there aren't any files left (they were all cancelled) disable the cancel button
			if (this.getStats().files_queued === 0) {
				document.getElementById(this.customSettings.startButtonId).disabled = true;
				document.getElementById(this.customSettings.cancelButtonId).disabled = false;
                document.getElementById(this.customSettings.uploadArea).style.display='none';
			}
			progress.setStatus(td_lang.module.msg_57);//"ȡ"
			progress.setCancelled();
			break;
		case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			progress.setStatus(td_lang.module.msg_58);//"ֹͣ"
			break;
		default:
			progress.setStatus( td_lang.module.msg_49+ errorCode);//"δ֪"
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
        this.debug(ex);
    }
}

function uploadComplete(file) {
	if (this.getStats().files_queued === 0) {
		document.getElementById(this.customSettings.startButtonId).disabled = true;
		document.getElementById(this.customSettings.cancelButtonId).disabled = false;
        document.getElementById(this.customSettings.uploadArea).style.display='none';
	}
}

// This event comes from the Queue Plugin
function queueComplete(numFilesUploaded) {
	var status = document.getElementById("totalStatics");
	var stats = this.getStats();
	var msg5 = sprintf(td_lang.inc.msg_118,stats.successful_uploads,stats.upload_errors,stats.upload_cancelled);
	status.innerHTML = msg5;
}
