/*
 * Decompiled with CFR 0.152.
 */
package nn;

import java.util.ArrayList;
import nn.Connection;
import nn.HiddenNeuron;
import nn.InputNeuron;
import nn.Neuron;
import nn.OutputNeuron;

public class Network {
    InputNeuron[] input;
    HiddenNeuron[] hidden;
    OutputNeuron output;
    public static final float LEARNING_CONSTANT = 0.5f;

    public Network(int inputs, int hiddentotal) {
        this.input = new InputNeuron[inputs + 1];
        this.hidden = new HiddenNeuron[hiddentotal + 1];
        int i = 0;
        while (i < this.input.length - 1) {
            this.input[i] = new InputNeuron();
            ++i;
        }
        i = 0;
        while (i < this.hidden.length - 1) {
            this.hidden[i] = new HiddenNeuron();
            ++i;
        }
        this.input[this.input.length - 1] = new InputNeuron(1);
        this.hidden[this.hidden.length - 1] = new HiddenNeuron(1);
        this.output = new OutputNeuron();
        i = 0;
        while (i < this.input.length) {
            int j = 0;
            while (j < this.hidden.length - 1) {
                Connection c = new Connection(this.input[i], this.hidden[j]);
                this.input[i].addConnection(c);
                this.hidden[j].addConnection(c);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.hidden.length) {
            Connection c = new Connection(this.hidden[i], this.output);
            this.hidden[i].addConnection(c);
            this.output.addConnection(c);
            ++i;
        }
    }

    public float feedForward(float[] inputVals) {
        int i = 0;
        while (i < inputVals.length) {
            this.input[i].input(inputVals[i]);
            ++i;
        }
        i = 0;
        while (i < this.hidden.length - 1) {
            this.hidden[i].calcOutput();
            ++i;
        }
        this.output.calcOutput();
        return this.output.getOutput();
    }

    public float train(float[] inputs, float answer) {
        float result = this.feedForward(inputs);
        float deltaOutput = result * (1.0f - result) * (answer - result);
        ArrayList connections = this.output.getConnections();
        int i = 0;
        while (i < connections.size()) {
            Connection c = (Connection)connections.get(i);
            Neuron neuron = c.getFrom();
            float output = neuron.getOutput();
            float deltaWeight = output * deltaOutput;
            c.adjustWeight(0.5f * deltaWeight);
            ++i;
        }
        i = 0;
        while (i < this.hidden.length) {
            connections = this.hidden[i].getConnections();
            float sum = 0.0f;
            int j = 0;
            while (j < connections.size()) {
                Connection c = (Connection)connections.get(j);
                if (c.getFrom() == this.hidden[i]) {
                    sum += c.getWeight() * deltaOutput;
                }
                ++j;
            }
            j = 0;
            while (j < connections.size()) {
                Connection c = (Connection)connections.get(j);
                if (c.getTo() == this.hidden[i]) {
                    float output = this.hidden[i].getOutput();
                    float deltaHidden = output * (1.0f - output);
                    Neuron neuron = c.getFrom();
                    float deltaWeight = neuron.getOutput() * (deltaHidden *= sum);
                    c.adjustWeight(0.5f * deltaWeight);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

