/*
 * Decompiled with CFR 0.152.
 */
package nn;

import java.util.ArrayList;
import nn.Connection;

public class Neuron {
    protected float output;
    protected ArrayList connections;
    protected boolean bias = false;

    public Neuron() {
        this.output = 0.0f;
        this.connections = new ArrayList();
        this.bias = false;
    }

    public Neuron(int i) {
        this.output = i;
        this.connections = new ArrayList();
        this.bias = true;
    }

    public void calcOutput() {
        if (!this.bias) {
            float sum = 0.0f;
            float bias = 0.0f;
            int i = 0;
            while (i < this.connections.size()) {
                Connection c = (Connection)this.connections.get(i);
                Neuron from = c.getFrom();
                Neuron to = c.getTo();
                if (to == this) {
                    if (from.bias) {
                        bias = from.getOutput() * c.getWeight();
                    } else {
                        sum += from.getOutput() * c.getWeight();
                    }
                }
                ++i;
            }
            this.output = Neuron.f(bias + sum);
        }
    }

    void addConnection(Connection c) {
        this.connections.add(c);
    }

    float getOutput() {
        return this.output;
    }

    public static float f(float x) {
        return 1.0f / (1.0f + (float)Math.exp(-x));
    }

    public ArrayList getConnections() {
        return this.connections;
    }
}

