/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Buffer;
import org.gstreamer.ClockReturn;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.FlowReturn;
import org.gstreamer.MiniObject;
import org.gstreamer.Pad;
import org.gstreamer.lowlevel.BaseSinkAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.NativeObject;

public class BaseSink
extends Element {
    public static final String GTYPE_NAME = "GstBaseSink";

    private static final BaseSinkAPI gst() {
        return BaseSinkAPI.BASESINK_API;
    }

    public BaseSink(NativeObject.Initializer init) {
        super(init);
    }

    public FlowReturn preroll(MiniObject obj) {
        return BaseSink.gst().gst_base_sink_do_preroll(this, obj);
    }

    public FlowReturn waitPreroll() {
        return BaseSink.gst().gst_base_sink_wait_preroll(this);
    }

    public void setSync(boolean sync) {
        BaseSink.gst().gst_base_sink_set_sync(this, sync);
    }

    public boolean isSync() {
        return BaseSink.gst().gst_base_sink_get_sync(this);
    }

    public void setMaximumLateness(long lateness, TimeUnit units) {
        BaseSink.gst().gst_base_sink_set_max_lateness(this, units.toNanos(lateness));
    }

    public long getMaximumLateness(TimeUnit units) {
        return units.convert(BaseSink.gst().gst_base_sink_get_max_lateness(this), TimeUnit.NANOSECONDS);
    }

    public void setQOSEnabled(boolean qos) {
        BaseSink.gst().gst_base_sink_set_qos_enabled(this, qos);
    }

    public boolean isQOSEnabled() {
        return BaseSink.gst().gst_base_sink_is_qos_enabled(this);
    }

    public void enableAsync(boolean enabled) {
        BaseSink.gst().gst_base_sink_set_async_enabled(this, enabled);
    }

    public boolean isAsync() {
        return BaseSink.gst().gst_base_sink_is_async_enabled(this);
    }

    public void setTsOffset(long offset) {
        BaseSink.gst().gst_base_sink_set_ts_offset(this, offset);
    }

    public long getTsOffset() {
        return BaseSink.gst().gst_base_sink_get_ts_offset(this);
    }

    public Buffer getLastBuffer() {
        return BaseSink.gst().gst_base_sink_get_last_buffer(this);
    }

    public void enableLastBuffer(boolean enable) {
        BaseSink.gst().gst_base_sink_set_last_buffer_enabled(this, enable);
    }

    public boolean isLastBufferEnabled() {
        return BaseSink.gst().gst_base_sink_is_last_buffer_enabled(this);
    }

    public boolean queryLatency(boolean live, boolean upstream_live, ClockTime min_latency, ClockTime max_latency) {
        return BaseSink.gst().gst_base_sink_query_latency(this, live, upstream_live, min_latency, max_latency);
    }

    public ClockTime getLatency() {
        return BaseSink.gst().gst_base_sink_get_latency(this);
    }

    public void setRenderDelay(ClockTime delay) {
        BaseSink.gst().gst_base_sink_set_render_delay(this, delay);
    }

    public ClockTime getRenderDelay() {
        return BaseSink.gst().gst_base_sink_get_render_delay(this);
    }

    public void setBlocksize(int blocksize) {
        BaseSink.gst().gst_base_sink_set_blocksize(this, blocksize);
    }

    public int getBlocksize() {
        return BaseSink.gst().gst_base_sink_get_blocksize(this);
    }

    public ClockReturn waitClock(ClockTime time, Pointer jitter) {
        return BaseSink.gst().gst_base_sink_wait_clock(this, time, jitter);
    }

    public FlowReturn waitEOS(ClockTime time, Pointer jitter) {
        return BaseSink.gst().gst_base_sink_wait_eos(this, time, jitter);
    }

    public void connect(HANDOFF listener) {
        this.connect(HANDOFF.class, listener, new HandoffCallback(listener));
    }

    public void disconnect(HANDOFF listener) {
        this.disconnect(HANDOFF.class, listener);
    }

    public void connect(PREROLL_HANDOFF listener) {
        this.connect(PREROLL_HANDOFF.class, listener, new PrerollHandoffCallback(listener));
    }

    public void disconnect(PREROLL_HANDOFF listener) {
        this.disconnect(PREROLL_HANDOFF.class, listener);
    }

    public static interface PREROLL_HANDOFF {
        public void prerollHandoff(BaseSink var1, Buffer var2, Pad var3);
    }

    private static class PrerollHandoffCallback
    implements GstAPI.GstCallback {
        final PREROLL_HANDOFF listener;

        public PrerollHandoffCallback(PREROLL_HANDOFF listener) {
            this.listener = listener;
        }

        public void callback(BaseSink sink, Buffer buffer, Pad pad) {
            this.listener.prerollHandoff(sink, buffer, pad);
        }
    }

    private static class HandoffCallback
    implements GstAPI.GstCallback {
        final HANDOFF listener;

        public HandoffCallback(HANDOFF listener) {
            this.listener = listener;
        }

        public void callback(BaseSink sink, Buffer buffer, Pad pad) {
            this.listener.handoff(sink, buffer, pad);
        }
    }

    public static interface HANDOFF {
        public void handoff(BaseSink var1, Buffer var2, Pad var3);
    }
}

