/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.io;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.gstreamer.Buffer;
import org.gstreamer.FlowReturn;
import org.gstreamer.elements.CustomSink;
import org.gstreamer.io.StreamLock;

public class WriteableByteChannelSink
extends CustomSink {
    private WritableByteChannel channel;
    private boolean autoFlushBuffer = false;
    private StreamLock lock = null;

    public WriteableByteChannelSink(WritableByteChannel channel, String name) {
        super(WriteableByteChannelSink.class, name);
        this.channel = channel;
    }

    public void setAutoFlushBuffer(boolean value) {
        this.autoFlushBuffer = value;
    }

    public void setNotifyOnError(StreamLock sl) {
        this.lock = sl;
    }

    private void signalError() {
        if (null != this.lock) {
            this.lock.setDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlowReturn sinkRender(Buffer buffer) throws IOException {
        try {
            this.channel.write(buffer.getByteBuffer());
            FlowReturn flowReturn = FlowReturn.OK;
            return flowReturn;
        }
        catch (IOException ex) {
            this.signalError();
            FlowReturn flowReturn = FlowReturn.ERROR;
            return flowReturn;
        }
        finally {
            if (this.autoFlushBuffer && buffer != null && buffer.getAddress() != null) {
                buffer.dispose();
            }
        }
    }
}

