/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DedicatedDxfFileInputStream;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfInterface;
import de.escape.quincunx.dxf.reader.DxfReaderReporter;
import de.escape.quincunx.dxf.reader.DxfTable;
import de.escape.quincunx.dxf.reader.DxfTableCollector;
import de.escape.quincunx.dxf.reader.DxfUnsupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class DxfGroups {
    static final byte COMMENT = -1;
    static final byte NOTHING = 0;
    static final byte STRING = 1;
    static final byte VARNAME = 1;
    static final byte LAYER = 1;
    static final byte LTYPE = 1;
    static final byte ENTITY = 1;
    static final byte CLASS = 1;
    static final byte INT = 2;
    static final byte COUNTER = 2;
    static final byte FLOAT = 3;
    static final byte XVAL = 3;
    static final byte YVAL = 3;
    static final byte ZVAL = 3;
    static final byte COLOR = 4;
    static final byte BYTEARR = 5;
    static final byte LONGINT = 6;
    static final int COMMENT_NUM = 999;
    static final int EED_START = 1000;
    private static final byte[] typeArr;
    private static final byte[] eedTypeArr;
    private Hashtable dxfClassTable;
    private static String entityClassHead;
    private static Class dxfVertexClass;
    private DedicatedDxfFileInputStream dxfStream;
    protected short number;
    protected DxfFile file;
    protected DxfReaderReporter reporter;
    private long steps;
    private long step;
    protected long fileLength = -1L;
    private boolean reRead = false;

    private void init(DxfReaderReporter report, DxfFile file) {
        if (entityClassHead == null) {
            entityClassHead = this.getClass().getName();
            int dot = entityClassHead.lastIndexOf(46);
            entityClassHead = dot == -1 ? "Dxf" : String.valueOf(entityClassHead.substring(0, dot + 1)) + "Dxf";
            try {
                dxfVertexClass = Class.forName(String.valueOf(entityClassHead) + "VERTEX");
            }
            catch (Exception exception) {
                dxfVertexClass = null;
            }
        }
        this.file = file;
        this.reporter = report;
        if (report != null) {
            int type = this.dxfStream.getType();
            if ((type & 0x30) != 0) {
                report.showStatusRes("msgPacked");
            }
            if (this.dxfStream.isBinary()) {
                report.showStatusRes("msgBinary");
            }
        }
    }

    public DxfGroups(String fileName, DxfFile file, DxfReaderReporter report) throws DxfException {
        this.dxfStream = new DedicatedDxfFileInputStream(fileName);
        this.fileLength = this.dxfStream.getFileLength();
        if (this.fileLength > 0L) {
            this.steps = this.fileLength / 200L / 10L;
            if (this.steps < 1L) {
                this.steps = 1L;
            }
            this.step = this.steps;
        } else if (report != null) {
            report.showProgress();
        }
        this.init(report, file);
    }

    public DxfGroups(InputStream is, DxfFile file, DxfReaderReporter report) throws DxfException {
        this.dxfStream = new DedicatedDxfFileInputStream(is);
        this.init(report, file);
    }

    static byte type(short num) {
        if (num >= 0) {
            if (num < typeArr.length) {
                return typeArr[num];
            }
            if (num < 999) {
                return typeArr[num % 100];
            }
            if (num == 999) {
                return -1;
            }
            if (num < 1000 + eedTypeArr.length) {
                return eedTypeArr[num - 1000];
            }
        }
        return 0;
    }

    public byte type() {
        return DxfGroups.type(this.number);
    }

    void unread() {
        this.reRead = true;
    }

    void read() throws DxfException {
        if (this.reRead) {
            this.reRead = false;
            return;
        }
        try {
            do {
                this.number = this.dxfStream.read2Lines();
            } while (DxfGroups.type(this.number) <= 0);
            if (this.reporter != null && this.step-- <= 0L) {
                if (this.fileLength > 0L) {
                    this.reporter.showProgress(this.dxfStream.getFilePointer(), this.fileLength);
                } else {
                    this.reporter.showProgress();
                }
                this.step = this.steps;
            }
        }
        catch (IOException x) {
            throw new DxfException(String.valueOf(x.getMessage()) + " in line " + this.dxfStream.getLines());
        }
        catch (NumberFormatException numberFormatException) {
            if (this.dxfStream.getLines() == 1) {
                throw new DxfException("err!DxfFile");
            }
            throw new DxfException("err!Group", new String[]{String.valueOf(this.dxfStream.getLines())});
        }
    }

    String valToString() throws DxfException {
        return this.dxfStream.getString();
    }

    float valToFloat() throws DxfException {
        return this.dxfStream.getFloat();
    }

    int valToInt() throws DxfException {
        return this.dxfStream.getInt();
    }

    short valToColor() throws DxfException {
        return this.dxfStream.getColor();
    }

    DxfEntity entityByName(String name) {
        Class<?> c;
        if (this.dxfClassTable == null) {
            this.dxfClassTable = new Hashtable(64);
        }
        if ((c = (Class<?>)this.dxfClassTable.get(name)) == null) {
            try {
                try {
                    c = Class.forName(String.valueOf(entityClassHead) + name);
                }
                catch (Exception exception) {
                    if (this.reporter != null) {
                        this.reporter.warnUnknownEntity(name);
                    }
                    c = Class.forName(String.valueOf(entityClassHead) + "Entity");
                }
                this.dxfClassTable.put(name, c);
            }
            catch (Exception exception) {
                return new DxfEntity();
            }
        }
        try {
            return (DxfEntity)c.newInstance();
        }
        catch (Exception exception) {
            return new DxfEntity();
        }
    }

    DxfTable tableByName(String name) {
        Class<?> c;
        if (this.dxfClassTable == null) {
            this.dxfClassTable = new Hashtable(64);
        }
        if ((c = (Class<?>)this.dxfClassTable.get(name)) == null) {
            try {
                try {
                    c = Class.forName(String.valueOf(entityClassHead) + name);
                }
                catch (Exception exception) {
                    c = Class.forName(String.valueOf(entityClassHead) + "Table");
                }
                this.dxfClassTable.put(name, c);
            }
            catch (Exception exception) {
                return new DxfTable();
            }
        }
        try {
            return (DxfTable)c.newInstance();
        }
        catch (Exception exception) {
            return new DxfTable();
        }
    }

    public void readEntities(DxfEntityCollector cool) throws DxfException {
        this.readEntitiesInternally(cool);
        this.unread();
    }

    private void readEntitiesInternally(DxfEntityCollector cool) throws DxfException {
        DxfEntity e = null;
        while (true) {
            try {
                this.read();
            }
            catch (Exception x) {
                String msg = x.getMessage();
                throw new DxfException("err!Read", new String[]{msg == null ? x.toString() : msg, String.valueOf(this.dxfStream.getLines())});
            }
            if (this.number == 0) {
                if (e != null) {
                    DxfEntityCollector collector = e.getEntityCollector();
                    if (collector != null) {
                        this.unread();
                        this.readEntitiesInternally(collector);
                    }
                    e.finishRead(this.file);
                    try {
                        if (!cool.addEntity(e)) {
                            return;
                        }
                    }
                    catch (DxfUnsupportedException x) {
                        String msg = x.getMessage();
                        throw new DxfException("err!Read", new String[]{msg == null ? x.toString() : msg, String.valueOf(this.dxfStream.getLines())});
                    }
                }
                e = this.entityByName(this.dxfStream.getString());
                continue;
            }
            this.set(e);
        }
    }

    private void set(DxfInterface inter) throws DxfException {
        if (inter != null && this.number > 0) {
            switch (DxfGroups.type(this.number)) {
                case 1: {
                    inter.setGroup(this.number, this.valToString());
                    break;
                }
                case 2: {
                    inter.setGroup(this.number, this.valToInt());
                    break;
                }
                case 3: {
                    inter.setGroup(this.number, this.valToFloat());
                    break;
                }
                case 4: {
                    inter.setGroup(this.number, this.valToColor());
                    break;
                }
            }
        }
    }

    void readTables(DxfTableCollector cool) throws DxfException {
        this.readTables(cool, false);
    }

    void readTables(DxfTableCollector cool, boolean reuseFirst) throws DxfException {
        DxfTable t = null;
        while (true) {
            if (reuseFirst) {
                reuseFirst = false;
            } else {
                this.read();
            }
            if (this.number == 0) {
                if (t != null) {
                    t.finishRead(this.file);
                    try {
                        cool.addTable(t);
                    }
                    catch (Exception exception) {}
                    t = null;
                }
                if (!(t = this.tableByName(this.dxfStream.getString())).isTerm()) continue;
                return;
            }
            this.set(t);
        }
    }

    public String toString() {
        try {
            return "#" + this.number + ":\t'" + this.dxfStream.getString() + "'";
        }
        catch (DxfException dxfException) {
            return "#" + this.number + ":\t???";
        }
    }

    public int getLineNr() {
        return this.dxfStream.getLines();
    }

    static {
        byte[] byArray = new byte[400];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 3;
        byArray[11] = 3;
        byArray[12] = 3;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 3;
        byArray[16] = 3;
        byArray[17] = 3;
        byArray[18] = 3;
        byArray[19] = 3;
        byArray[20] = 3;
        byArray[21] = 3;
        byArray[22] = 3;
        byArray[23] = 3;
        byArray[24] = 3;
        byArray[25] = 3;
        byArray[26] = 3;
        byArray[27] = 3;
        byArray[28] = 3;
        byArray[29] = 3;
        byArray[30] = 3;
        byArray[31] = 3;
        byArray[32] = 3;
        byArray[33] = 3;
        byArray[34] = 3;
        byArray[35] = 3;
        byArray[36] = 3;
        byArray[37] = 3;
        byArray[38] = 3;
        byArray[39] = 3;
        byArray[40] = 3;
        byArray[41] = 3;
        byArray[42] = 3;
        byArray[43] = 3;
        byArray[44] = 3;
        byArray[45] = 3;
        byArray[46] = 3;
        byArray[47] = 3;
        byArray[48] = 3;
        byArray[49] = 3;
        byArray[50] = 3;
        byArray[51] = 3;
        byArray[52] = 3;
        byArray[53] = 3;
        byArray[54] = 3;
        byArray[55] = 3;
        byArray[56] = 3;
        byArray[57] = 3;
        byArray[58] = 3;
        byArray[59] = 3;
        byArray[60] = 2;
        byArray[61] = 2;
        byArray[62] = 4;
        byArray[63] = 2;
        byArray[64] = 2;
        byArray[65] = 2;
        byArray[66] = 2;
        byArray[67] = 2;
        byArray[68] = 2;
        byArray[69] = 2;
        byArray[70] = 2;
        byArray[71] = 2;
        byArray[72] = 2;
        byArray[73] = 2;
        byArray[74] = 2;
        byArray[75] = 2;
        byArray[76] = 2;
        byArray[77] = 2;
        byArray[78] = 2;
        byArray[79] = 2;
        byArray[100] = 1;
        byArray[102] = 1;
        byArray[105] = 1;
        byArray[140] = 3;
        byArray[141] = 3;
        byArray[142] = 3;
        byArray[143] = 3;
        byArray[144] = 3;
        byArray[145] = 3;
        byArray[146] = 3;
        byArray[147] = 3;
        byArray[170] = 2;
        byArray[171] = 2;
        byArray[172] = 2;
        byArray[173] = 2;
        byArray[174] = 2;
        byArray[175] = 2;
        byArray[176] = 2;
        byArray[177] = 2;
        byArray[178] = 2;
        byArray[210] = 3;
        byArray[211] = 3;
        byArray[212] = 3;
        byArray[213] = 3;
        byArray[214] = 3;
        byArray[215] = 3;
        byArray[216] = 3;
        byArray[217] = 3;
        byArray[218] = 3;
        byArray[219] = 3;
        byArray[220] = 3;
        byArray[221] = 3;
        byArray[222] = 3;
        byArray[223] = 3;
        byArray[224] = 3;
        byArray[225] = 3;
        byArray[226] = 3;
        byArray[227] = 3;
        byArray[228] = 3;
        byArray[229] = 3;
        byArray[230] = 3;
        byArray[231] = 3;
        byArray[232] = 3;
        byArray[233] = 3;
        byArray[234] = 3;
        byArray[235] = 3;
        byArray[236] = 3;
        byArray[237] = 3;
        byArray[238] = 3;
        byArray[239] = 3;
        byArray[270] = 2;
        byArray[271] = 2;
        byArray[272] = 2;
        byArray[273] = 2;
        byArray[274] = 2;
        byArray[275] = 2;
        byArray[276] = 2;
        byArray[280] = 2;
        byArray[281] = 2;
        byArray[282] = 2;
        byArray[283] = 2;
        byArray[284] = 2;
        byArray[285] = 2;
        byArray[286] = 2;
        byArray[287] = 2;
        byArray[288] = 2;
        byArray[330] = 1;
        byArray[340] = 1;
        byArray[350] = 1;
        byArray[370] = 2;
        byArray[380] = 2;
        byArray[390] = 1;
        typeArr = byArray;
        eedTypeArr = new byte[]{1, 1, 1, 1, 5, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 2, 2, 2, 2, 2, 2, 2};
        entityClassHead = null;
    }
}

