/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.AbstractMapLayout;
import treemap.Mappable;
import treemap.Rect;

public class BinaryTreeLayout
extends AbstractMapLayout {
    public void layout(Mappable[] items, Rect bounds) {
        this.layout(items, 0, items.length - 1, bounds);
    }

    public void layout(Mappable[] items, int start, int end, Rect bounds) {
        this.layout(items, start, end, bounds, true);
    }

    public void layout(Mappable[] items, int start, int end, Rect bounds, boolean vertical) {
        if (start > end) {
            return;
        }
        if (start == end) {
            items[start].setBounds(bounds);
            return;
        }
        int mid = (start + end) / 2;
        double total = this.sum(items, start, end);
        double first = this.sum(items, start, mid);
        double a = first / total;
        double x = bounds.x;
        double y = bounds.y;
        double w = bounds.w;
        double h = bounds.h;
        if (vertical) {
            Rect b1 = new Rect(x, y, w * a, h);
            Rect b2 = new Rect(x + w * a, y, w * (1.0 - a), h);
            this.layout(items, start, mid, b1, !vertical);
            this.layout(items, mid + 1, end, b2, !vertical);
        } else {
            Rect b1 = new Rect(x, y, w, h * a);
            Rect b2 = new Rect(x, y + h * a, w, h * (1.0 - a));
            this.layout(items, start, mid, b1, !vertical);
            this.layout(items, mid + 1, end, b2, !vertical);
        }
    }

    private double sum(Mappable[] items, int start, int end) {
        double s = 0.0;
        int i = start;
        while (i <= end) {
            s += items[i].getSize();
            ++i;
        }
        return s;
    }

    public String getName() {
        return "Binary Tree";
    }

    public String getDescription() {
        return "Uses a static binary tree layout.";
    }
}

