/*
 * Decompiled with CFR 0.152.
 */
package treemap;

import treemap.MapModel;
import treemap.Mappable;
import treemap.Rect;
import treemap.TreeModel;

public class LayoutCalculations {
    public static double averageAspectRatio(MapModel model) {
        return LayoutCalculations.averageAspectRatio(model.getItems());
    }

    public static double averageAspectRatio(Mappable[] m) {
        double s = 0.0;
        int n = m.length;
        if (m == null || n == 0) {
            System.out.println("Can't measure aspect ratio.");
            return 0.0;
        }
        int i = 0;
        while (i < n) {
            s += m[i].getBounds().aspectRatio();
            ++i;
        }
        return s / (double)n;
    }

    public static double getReadability(TreeModel tree) {
        return LayoutCalculations.getReadability(tree.getLeafModels());
    }

    public static double getReadability(MapModel[] model) {
        int weight = 0;
        double r = 0.0;
        int i = 0;
        while (i < model.length) {
            int n = model[i].getItems().length;
            weight += n;
            r += (double)n * LayoutCalculations.getReadability(model[i]);
            ++i;
        }
        return weight == 0 ? 1.0 : r / (double)weight;
    }

    public static double getReadability(MapModel model) {
        int numTurns = 0;
        double prevAngle = 0.0;
        double angle = 0.0;
        double angleChange = 0.0;
        Mappable[] items = model.getItems();
        int i = 1;
        while (i < items.length) {
            Rect b1 = items[LayoutCalculations.getItemIndex(i - 1, model)].getBounds();
            Rect b2 = items[LayoutCalculations.getItemIndex(i, model)].getBounds();
            double dx = b2.x + 0.5 * b2.w - (b1.x + 0.5 * b1.w);
            double dy = b2.y + 0.5 * b2.h - (b1.y + 0.5 * b1.h);
            angle = Math.atan2(dy, dx);
            if (i >= 2) {
                angleChange = Math.abs(angle - prevAngle);
                if (angleChange > Math.PI) {
                    angleChange = Math.abs(angleChange - Math.PI * 2);
                }
                if (angleChange > 0.1) {
                    ++numTurns;
                }
            }
            prevAngle = angle;
            ++i;
        }
        double readability = 1.0 - (double)numTurns / (double)items.length;
        return readability;
    }

    public static int getItemIndex(int order, MapModel map) {
        Mappable[] items = map.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getOrder() == order) break;
            ++i;
        }
        return i;
    }
}

