/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.nio.ByteOrder;
import java.util.List;
import org.gstreamer.Gst;
import org.gstreamer.Plugin;
import org.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.video.LibraryLoader;
import processing.video.LibraryPath;

public class Video
implements PConstants {
    protected static String gstreamerLibPath = "";
    protected static String gstreamerPluginPath = "";
    protected static boolean passDirectBuffer = true;
    protected static boolean useGLBufferSink = true;
    protected static boolean defaultGLibContext = false;
    protected static long INSTANCES_COUNT = 0L;
    protected static int bitsJVM = PApplet.parseInt((String)System.getProperty("sun.arch.data.model"));

    protected static void init() {
        if (INSTANCES_COUNT == 0L) {
            Video.initImpl();
        }
        ++INSTANCES_COUNT;
    }

    protected static void restart() {
        Video.removePlugins();
        Gst.deinit();
        Video.initImpl();
    }

    protected static void initImpl() {
        Object object;
        String string = System.getProperty("gstreamer.library.path");
        if (string != null) {
            gstreamerLibPath = string;
            object = System.getProperty("gstreamer.plugin.path");
            if (object != null) {
                gstreamerPluginPath = object;
            }
        } else if (PApplet.platform == 3) {
            Video.buildLinuxPaths();
        } else if (PApplet.platform == 1) {
            Video.buildWindowsPaths();
        } else if (PApplet.platform == 2) {
            Video.buildMacOSXPaths();
        }
        if (!gstreamerLibPath.equals("")) {
            System.setProperty("jna.library.path", gstreamerLibPath);
        }
        if (PApplet.platform == 1 && (object = LibraryLoader.getInstance()) == null) {
            System.err.println("Cannot load local version of GStreamer libraries.");
        }
        object = new String[]{""};
        Gst.setUseDefaultContext((boolean)defaultGLibContext);
        Gst.init((String)"Processing core video", (String[])object);
        Video.addPlugins();
    }

    protected static void addPlugins() {
        Registry registry;
        boolean bl;
        if (!gstreamerPluginPath.equals("") && !(bl = (registry = Registry.getDefault()).scanPath(gstreamerPluginPath))) {
            System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginPath);
        }
    }

    protected static void removePlugins() {
        Registry registry = Registry.getDefault();
        List list = registry.getPluginList();
        for (Plugin plugin : list) {
            registry.removePlugin(plugin);
        }
    }

    protected static void buildLinuxPaths() {
        gstreamerLibPath = "";
        gstreamerPluginPath = "";
    }

    protected static void buildWindowsPaths() {
        LibraryPath libraryPath = new LibraryPath();
        String string = libraryPath.get();
        gstreamerLibPath = Video.buildGStreamerLibPath(string, "\\windows" + bitsJVM);
        gstreamerPluginPath = String.valueOf(gstreamerLibPath) + "\\plugins";
    }

    protected static void buildMacOSXPaths() {
        LibraryPath libraryPath = new LibraryPath();
        String string = libraryPath.get();
        gstreamerLibPath = Video.buildGStreamerLibPath(string, "/macosx" + bitsJVM);
        gstreamerPluginPath = String.valueOf(gstreamerLibPath) + "/plugins";
    }

    protected static String buildGStreamerLibPath(String string, String string2) {
        File file = new File(String.valueOf(string) + string2);
        if (file.exists()) {
            return String.valueOf(string) + string2;
        }
        return string;
    }

    protected static float nanoSecToSecFrac(float f) {
        int n = 0;
        while (n < 3) {
            f = (float)((double)f / 1000.0);
            ++n;
        }
        return f;
    }

    protected static long secToNanoLong(float f) {
        Float f2 = new Float((double)f * 1.0E9);
        return f2.longValue();
    }

    protected static void convertToARGB(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    int n7 = nArray[n4++];
                    nArray[n3++] = n7 >>> 8 | n7 << 24 & 0xFF000000;
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n) {
                    int n10 = nArray[n4++];
                    nArray[n3++] = (n10 & 0xFF) << 16 | (n10 & 0xFF0000) >> 16 | n10 & 0xFF00FF00;
                    ++n9;
                }
                ++n8;
            }
        }
    }
}

