/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Editor;
import processing.app.EditorConsole;
import processing.app.EditorState;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Recent;
import processing.app.Settings;
import processing.app.SingleInstance;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchReference;
import processing.app.UpdateCheck;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionManagerDialog;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ModeContribution;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.mode.java.JavaMode;

public class Base {
    private static final int REVISION = 227;
    private static String VERSION_NAME = "0227";
    public static boolean DEBUG = false;
    static HashMap<Integer, String> platformNames = new HashMap();
    static HashMap<String, Integer> platformIndices;
    static Platform platform;
    static int nativeBits;
    private static boolean commandLine;
    Preferences preferencesFrame;
    ContributionManagerDialog libraryManagerFrame;
    ContributionManagerDialog toolManagerFrame;
    ContributionManagerDialog modeManagerFrame;
    ContributionManagerDialog updateManagerFrame;
    boolean builtOnce;
    static File untitledFolder;
    protected List<Editor> editors = Collections.synchronizedList(new ArrayList());
    protected Editor activeEditor;
    public static JMenu defaultFileMenu;
    private Mode nextMode;
    private Mode[] coreModes;
    protected ArrayList<ModeContribution> modeContribs;
    private JMenu sketchbookMenu;
    private Recent recent;
    private JFileChooser openChooser;
    protected static File sketchbookFolder;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static Boolean usableOracleJava;
    protected static File processingRoot;

    static {
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
        nativeBits = 32;
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.createAndShowGUI(args);
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        try {
            String version;
            File versionFile = Base.getContentFile("lib/version.txt");
            if (versionFile.exists() && !(version = PApplet.loadStrings((File)versionFile)[0]).equals(VERSION_NAME)) {
                VERSION_NAME = version;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Base.initPlatform();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        Base.initRequirements();
        Preferences.init();
        Base.locateSketchbookFolder();
        if (!SingleInstance.alreadyRunning(args)) {
            try {
                platform.setLookAndFeel();
            }
            catch (Exception e) {
                Base.log("Could not set the Look & Feel", e);
            }
            try {
                untitledFolder = Base.createTempFolder("untitled", "sketches", null);
                untitledFolder.deleteOnExit();
            }
            catch (IOException e) {
                Base.showError("Trouble without a name", "Could not create a place to store untitled sketches.\nThat's gonna prevent us from continuing.", e);
            }
            Base.log("about to create base...");
            try {
                Base base = new Base(args);
                SingleInstance.startServer(base);
            }
            catch (Throwable t) {
                Base.showBadnessTrace("We're off on the wrong foot", "An error occurred during startup.", t, true);
            }
            Base.log("done creating base...");
        }
    }

    public static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    public static void initPlatform() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Base.isMacOS()) {
                platformClass = Class.forName("processing.app.platform.MacPlatform");
            } else if (Base.isWindows()) {
                platformClass = Class.forName("processing.app.platform.WindowsPlatform");
            } else if (Base.isLinux()) {
                platformClass = Class.forName("processing.app.platform.LinuxPlatform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            Base.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
    }

    public static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            Base.openURL("http://wiki.processing.org/w/Supported_Platforms");
            Base.showError("Missing required files", "Processing requires a JRE with tools.jar (or a\nfull JDK) installed in (or linked to) a folder\nnamed \u201cjava\u201d next to the Processing application.\nMore information can be found on the Wiki.", cnfe);
        }
    }

    private void buildCoreModes() {
        Mode javaMode = ModeContribution.load(this, Base.getContentFile("modes/java"), "processing.mode.java.JavaMode").getMode();
        this.coreModes = new Mode[]{javaMode};
        ModeContribution experimentalContrib = ModeContribution.load(this, Base.getContentFile("modes/experimental"), "processing.mode.experimental.ExperimentalMode");
        if (experimentalContrib != null) {
            Mode experimentalMode = experimentalContrib.getMode();
            this.coreModes = new Mode[]{javaMode, experimentalMode};
        }
    }

    void rebuildContribModes() {
        if (this.modeContribs == null) {
            this.modeContribs = new ArrayList();
        }
        ModeContribution.loadMissing(this);
    }

    public Base(String[] args) throws Exception {
        ContributionManager.cleanup();
        this.buildCoreModes();
        this.rebuildContribModes();
        this.recent = new Recent(this);
        String lastModeIdentifier = Preferences.get("last.sketch.mode");
        if (lastModeIdentifier == null) {
            this.nextMode = this.coreModes[0];
            Base.log("Nothing set for last.sketch.mode, using coreMode[0].");
        } else {
            for (Mode m : this.getModeList()) {
                if (!m.getIdentifier().equals(lastModeIdentifier)) continue;
                Base.logf("Setting next mode to %s.", lastModeIdentifier);
                this.nextMode = m;
            }
            if (this.nextMode == null) {
                this.nextMode = this.coreModes[0];
                Base.logf("Could not find mode %s, using default.", lastModeIdentifier);
            }
        }
        this.libraryManagerFrame = new ContributionManagerDialog(ContributionType.LIBRARY);
        this.toolManagerFrame = new ContributionManagerDialog(ContributionType.TOOL);
        this.modeManagerFrame = new ContributionManagerDialog(ContributionType.MODE);
        this.updateManagerFrame = new ContributionManagerDialog(null);
        this.nextMode.rebuildLibraryList();
        platform.init(this);
        boolean opened = false;
        int i = 0;
        while (i < args.length) {
            String path = args[i];
            if (Base.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) != null) {
                opened = true;
            }
            ++i;
        }
        if (!opened) {
            this.handleNew();
        }
        if (Preferences.getBoolean("update.check")) {
            new UpdateCheck(this);
        }
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public List<Editor> getEditors() {
        return this.editors;
    }

    protected void changeMode(Mode mode) {
        if (this.activeEditor.getMode() != mode) {
            Sketch sketch = this.activeEditor.getSketch();
            if (sketch.isModified()) {
                Base.showWarning("Save", "Please save the sketch before changing the mode.", null);
                return;
            }
            this.nextMode = mode;
            boolean newModeCanHandleCurrentSource = true;
            SketchCode[] sketchCodeArray = sketch.getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode code = sketchCodeArray[n2];
                if (!mode.validExtension(code.getExtension())) {
                    newModeCanHandleCurrentSource = false;
                    break;
                }
                ++n2;
            }
            if (newModeCanHandleCurrentSource) {
                File props = new File(sketch.getCodeFolder(), "sketch.properties");
                this.saveModeSettings(props, this.nextMode);
                this.handleClose(this.activeEditor, true);
                this.handleOpen(sketch.getMainFilePath());
            } else {
                if (sketch.isUntitled()) {
                    this.handleClose(this.activeEditor, true);
                }
                this.handleNew();
            }
        }
    }

    public ArrayList<ModeContribution> getModeContribs() {
        return this.modeContribs;
    }

    public ArrayList<Mode> getModeList() {
        ArrayList<Mode> allModes = new ArrayList<Mode>();
        allModes.addAll((Collection)Arrays.asList(this.coreModes));
        if (this.modeContribs != null) {
            for (ModeContribution contrib : this.modeContribs) {
                allModes.add(contrib.getMode());
            }
        }
        return allModes;
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
        this.nextMode = whichEditor.getMode();
        Preferences.set("last.sketch.mode", this.nextMode.getIdentifier());
    }

    public void handleNew() {
        try {
            File newbieDir = null;
            String newbieName = null;
            File newbieParentDir = untitledFolder;
            String prefix = Preferences.get("editor.untitled.prefix");
            int index = 0;
            String format = Preferences.get("editor.untitled.suffix");
            String suffix = null;
            if (format == null) {
                Calendar cal = Calendar.getInstance();
                int day = cal.get(5);
                int month = cal.get(2);
                suffix = String.valueOf(this.months[month]) + PApplet.nf((int)day, (int)2);
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat(format);
                suffix = formatter.format(new Date());
            }
            do {
                if (index == 26) {
                    if (!this.breakTime) {
                        Base.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                        this.breakTime = true;
                    } else {
                        Base.showWarning("Sunshine", "No really, time for some fresh air for you.", null);
                    }
                    return;
                }
                newbieName = String.valueOf(prefix) + suffix + (char)(97 + index);
                newbieName = Sketch.sanitizeName(newbieName);
                newbieDir = new File(newbieParentDir, newbieName);
                ++index;
            } while (newbieDir.exists() || new File(sketchbookFolder, newbieName).exists());
            newbieDir.mkdirs();
            File newbieFile = new File(newbieDir, String.valueOf(newbieName) + "." + this.nextMode.getDefaultExtension());
            if (!newbieFile.createNewFile()) {
                throw new IOException(newbieFile + " already exists.");
            }
            this.saveModeSettings(new File(newbieDir, "sketch.properties"), this.nextMode);
            String path = newbieFile.getAbsolutePath();
            this.handleOpen(path, true);
        }
        catch (IOException e) {
            Base.showWarning("That's new to me", "A strange and unexplainable error occurred\nwhile trying to create a new sketch.", e);
        }
    }

    private void saveModeSettings(File sketchProps, Mode mode) {
        try {
            Settings settings = new Settings(sketchProps);
            settings.set("mode", mode.getTitle());
            settings.set("mode.id", mode.getIdentifier());
            settings.save();
        }
        catch (IOException e) {
            System.err.println("While creating " + sketchProps + ": " + e.getMessage());
        }
    }

    public void handleOpenPrompt() {
        final ArrayList<String> extensions = new ArrayList<String>();
        for (Mode mode : this.getModeList()) {
            extensions.add(mode.getDefaultExtension());
        }
        if (Preferences.getBoolean("chooser.files.native")) {
            FileDialog openDialog = new FileDialog((Frame)this.activeEditor, "Open a Processing sketch...", 0);
            openDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }
            });
            openDialog.setVisible(true);
            String directory = openDialog.getDirectory();
            String filename = openDialog.getFile();
            if (filename != null) {
                File inputFile = new File(directory, filename);
                this.handleOpen(inputFile.getAbsolutePath());
            }
        } else {
            if (this.openChooser == null) {
                this.openChooser = new JFileChooser();
            }
            this.openChooser.setDialogTitle("Open a Processing sketch...");
            this.openChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    for (String ext : extensions) {
                        if (!file.getName().toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Processing Sketch";
                }
            });
            if (this.openChooser.showOpenDialog(this.activeEditor) == 0) {
                this.handleOpen(this.openChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public Editor handleOpen(String path) {
        return this.handleOpen(path, false);
    }

    public Editor handleOpen(String path, boolean untitled) {
        return this.handleOpen(path, untitled, new EditorState(this.editors));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Editor handleOpen(String path, boolean untitled, EditorState state) {
        try {
            Editor editor;
            File file;
            block11: {
                file = new File(path);
                if (!file.exists()) {
                    return null;
                }
                Iterator<Editor> iterator = this.editors.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    if (!Sketch.isSanitaryName(file.getName())) {
                        Base.showWarning("You're tricky, but not tricky enough", String.valueOf(file.getName()) + " is not a valid name for a sketch.\n" + "Better to stick to ASCII, no spaces, and make sure\n" + "it doesn't start with a number.", null);
                        return null;
                    }
                    break block11;
                } while (!(editor = iterator.next()).getSketch().getMainFile().equals(file));
                editor.toFront();
                this.handleRecent(editor);
                return editor;
            }
            if (!this.nextMode.canEdit(file)) {
                Mode mode = this.selectMode(file);
                if (mode == null) {
                    return null;
                }
                this.nextMode = mode;
            }
            if ((editor = this.nextMode.createEditor(this, path, state)) == null) {
                if (this.nextMode == this.coreModes[0]) {
                    Base.showError("Editor Problems", "An error occurred while trying to change modes.\nWe'll have to quit for now because it's an\nunfortunate bit of indigestion.", null);
                } else {
                    editor = this.coreModes[0].createEditor(this, path, state);
                }
            }
            if (editor.getSketch() == null) {
                return null;
            }
            editor.getSketch().setUntitled(untitled);
            this.editors.add(editor);
            this.handleRecent(editor);
            editor.setVisible(true);
            return editor;
        }
        catch (Throwable t) {
            Base.showBadnessTrace("Terrible News", "A serious error occurred while trying to create a new editor window.", t, false);
            this.nextMode = this.coreModes[0];
            return null;
        }
    }

    private static ModeInfo modeInfoFor(File sketch) {
        String id;
        String title;
        block4: {
            File sketchFolder = sketch.getParentFile();
            File sketchProps = new File(sketchFolder, "sketch.properties");
            if (!sketchProps.exists()) {
                return null;
            }
            try {
                Settings settings = new Settings(sketchProps);
                title = settings.get("mode");
                id = settings.get("mode.id");
                if (title != null && id != null) break block4;
                return null;
            }
            catch (IOException e) {
                System.err.println("While trying to read " + sketchProps + ": " + e.getMessage());
                return null;
            }
        }
        return new ModeInfo(id, title);
    }

    private Mode promptForMode(File sketch, ModeInfo preferredMode) {
        String extension = sketch.getName().substring(sketch.getName().lastIndexOf(46) + 1);
        ArrayList<Mode> possibleModes = new ArrayList<Mode>();
        for (Mode mode : this.getModeList()) {
            if (!mode.canEdit(sketch)) continue;
            possibleModes.add(mode);
        }
        if (possibleModes.size() == 1 && ((Mode)possibleModes.get(0)).getIdentifier().equals(JavaMode.class.getCanonicalName())) {
            return (Mode)possibleModes.get(0);
        }
        if (possibleModes.size() == 0) {
            if (preferredMode == null) {
                Base.showWarning("Modeless Dialog", "I don't know how to open a sketch with the \"" + extension + "\"\nfile extension. You'll have to install a different" + "\nProcessing mode for that.");
            } else {
                Base.showWarning("Modeless Dialog", "You'll have to install " + preferredMode.title + " Mode " + "\nin order to open that sketch.");
            }
            return null;
        }
        Object[] modes = possibleModes.toArray(new Mode[possibleModes.size()]);
        String message = preferredMode == null ? String.valueOf(this.nextMode.getTitle()) + " Mode can't open ." + extension + " files, " + "but you have one or more modes\ninstalled that can. " + "Would you like to try one?" : "That's a " + preferredMode.title + " Mode sketch, " + "but you don't have " + preferredMode.title + " installed.\n" + "Would you like to try a different mode for opening a " + "." + extension + " sketch?";
        return (Mode)JOptionPane.showInputDialog(null, message, "Choose Wisely", 3, null, modes, modes[0]);
    }

    private Mode selectMode(File sketch) {
        Mode specifiedMode;
        ModeInfo modeInfo = Base.modeInfoFor(sketch);
        Mode mode = specifiedMode = modeInfo == null ? null : this.findMode(modeInfo.id);
        if (specifiedMode != null) {
            return specifiedMode;
        }
        return this.promptForMode(sketch, modeInfo);
    }

    protected Mode findMode(String id) {
        for (Mode mode : this.getModeList()) {
            if (!mode.getIdentifier().equals(id)) continue;
            return mode;
        }
        return null;
    }

    public boolean handleClose(Editor editor, boolean modeSwitch) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            Object[] options;
            String prompt;
            int result;
            if (Base.isMacOS() && defaultFileMenu == null && ((result = JOptionPane.showOptionDialog(editor, prompt = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Processing.", "Quit", 0, 3, null, options = new Object[]{"OK", "Cancel"}, options[0])) == 1 || result == -1)) {
                return false;
            }
            Preferences.unset("server.port");
            Preferences.unset("server.key");
            this.editors.remove(editor);
            Preferences.save();
            if (defaultFileMenu == null) {
                if (modeSwitch) {
                    editor.setVisible(false);
                    editor.dispose();
                    this.activeEditor = null;
                    this.editors.remove(editor);
                } else {
                    System.exit(0);
                }
            } else {
                editor.setVisible(false);
                editor.dispose();
                defaultFileMenu.insert(this.sketchbookMenu, 2);
                defaultFileMenu.insert(this.getRecentMenu(), 3);
                this.activeEditor = null;
                this.editors.remove(editor);
            }
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            if (!Base.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        for (Editor editor : this.editors) {
            if (editor.checkModified()) continue;
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenusAsync() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.this.rebuildSketchbookMenus();
            }
        });
    }

    public void thinkDifferentExamples() {
        this.nextMode.showExamplesFrame();
    }

    protected void rebuildSketchbookMenus() {
        this.rebuildSketchbookMenu();
        for (Mode mode : this.getModeList()) {
            mode.rebuildImportMenu();
            mode.rebuildToolbarMenu();
            mode.resetExamples();
        }
    }

    protected void rebuildSketchbookMenu() {
        this.sketchbookMenu.removeAll();
        this.populateSketchbookMenu(this.sketchbookMenu);
    }

    public void populateSketchbookMenu(JMenu menu) {
        boolean found = false;
        try {
            found = this.addSketches(menu, sketchbookFolder, false);
        }
        catch (IOException e) {
            Base.showWarning("Sketchbook Menu Error", "An error occurred while trying to list the sketchbook.", e);
        }
        if (!found) {
            JMenuItem empty = new JMenuItem("Empty Sketchbook");
            empty.setEnabled(false);
            menu.add(empty);
        }
    }

    public JMenu getSketchbookMenu() {
        if (this.sketchbookMenu == null) {
            this.sketchbookMenu = new JMenu("Sketchbook");
            this.rebuildSketchbookMenu();
        }
        return this.sketchbookMenu;
    }

    public JMenu getRecentMenu() {
        return this.recent.getMenu();
    }

    public JMenu getToolbarRecentMenu() {
        return this.recent.getToolbarMenu();
    }

    public void handleRecent(Editor editor) {
        this.recent.handle(editor);
    }

    public void removeRecent(Editor editor) {
        this.recent.remove(editor);
    }

    protected boolean addSketches(JMenu menu, File folder, final boolean replaceExisting) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                if (new File(path).exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        replace = !replace;
                    }
                    Base.this.handleOpen(path);
                } else {
                    Base.showWarning("Sketch Disappeared", "The selected sketch no longer exists.\nYou may need to restart Processing to update\nthe sketchbook menu.", null);
                }
            }
        };
        boolean found = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(listener);
                    item.setActionCommand(entry.getAbsolutePath());
                    menu.add(item);
                    found = true;
                } else {
                    JMenu submenu = new JMenu(name);
                    boolean anything = this.addSketches(submenu, subfolder, replaceExisting);
                    if (anything) {
                        menu.add(submenu);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    protected boolean addSketches(DefaultMutableTreeNode node, File folder) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        boolean found = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    DefaultMutableTreeNode item = new DefaultMutableTreeNode(new SketchReference(name, entry));
                    node.add(item);
                    found = true;
                } else {
                    DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(name);
                    boolean anything = this.addSketches(subnode, subfolder);
                    if (anything) {
                        node.add(subnode);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    File checkSketchFolder(File subfolder, String item) {
        for (Mode mode : this.getModeList()) {
            File entry = new File(subfolder, String.valueOf(item) + "." + mode.getDefaultExtension());
            if (!entry.exists()) continue;
            return entry;
        }
        return null;
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences(this);
        }
        this.preferencesFrame.showFrame();
    }

    public void handleOpenLibraryManager() {
        this.libraryManagerFrame.showFrame(this.activeEditor);
    }

    public void handleOpenToolManager() {
        this.toolManagerFrame.showFrame(this.activeEditor);
    }

    public void handleOpenModeManager() {
        this.modeManagerFrame.showFrame(this.activeEditor);
    }

    public void handleShowUpdates() {
        this.updateManagerFrame.showFrame(this.activeEditor);
    }

    public static int getRevision() {
        return 227;
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static String getPlatformName() {
        return PConstants.platformNames[PApplet.platform];
    }

    public static int getNativeBits() {
        return nativeBits;
    }

    public static String getPlatformName(int which) {
        return platformNames.get(which);
    }

    public static int getPlatformIndex(String what) {
        Integer entry = platformIndices.get(what);
        return entry == null ? -1 : entry;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isUsableOracleJava() {
        if (usableOracleJava == null) {
            String version;
            String[] m;
            usableOracleJava = false;
            if (Base.isMacOS() && System.getProperty("java.vendor").contains("Oracle") && (m = PApplet.match((String)(version = System.getProperty("java.version")), (String)"1.(\\d).*_(\\d+)")) != null && PApplet.parseInt((String)m[1]) >= 7 && PApplet.parseInt((String)m[2]) >= 40) {
                usableOracleJava = true;
            }
        }
        return usableOracleJava;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getSettingsFolder() {
        File settingsFolder = null;
        String preferencesPath = Preferences.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = new File(preferencesPath);
        } else {
            try {
                settingsFolder = platform.getSettingsFolder();
            }
            catch (Exception e) {
                Base.showError("Problem getting data folder", "Error getting the Processing data folder.", e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            Base.showError("Settings issues", "Processing cannot run because it could not\ncreate a folder to store your settings.", null);
        }
        return settingsFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File createTempFolder(String prefix, String suffix, File directory) throws IOException {
        int fillChars = 3 - prefix.length();
        int i = 0;
        while (i < fillChars) {
            prefix = String.valueOf(prefix) + '_';
            ++i;
        }
        File folder = File.createTempFile(prefix, suffix, directory);
        folder.delete();
        folder.mkdirs();
        return folder;
    }

    public static File getToolsFolder() {
        return Base.getContentFile("tools");
    }

    public static void locateSketchbookFolder() {
        String sketchbookPath = Preferences.get("sketchbook.path");
        if (sketchbookPath != null && !(sketchbookFolder = new File(sketchbookPath)).exists()) {
            Base.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nProcessing will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Processing will then stop talking\nabout himself in the third person.", null);
            sketchbookFolder = null;
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.getDefaultSketchbookFolder();
            Preferences.set("sketchbook.path", sketchbookFolder.getAbsolutePath());
            if (!sketchbookFolder.exists()) {
                sketchbookFolder.mkdirs();
            }
        }
        Base.getSketchbookLibrariesFolder().mkdir();
        Base.getSketchbookToolsFolder().mkdir();
        Base.getSketchbookModesFolder().mkdir();
    }

    public void setSketchbookFolder(File folder) {
        sketchbookFolder = folder;
        Preferences.set("sketchbook.path", folder.getAbsolutePath());
        this.rebuildSketchbookMenus();
    }

    public static File getSketchbookFolder() {
        return sketchbookFolder;
    }

    public static File getSketchbookLibrariesFolder() {
        return new File(sketchbookFolder, "libraries");
    }

    public static File getSketchbookToolsFolder() {
        return new File(sketchbookFolder, "tools");
    }

    public static File getSketchbookModesFolder() {
        return new File(sketchbookFolder, "modes");
    }

    protected static File getDefaultSketchbookFolder() {
        File sketchbookFolder = null;
        try {
            sketchbookFolder = platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {}
        if (sketchbookFolder == null) {
            Base.showError("No sketchbook", "Problem while trying to get the sketchbook", null);
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError("You forgot your sketchbook", "Processing cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return sketchbookFolder;
    }

    public static void openURL(String url) {
        try {
            platform.openURL(url);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    protected static boolean openFolderAvailable() {
        return platform.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            platform.openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static void showMessage(String title, String message) {
        if (title == null) {
            title = "Message";
        }
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }
    }

    public static void showWarning(String title, String message) {
        Base.showWarning(title, message, null);
    }

    public static void showWarning(String title, String message, Throwable e) {
        if (title == null) {
            title = "Warning";
        }
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showWarningTiered(String title, String primary, String secondary, Throwable e) {
        if (title == null) {
            title = "Warning";
        }
        String message = String.valueOf(primary) + "\n" + secondary;
        if (commandLine) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else if (!Base.isMacOS()) {
            JOptionPane.showMessageDialog(new JFrame(), "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 2);
        } else {
            JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 2);
            JDialog dialog = pane.createDialog(new JFrame(), null);
            dialog.setVisible(true);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showError(String title, String message, Throwable e) {
        if (title == null) {
            title = "Error";
        }
        if (commandLine) {
            System.err.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static void showBadnessTrace(String title, String message, Throwable t, boolean fatal) {
        if (title == null) {
            String string = title = fatal ? "Error" : "Warning";
        }
        if (commandLine) {
            System.err.println(String.valueOf(title) + ": " + message);
            if (t != null) {
                t.printStackTrace();
            }
        } else {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            message = "<html>" + message + "<br/><font size=2><br/>" + sw.toString().replaceAll("\n", "<br/>");
            JOptionPane.showMessageDialog(new Frame(), message, title, fatal ? 0 : 2);
        }
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, String.valueOf(primary) + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 0, 3);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 3);
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String name) {
        if (processingRoot == null) {
            String path = Base.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = PApplet.urlDecode((String)path);
            if (decodedPath.contains("/app/bin")) {
                if (Base.isMacOS()) {
                    processingRoot = new File(path, "../../build/macosx/work/Processing.app/Contents/Java");
                } else if (Base.isWindows()) {
                    processingRoot = new File(path, "../../build/windows/work");
                } else if (Base.isLinux()) {
                    processingRoot = new File(path, "../../build/linux/work");
                }
            } else {
                File jarFolder = new File(decodedPath).getParentFile();
                if (jarFolder.getName().equals("lib")) {
                    processingRoot = jarFolder.getParentFile();
                } else if (Base.isMacOS()) {
                    processingRoot = jarFolder;
                }
                if (processingRoot == null || !processingRoot.exists()) {
                    System.err.println("Could not find lib folder via " + jarFolder.getAbsolutePath() + ", switching to user.dir");
                    processingRoot = new File(System.getProperty("user.dir"));
                }
            }
        }
        return new File(processingRoot, name);
    }

    public static File getJavaHome() {
        if (Base.isMacOS()) {
            File[] plugins = Base.getContentFile("../PlugIns").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.endsWith(".jdk") && !name.startsWith(".");
                }
            });
            return new File(plugins[0], "Contents/Home/jre");
        }
        return Base.getContentFile("java");
    }

    public static String getJavaPath() {
        String javaPath = "bin/java" + (Base.isWindows() ? ".exe" : "");
        File javaFile = new File(Base.getJavaHome(), javaPath);
        try {
            return javaFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            return javaFile.getAbsolutePath();
        }
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(new File(Base.getContentFile("lib"), filename));
    }

    public static int countLines(String what) {
        int count = 1;
        char[] cArray = what.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead == 0) break;
        }
        input.close();
        input = null;
        return buffer;
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (inputFile.exists()) {
            String[] lines = PApplet.loadStrings((File)inputFile);
            Base.readSettings(inputFile.toString(), lines, outgoing);
        }
        return outgoing;
    }

    public static void readSettings(String filename, String[] lines, HashMap<String, String> settings) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int commentMarker = line.indexOf(35);
            if (commentMarker != -1) {
                line = line.substring(0, commentMarker);
            }
            if ((line = line.trim()).length() != 0) {
                int equals = line.indexOf(61);
                if (equals == -1) {
                    if (filename != null) {
                        System.err.println("Ignoring illegal line in " + filename);
                        System.err.println("  " + line);
                    }
                } else {
                    String attr = line.substring(0, equals).trim();
                    String valu = line.substring(equals + 1).trim();
                    settings.put(attr, valu);
                }
            }
            ++n2;
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
        from.close();
        from = null;
        to.flush();
        to.close();
        to = null;
        targetFile.setLastModified(sourceFile.lastModified());
        targetFile.setExecutable(sourceFile.canExecute());
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings((File)file);
        if (contents == null) {
            return null;
        }
        return PApplet.join((String[])contents, (String)"\n");
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        try {
            File canon;
            file = canon = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new IOException("Could not resolve canonical representation of " + file.getAbsolutePath());
        }
        PApplet.saveStrings((File)temp, (String[])new String[]{str});
        if (file.exists() && !(result = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException("Could not replace " + file.getAbsolutePath());
        }
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        if (sourceDir.equals(targetDir)) {
            throw new IllegalArgumentException("source and target directories are identical");
        }
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].charAt(0) != '.') {
                File source = new File(sourceDir, files[i]);
                File target = new File(targetDir, files[i]);
                if (source.isDirectory()) {
                    Base.copyDir(source, target);
                    target.setLastModified(source.lastModified());
                } else {
                    Base.copyFile(source, target);
                }
            }
            ++i;
        }
    }

    public static void copyDirNative(File sourceDir, File targetDir) throws IOException {
        Process process = null;
        if (!Base.isMacOS() && !Base.isLinux()) {
            throw new RuntimeException("Not yet implemented on Windows");
        }
        process = Runtime.getRuntime().exec(new String[]{"cp", "-a", sourceDir.getAbsolutePath(), targetDir.getAbsolutePath()});
        try {
            int result = process.waitFor();
            if (result != 0) {
                throw new IOException("Error while copying (result " + result + ")");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean platformDelete(File file) throws IOException {
        return platform.deleteFile(file);
    }

    public static void removeDir(File dir) {
        if (dir.exists()) {
            Base.removeDescendants(dir);
            if (!dir.delete()) {
                System.err.println("Could not delete " + dir);
            }
        }
    }

    public static void removeDescendants(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                File dead = new File(dir, files[i]);
                if (!dead.isDirectory()) {
                    if (!Preferences.getBoolean("compiler.save_build_files") && !dead.delete()) {
                        System.err.println("Could not delete " + dead);
                    }
                } else {
                    Base.removeDir(dead);
                }
            }
            ++i;
        }
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        int i = 0;
        while (i < files.length) {
            if (!(files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store"))) {
                File fella = new File(folder, files[i]);
                size = fella.isDirectory() ? (size += Base.calcFolderSize(fella)) : (size += (int)fella.length());
            }
            ++i;
        }
        return size;
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(relative ? String.valueOf(path) + File.separator : "", path, null, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    public static String[] listFiles(File folder, boolean relative, String extension) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        if (extension != null && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        Base.listFiles(relative ? String.valueOf(path) + File.separator : "", path, extension, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void listFiles(String basePath, String path, String extension, Vector<String> vector) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.charAt(0) != '.' && (extension == null || item.toLowerCase().endsWith(extension))) {
                    File file = new File(path, item);
                    String newPath = file.getAbsolutePath();
                    if (newPath.startsWith(basePath)) {
                        newPath = newPath.substring(basePath.length());
                    }
                    if (extension == null || item.toLowerCase().endsWith(extension)) {
                        vector.add(newPath);
                    }
                    if (file.isDirectory()) {
                        Base.listFiles(basePath, file.getAbsolutePath(), extension, vector);
                    }
                }
                ++n2;
            }
        }
    }

    public static File[] listJarFiles(File folder) {
        return folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && (name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip"));
            }
        });
    }

    public static String contentsToClassPath(File folder) {
        if (folder == null) {
            return "";
        }
        StringBuffer abuffer = new StringBuffer();
        String sep = System.getProperty("path.separator");
        try {
            String path = folder.getCanonicalPath();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            String[] list = folder.list();
            int i = 0;
            while (i < list.length) {
                if (!list[i].startsWith(".") && (list[i].toLowerCase().endsWith(".jar") || list[i].toLowerCase().endsWith(".zip"))) {
                    abuffer.append(sep);
                    abuffer.append(path);
                    abuffer.append(list[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return abuffer.toString();
    }

    public static String[] packageListFromClassPath(String path) {
        Hashtable table = new Hashtable();
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].length() != 0) {
                if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                    Base.packageListFromZip(pieces[i], table);
                } else {
                    File dir = new File(pieces[i]);
                    if (dir.exists() && dir.isDirectory()) {
                        Base.packageListFromFolder(dir, null, table);
                    }
                }
            }
            ++i;
        }
        int tableCount = table.size();
        String[] output = new String[tableCount];
        int index = 0;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            output[index++] = ((String)e.nextElement()).replace('/', '.');
        }
        return output;
    }

    private static void packageListFromZip(String filename, Hashtable table) {
        try {
            ZipFile file = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                String pname;
                int slash;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class") || (slash = name.lastIndexOf(47)) == -1 || table.get(pname = name.substring(0, slash)) != null) continue;
                table.put(pname, new Object());
            }
            file.close();
        }
        catch (IOException e) {
            System.err.println("Ignoring " + filename + " (" + e.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File dir, String sofar, Hashtable table) {
        boolean foundClass = false;
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                File sub = new File(dir, files[i]);
                if (sub.isDirectory()) {
                    String nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "." + files[i];
                    Base.packageListFromFolder(sub, nowfar, table);
                } else if (!foundClass && files[i].endsWith(".class")) {
                    table.put(sofar, new Object());
                    foundClass = true;
                }
            }
            ++i;
        }
    }

    public static void unzip(File zipFile, File dest) {
        try {
            FileInputStream fis = new FileInputStream(zipFile);
            CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
            ZipEntry next = null;
            while ((next = zis.getNextEntry()) != null) {
                File currentFile = new File(dest, next.getName());
                if (next.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                File parentDir = currentFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                currentFile.createNewFile();
                Base.unzipEntry(zis, currentFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void unzipEntry(ZipInputStream zin, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.flush();
        out.close();
    }

    public static void log(Object from, String message) {
        if (DEBUG) {
            System.out.println(String.valueOf(from.getClass().getName()) + ": " + message);
        }
    }

    public static void log(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static void logf(String message, Object ... args) {
        if (DEBUG) {
            System.out.println(String.format(message, args));
        }
    }

    public static void log(String message, Throwable e) {
        if (DEBUG) {
            System.out.println(message);
            e.printStackTrace();
        }
    }

    private static class ModeInfo {
        public final String title;
        public final String id;

        public ModeInfo(String id, String title) {
            this.id = id;
            this.title = title;
        }
    }
}

