/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import processing.app.Editor;
import processing.app.Preferences;
import processing.core.PApplet;

public class EditorState {
    Rectangle editorBounds;
    int dividerLocation;
    Rectangle deviceBounds;
    boolean isMaximized;

    EditorState(List<Editor> editors) {
        this.defaultConfig();
        this.defaultLocation(editors);
    }

    EditorState(String info) throws IOException {
        String[] pieces = PApplet.split((String)info, (char)',');
        this.editorBounds = new Rectangle(Integer.parseInt(pieces[0]), Integer.parseInt(pieces[1]), Integer.parseInt(pieces[2]), Integer.parseInt(pieces[3]));
        this.dividerLocation = Integer.parseInt(pieces[4]);
        this.deviceBounds = new Rectangle(Integer.parseInt(pieces[5]), Integer.parseInt(pieces[6]), Integer.parseInt(pieces[7]), Integer.parseInt(pieces[8]));
    }

    public String toString() {
        return String.valueOf(this.editorBounds.x) + "," + this.editorBounds.y + "," + this.editorBounds.width + "," + this.editorBounds.height + "," + this.dividerLocation + "," + this.deviceBounds.x + "," + this.deviceBounds.y + "," + this.deviceBounds.width + "," + this.deviceBounds.height;
    }

    GraphicsConfiguration checkConfig() {
        if (this.deviceBounds != null) {
            GraphicsDevice[] screenDevices;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = screenDevices = graphicsEnvironment.getScreenDevices();
            int n = screenDevices.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsConfiguration[] configurations;
                GraphicsDevice device = graphicsDeviceArray[n2];
                GraphicsConfiguration[] graphicsConfigurationArray = configurations = device.getConfigurations();
                int n3 = configurations.length;
                int n4 = 0;
                while (n4 < n3) {
                    GraphicsConfiguration config = graphicsConfigurationArray[n4];
                    if (config.getBounds().equals(this.deviceBounds)) {
                        return config;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.defaultConfig();
    }

    GraphicsConfiguration defaultConfig() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        this.deviceBounds = config.getBounds();
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defaultLocation(List<Editor> editors) {
        int defaultWidth = Preferences.getInteger("editor.window.width.default");
        int defaultHeight = Preferences.getInteger("editor.window.height.default");
        if (editors.size() == 0) {
            int editorX = this.deviceBounds.x + (this.deviceBounds.width - defaultWidth) / 2;
            int editorY = this.deviceBounds.y + (this.deviceBounds.height - defaultHeight) / 2;
            this.editorBounds = new Rectangle(editorX, editorY, defaultWidth, defaultHeight);
            this.dividerLocation = 0;
        } else {
            List<Editor> list = editors;
            synchronized (list) {
                Editor lastOpened = editors.get(editors.size() - 1);
                this.isMaximized = lastOpened.getExtendedState() == 6;
                this.editorBounds = lastOpened.getBounds();
                this.editorBounds.x += 50;
                this.editorBounds.y += 50;
                this.dividerLocation = lastOpened.getDividerLocation();
                if (!this.deviceBounds.contains(this.editorBounds)) {
                    this.editorBounds.x = this.deviceBounds.x + (int)(Math.random() * (double)(this.deviceBounds.width - defaultWidth));
                    this.editorBounds.y = this.deviceBounds.y + (int)(Math.random() * (double)(this.deviceBounds.height - defaultHeight));
                }
                if (this.isMaximized) {
                    this.editorBounds.width = defaultWidth;
                    this.editorBounds.height = defaultHeight;
                }
            }
        }
    }

    void update(Editor editor) {
        this.editorBounds = editor.getBounds();
        this.dividerLocation = editor.getDividerLocation();
        GraphicsConfiguration config = editor.getGraphicsConfiguration();
        this.deviceBounds = config.getBounds();
    }

    void apply(Editor editor) {
        editor.setBounds(this.editorBounds);
        if (this.dividerLocation != 0) {
            editor.setDividerLocation(this.dividerLocation);
        }
        if (this.isMaximized) {
            editor.setExtendedState(6);
        }
    }
}

