/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Toolkit;

public class EditorStatus
extends JPanel {
    Color[] bgcolor;
    Color[] fgcolor;
    public static final int NOTICE = 0;
    public static final int ERR = 1;
    public static final int EDIT = 2;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    static final String NO_MESSAGE = "";
    Editor editor;
    int mode;
    String message;
    Font font;
    FontMetrics metrics;
    int ascent;
    Image offscreen;
    int sizeW;
    int sizeH;
    JButton cancelButton;
    JButton okButton;
    JTextField editField;
    int response;
    boolean indeterminate;
    Thread thread;

    public EditorStatus(Editor editor) {
        this.editor = editor;
        this.empty();
        this.updateMode();
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.bgcolor = new Color[]{mode.getColor("status.notice.bgcolor"), mode.getColor("status.error.bgcolor"), mode.getColor("status.edit.bgcolor")};
        this.fgcolor = new Color[]{mode.getColor("status.notice.fgcolor"), mode.getColor("status.error.fgcolor"), mode.getColor("status.edit.fgcolor")};
        this.font = mode.getFont("status.font");
        this.metrics = null;
    }

    public void empty() {
        this.mode = 0;
        this.message = NO_MESSAGE;
        this.repaint();
    }

    public void notice(String message) {
        this.mode = 0;
        this.message = message;
        this.repaint();
    }

    public void unnotice(String unmessage) {
        if (this.message.equals(unmessage)) {
            this.empty();
        }
    }

    public void error(String message) {
        this.mode = 1;
        this.message = message;
        this.repaint();
    }

    public void edit(String message, String dflt) {
        this.mode = 2;
        this.message = message;
        this.response = 0;
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.editField.setVisible(true);
        this.editField.setText(dflt);
        this.editField.selectAll();
        this.editField.requestFocusInWindow();
        this.repaint();
    }

    public void unedit() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.editField.setVisible(false);
        this.editor.textarea.requestFocusInWindow();
        this.empty();
    }

    public void startIndeterminate() {
        this.indeterminate = true;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (Thread.currentThread() == EditorStatus.this.thread) {
                    EditorStatus.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.start();
    }

    public void stopIndeterminate() {
        this.indeterminate = false;
        this.thread = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (this.okButton == null) {
            this.setup();
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            this.offscreen = null;
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.setButtonBounds();
            this.offscreen = Toolkit.highResDisplay() ? this.createImage(this.sizeW * 2, this.sizeH * 2) : this.createImage(this.sizeW, this.sizeH);
        }
        Graphics g = this.offscreen.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        if (Toolkit.highResDisplay()) {
            g2.scale(2.0, 2.0);
            if (Base.isUsableOracleJava()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.setColor(this.bgcolor[this.mode]);
        g.fillRect(0, 0, this.sizeW, this.sizeH);
        g.setColor(this.fgcolor[this.mode]);
        g.setFont(this.font);
        g.drawString(this.message, 6, (this.sizeH + this.ascent) / 2);
        if (this.indeterminate) {
            int x = this.cancelButton.getX();
            int w = this.cancelButton.getWidth();
            int y = this.getHeight() / 3;
            int h = this.getHeight() / 3;
            g.setColor(new Color(Integer.MIN_VALUE, true));
            g.drawRect(x, y, w, h);
            int i = 0;
            while (i < 10) {
                int r = (int)((double)x + Math.random() * (double)w);
                g.drawLine(r, y, r, y + h);
                ++i;
            }
        }
        screen.drawImage(this.offscreen, 0, 0, this.sizeW, this.sizeH, null);
    }

    protected void setup() {
        if (this.okButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.okButton = new JButton("OK");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditorStatus.this.mode == 2) {
                        EditorStatus.this.unedit();
                    }
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditorStatus.this.mode == 2) {
                        String answer = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(answer);
                        EditorStatus.this.unedit();
                    }
                }
            });
            if (Base.isMacOS()) {
                this.cancelButton.setBackground(this.bgcolor[2]);
                this.okButton.setBackground(this.bgcolor[2]);
            }
            this.setLayout(null);
            this.add(this.cancelButton);
            this.add(this.okButton);
            this.cancelButton.setVisible(false);
            this.okButton.setVisible(false);
            this.editField = new JTextField();
            this.editField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (event.getKeyChar() == '\u001b') {
                        EditorStatus.this.unedit();
                        event.consume();
                    }
                }

                @Override
                public void keyTyped(KeyEvent event) {
                    char c = event.getKeyChar();
                    if (c == '\n') {
                        String answer = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(answer);
                        EditorStatus.this.unedit();
                        event.consume();
                    } else if (c != '\b' && c != '\u007f' && c != '\'' && c != '%' && c != '&' && c != '(' && c != '$' && c != '#' && c != '\u0010') {
                        if (c == ' ') {
                            String t = EditorStatus.this.editField.getText();
                            int start = EditorStatus.this.editField.getSelectionStart();
                            int end2 = EditorStatus.this.editField.getSelectionEnd();
                            EditorStatus.this.editField.setText(String.valueOf(t.substring(0, start)) + "_" + t.substring(end2));
                            EditorStatus.this.editField.setCaretPosition(start + 1);
                            event.consume();
                        } else if (!(c == '_' || c == '.' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                            if (c >= '0' && c <= '9') {
                                if (EditorStatus.this.editField.getCaretPosition() == 0 || EditorStatus.this.editField.getSelectionStart() == 0) {
                                    event.consume();
                                }
                            } else {
                                event.consume();
                            }
                        }
                    }
                }
            });
            this.add(this.editField);
            this.editField.setVisible(false);
        }
    }

    protected void setButtonBounds() {
        int top = (this.sizeH - Preferences.BUTTON_HEIGHT) / 2;
        int eachButton = 6 + Preferences.BUTTON_WIDTH;
        int cancelLeft = this.sizeW - eachButton;
        int noLeft = cancelLeft - eachButton;
        int yesLeft = noLeft - eachButton;
        this.cancelButton.setLocation(cancelLeft, top);
        this.okButton.setLocation(noLeft, top);
        this.cancelButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.okButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        int editWidth = 2 * Preferences.BUTTON_WIDTH;
        int editHeight = this.editField.getPreferredSize().height;
        int editTop = (1 + this.sizeH - editHeight) / 2;
        this.editField.setBounds(yesLeft - Preferences.BUTTON_WIDTH, editTop, editWidth, editHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 32);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            if (this.mode == 2) {
                this.unedit();
            }
        } else if (e.getSource() == this.okButton && this.mode == 2) {
            String answer = this.editField.getText();
            this.editor.getSketch().nameCode(answer);
            this.unedit();
        }
    }
}

