/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.FileUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.UIManager;
import processing.app.Base;
import processing.app.Preferences;

public class Platform {
    Base base;

    public void setLookAndFeel() throws Exception {
        String laf = Preferences.get("editor.laf");
        if (laf == null || laf.length() == 0) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } else {
            UIManager.setLookAndFeel(laf);
        }
    }

    public void init(Base base) {
        this.base = base;
    }

    public File getSettingsFolder() throws Exception {
        File home2 = new File(System.getProperty("user.home"));
        return new File(home2, ".processing");
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return new File(System.getProperty("user.home"), "sketchbook");
    }

    public void openURL(String url) throws Exception {
        Desktop.getDesktop().browse(new URI(url));
    }

    public boolean openFolderAvailable() {
        return Desktop.isDesktopSupported();
    }

    public void openFolder(File file) throws Exception {
        Desktop.getDesktop().open(file);
    }

    public final boolean deleteFile(File file) throws IOException {
        FileUtils fu = FileUtils.getInstance();
        if (fu.hasTrash()) {
            fu.moveToTrash(new File[]{file});
            return true;
        }
        if (file.isDirectory()) {
            Base.removeDir(file);
            return true;
        }
        return file.delete();
    }

    public void setenv(String variable, String value) {
        CLibrary clib = CLibrary.INSTANCE;
        clib.setenv(variable, value, 1);
    }

    public String getenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.getenv(variable);
    }

    public int unsetenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.unsetenv(variable);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int setenv(String var1, String var2, int var3);

        public String getenv(String var1);

        public int unsetenv(String var1);

        public int putenv(String var1);
    }
}

