/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Toolkit;
import processing.core.PApplet;
import processing.core.PConstants;

public class Preferences {
    static final Integer[] FONT_SIZES = new Integer[]{10, 12, 14, 18, 24, 36, 48};
    static final String PREFS_FILE = "preferences.txt";
    static final String PROMPT_YES = "Yes";
    static final String PROMPT_NO = "No";
    static final String PROMPT_CANCEL = "Cancel";
    static final String PROMPT_OK = "OK";
    static final String PROMPT_BROWSE = "Browse";
    public static int BUTTON_WIDTH = 80;
    public static int BUTTON_HEIGHT = 24;
    static final int GRID_SIZE = 32;
    static final int GUI_BIG = 13;
    static final int GUI_BETWEEN = 10;
    static final int GUI_SMALL = 6;
    JFrame dialog;
    int wide;
    int high;
    JTextField sketchbookLocationField;
    JCheckBox editorAntialiasBox;
    JCheckBox deletePreviousBox;
    JCheckBox whinyBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JComboBox fontSizeField;
    JComboBox consoleSizeField;
    JCheckBox inputMethodBox;
    JCheckBox autoAssociateBox;
    JComboBox displaySelectionBox;
    int displayCount;
    String[] monoFontFamilies;
    JComboBox fontSelectionBox;
    Base base;
    static HashMap<String, String> defaults;
    static HashMap<String, String> table;
    static File preferencesFile;

    static {
        table = new HashMap();
    }

    public static void init() {
        try {
            Preferences.load(Base.getLibStream("defaults.txt"));
        }
        catch (Exception e) {
            Base.showError(null, "Could not read default settings.\nYou'll need to reinstall Processing.", e);
        }
        String platformExt = "." + PConstants.platformNames[PApplet.platform];
        int platformExtLength = platformExt.length();
        ArrayList<String> platformKeys = new ArrayList<String>();
        for (String key : table.keySet()) {
            if (!key.endsWith(platformExt)) continue;
            platformKeys.add(key);
        }
        for (String key : platformKeys) {
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = Preferences.get(key);
            Preferences.set(actualKey, value);
        }
        defaults = (HashMap)table.clone();
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
        preferencesFile = Base.getSettingsFile(PREFS_FILE);
        if (!preferencesFile.exists()) {
            Preferences.save();
        } else {
            try {
                Preferences.load(new FileInputStream(preferencesFile));
            }
            catch (Exception ex) {
                Base.showError("Error reading preferences", "Error reading the preferences file. Please delete (or move)\n" + preferencesFile.getAbsolutePath() + " and restart Processing.", ex);
            }
        }
        PApplet.useNativeSelect = Preferences.getBoolean("chooser.files.native");
        String proxyHost = Preferences.get("proxy.host");
        String proxyPort = Preferences.get("proxy.port");
        if (proxyHost != null && proxyHost.trim().length() != 0 && proxyPort != null && proxyPort.trim().length() != 0) {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
    }

    public Preferences(Base base) {
        this.base = base;
        this.dialog = new JFrame("Preferences");
        this.dialog.setResizable(false);
        Container pain = this.dialog.getContentPane();
        pain.setLayout(null);
        int top = 13;
        int left = 13;
        int right = 0;
        JLabel label = new JLabel("Sketchbook location:");
        pain.add(label);
        Dimension d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        top += d.height;
        this.sketchbookLocationField = new JTextField(40);
        pain.add(this.sketchbookLocationField);
        d = this.sketchbookLocationField.getPreferredSize();
        JButton button = new JButton(PROMPT_BROWSE);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dflt = new File(Preferences.this.sketchbookLocationField.getText());
                PApplet.selectFolder((String)"Select new sketchbook location", (String)"sketchbookCallback", (File)dflt, (Object)Preferences.this, (Frame)Preferences.this.dialog);
            }
        });
        pain.add(button);
        Dimension d2 = button.getPreferredSize();
        int vmax = Math.max(d.height, d2.height);
        this.sketchbookLocationField.setBounds(left, top + (vmax - d.height) / 2, d.width, d.height);
        int h = left + d.width + 6;
        button.setBounds(h, top + (vmax - d2.height) / 2, d2.width, d2.height);
        right = Math.max(right, h + d2.width + 13);
        top += vmax + 10;
        Box fontBox = Box.createHorizontalBox();
        JLabel fontLabel = new JLabel("Editor and Console font ");
        fontLabel.setToolTipText("<html>Select the font used in the Editor and the Console.<br/>Only monospaced (fixed-width) fonts may be used, <br/>though the list may be imperfect.");
        fontBox.add(fontLabel);
        this.fontSelectionBox = new JComboBox<Object>(new Object[]{Toolkit.getMonoFontName()});
        this.fontSelectionBox.setToolTipText("<html>Select the font used in the Editor and the Console.<br/>Only monospaced (fixed-width) fonts may be used, <br/>though the list may be imperfect.");
        this.fontSelectionBox.setEnabled(false);
        fontBox.add(this.fontSelectionBox);
        pain.add(fontBox);
        d = ((Container)fontBox).getPreferredSize();
        fontBox.setBounds(left, top, d.width + 150, d.height);
        top += d.height + 10;
        Box box = Box.createHorizontalBox();
        label = new JLabel("Editor font size: ");
        box.add(label);
        this.fontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.fontSizeField.setEditable(true);
        box.add(this.fontSizeField);
        box.add(Box.createHorizontalStrut(10));
        label = new JLabel("Console font size: ");
        box.add(label);
        this.consoleSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.consoleSizeField.setEditable(true);
        box.add(this.consoleSizeField);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        box.setBounds(left, top, d.width, d.height);
        this.fontSizeField.setSelectedItem(Preferences.getFont("editor.font.size"));
        this.editorAntialiasBox = new JCheckBox("Use smooth text in editor window");
        pain.add(this.editorAntialiasBox);
        d = this.editorAntialiasBox.getPreferredSize();
        this.editorAntialiasBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.inputMethodBox = new JCheckBox("Enable complex text input (i.e. Japanese, requires restart of Processing)");
        pain.add(this.inputMethodBox);
        d = this.inputMethodBox.getPreferredSize();
        this.inputMethodBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        Box memoryBox = Box.createHorizontalBox();
        this.memoryOverrideBox = new JCheckBox("Increase maximum available memory to ");
        memoryBox.add(this.memoryOverrideBox);
        this.memoryField = new JTextField(4);
        memoryBox.add(this.memoryField);
        memoryBox.add(new JLabel(" MB"));
        pain.add(memoryBox);
        d = ((Container)memoryBox).getPreferredSize();
        memoryBox.setBounds(left, top, d.width, d.height);
        this.deletePreviousBox = new JCheckBox("Delete previous application folder on export");
        pain.add(this.deletePreviousBox);
        d = this.deletePreviousBox.getPreferredSize();
        this.deletePreviousBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.whinyBox = new JCheckBox("Hide tab/toolbar background image (requires restart)");
        pain.add(this.whinyBox);
        d = this.whinyBox.getPreferredSize();
        this.whinyBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.checkUpdatesBox = new JCheckBox("Check for updates on startup");
        pain.add(this.checkUpdatesBox);
        d = this.checkUpdatesBox.getPreferredSize();
        this.checkUpdatesBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        Box displayBox = Box.createHorizontalBox();
        JLabel displayLabel = new JLabel("Run sketches on display ");
        displayLabel.setToolTipText("<html>Sets the display where sketches are initially placed.<br>As usual, if the sketch window is moved, it will re-open<br>at the same location, however when running in present<br>(full screen) mode, this display will always be used.");
        displayBox.add(displayLabel);
        this.displaySelectionBox = new JComboBox();
        this.updateDisplayList();
        displayBox.add(this.displaySelectionBox);
        pain.add(displayBox);
        d = ((Container)displayBox).getPreferredSize();
        displayBox.setBounds(left, top, d.width, d.height);
        top += d.height + 10;
        if (Base.isWindows()) {
            this.autoAssociateBox = new JCheckBox("Automatically associate .pde files with Processing");
            pain.add(this.autoAssociateBox);
            d = this.autoAssociateBox.getPreferredSize();
            this.autoAssociateBox.setBounds(left, top, d.width + 10, d.height);
            right = Math.max(right, left + d.width);
            top += d.height + 10;
        }
        label = new JLabel("More preferences can be edited directly in the file");
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        final JLabel clickable = label = new JLabel(preferencesFile.getAbsolutePath());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Base.openFolder(Base.getSettingsFolder());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                clickable.setForeground(new Color(0, 0, 140));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                clickable.setForeground(Color.BLACK);
            }
        });
        pain.add(label);
        d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        label = new JLabel("(edit only when Processing is not running)");
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        button = new JButton(PROMPT_OK);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.applyFrame();
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        d2 = button.getPreferredSize();
        BUTTON_HEIGHT = d2.height;
        h = right - (BUTTON_WIDTH + 6 + BUTTON_WIDTH);
        button.setBounds(h, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        button = new JButton(PROMPT_CANCEL);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        button.setBounds(h += BUTTON_WIDTH + 6, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        this.wide = right + 13;
        this.high = (top += BUTTON_HEIGHT + 10) + 6;
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        ActionListener disposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        };
        Toolkit.registerWindowCloseKeys(this.dialog.getRootPane(), disposer);
        Toolkit.setIcon(this.dialog);
        Dimension screen = Toolkit.getScreenSize();
        this.dialog.setLocation((screen.width - this.wide) / 2, (screen.height - this.high) / 2);
        this.dialog.pack();
        Insets insets = this.dialog.getInsets();
        this.dialog.setSize(this.wide + insets.left + insets.right, this.high + insets.top + insets.bottom);
        pain.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    Preferences.this.disposeFrame();
                }
            }
        });
    }

    public void sketchbookCallback(File file) {
        if (file != null) {
            this.sketchbookLocationField.setText(file.getAbsolutePath());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    protected void disposeFrame() {
        this.dialog.dispose();
    }

    protected void applyFrame() {
        Object selection;
        Preferences.setBoolean("editor.smooth", this.editorAntialiasBox.isSelected());
        Preferences.setBoolean("export.delete_target_folder", this.deletePreviousBox.isSelected());
        boolean wine = this.whinyBox.isSelected();
        Preferences.setBoolean("header.hide.image", wine);
        Preferences.setBoolean("buttons.hide.image", wine);
        String oldPath = Preferences.get("sketchbook.path");
        String newPath = this.sketchbookLocationField.getText();
        if (!newPath.equals(oldPath)) {
            this.base.setSketchbookFolder(new File(newPath));
        }
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        int oldDisplayIndex = Preferences.getInteger("run.display");
        int displayIndex = 0;
        int d = 0;
        while (d < this.displaySelectionBox.getItemCount()) {
            if (this.displaySelectionBox.getSelectedIndex() == d) {
                displayIndex = d;
            }
            ++d;
        }
        if (oldDisplayIndex != displayIndex) {
            Preferences.setInteger("run.display", displayIndex);
            for (Editor editor : this.base.getEditors()) {
                editor.setSketchLocation(null);
            }
        }
        Preferences.setBoolean("run.options.memory", this.memoryOverrideBox.isSelected());
        int memoryMin = Preferences.getInteger("run.options.memory.initial");
        int memoryMax = Preferences.getInteger("run.options.memory.maximum");
        try {
            memoryMax = Integer.parseInt(this.memoryField.getText().trim());
            if (memoryMax < memoryMin) {
                memoryMax = memoryMin;
            }
            Preferences.setInteger("run.options.memory.maximum", memoryMax);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Ignoring bad memory setting");
        }
        if (this.fontSelectionBox.isEnabled()) {
            String fontFamily = (String)this.fontSelectionBox.getSelectedItem();
            Preferences.set("editor.font.family", fontFamily);
        }
        try {
            selection = this.fontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("editor.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException numberFormatException) {
            Base.log("Ignoring invalid font size " + this.fontSizeField);
            this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        }
        try {
            selection = this.consoleSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("console.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException numberFormatException) {
            Base.log("Ignoring invalid font size " + this.consoleSizeField);
            this.consoleSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        }
        Preferences.setBoolean("editor.input_method_support", this.inputMethodBox.isSelected());
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
    }

    protected void showFrame() {
        this.editorAntialiasBox.setSelected(Preferences.getBoolean("editor.smooth"));
        this.inputMethodBox.setSelected(Preferences.getBoolean("editor.input_method_support"));
        this.deletePreviousBox.setSelected(Preferences.getBoolean("export.delete_target_folder"));
        this.sketchbookLocationField.setText(Preferences.get("sketchbook.path"));
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        this.whinyBox.setSelected(Preferences.getBoolean("header.hide.image") || Preferences.getBoolean("buttons.hide.image"));
        this.updateDisplayList();
        int displayNum = Preferences.getInteger("run.display");
        if (displayNum >= 0 && displayNum < this.displayCount) {
            this.displaySelectionBox.setSelectedIndex(displayNum);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Preferences.this.initFontList();
            }
        }).start();
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        this.consoleSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        this.memoryOverrideBox.setSelected(Preferences.getBoolean("run.options.memory"));
        this.memoryField.setText(Preferences.get("run.options.memory.maximum"));
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.dialog.setVisible(true);
    }

    void initFontList() {
        if (this.monoFontFamilies == null) {
            this.monoFontFamilies = Toolkit.getMonoFontFamilies();
            this.fontSelectionBox.setModel(new DefaultComboBoxModel<String>(this.monoFontFamilies));
            String family = Preferences.get("editor.font.family");
            this.fontSelectionBox.setSelectedItem("Monospaced");
            this.fontSelectionBox.setSelectedItem(family);
            this.fontSelectionBox.setEnabled(true);
        }
    }

    void updateDisplayList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.displayCount = ge.getScreenDevices().length;
        String[] items = new String[this.displayCount];
        int i = 0;
        while (i < this.displayCount) {
            items[i] = String.valueOf(i + 1);
            ++i;
        }
        this.displaySelectionBox.setModel(new DefaultComboBoxModel<String>(items));
    }

    public static void load(InputStream input) throws IOException {
        String[] lines;
        String[] stringArray = lines = PApplet.loadStrings((InputStream)input);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            int equals;
            String line = stringArray[n2];
            if (line.length() != 0 && line.charAt(0) != '#' && (equals = line.indexOf(61)) != -1) {
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                table.put(key, value);
            }
            ++n2;
        }
    }

    protected static void save() {
        if (preferencesFile == null) {
            return;
        }
        PrintWriter writer = PApplet.createWriter((File)preferencesFile);
        String[] keyList = table.keySet().toArray(new String[table.size()]);
        String[] stringArray = keyList = PApplet.sort((String[])keyList);
        int n = keyList.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            writer.println(String.valueOf(key) + "=" + table.get(key));
            ++n2;
        }
        writer.flush();
        writer.close();
    }

    public static String get(String attribute) {
        return table.get(attribute);
    }

    public static String getDefault(String attribute) {
        return defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        table.put(attribute, value);
    }

    public static void unset(String attribute) {
        table.remove(attribute);
    }

    public static boolean getBoolean(String attribute) {
        String value = Preferences.get(attribute);
        return new Boolean(value);
    }

    public static void setBoolean(String attribute, boolean value) {
        Preferences.set(attribute, value ? "true" : "false");
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Preferences.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Preferences.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        Color parsed = Color.GRAY;
        String s = Preferences.get(name);
        if (s != null && s.indexOf("#") == 0) {
            try {
                parsed = new Color(Integer.parseInt(s.substring(1), 16));
            }
            catch (Exception exception) {}
        }
        return parsed;
    }

    public static void setColor(String attr, Color what) {
        Preferences.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String attr) {
        try {
            String[] pieces;
            boolean replace = false;
            String value = Preferences.get(attr);
            if (value == null) {
                value = Preferences.getDefault(attr);
                replace = true;
            }
            if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
                value = Preferences.getDefault(attr);
                pieces = PApplet.split((String)value, (char)',');
                replace = true;
            }
            String name = pieces[0];
            int style = 0;
            if (pieces[1].indexOf("bold") != -1) {
                style |= 1;
            }
            if (pieces[1].indexOf("italic") != -1) {
                style |= 2;
            }
            int size = PApplet.parseInt((String)pieces[2], (int)12);
            if (replace) {
                Preferences.set(attr, value);
            }
            if (!name.startsWith("processing.")) {
                return new Font(name, style, size);
            }
            if (pieces[0].equals("processing.sans")) {
                return Toolkit.getSansFont(size, style);
            }
            if (pieces[0].equals("processing.mono")) {
                return Toolkit.getMonoFont(size, style);
            }
        }
        catch (Exception exception) {
            Base.log("Error with font " + Preferences.get(attr) + " for attribute " + attr);
        }
        return new Font("Dialog", 0, 12);
    }

    class FontNamer
    extends JLabel
    implements ListCellRenderer<Font> {
        FontNamer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Font> list, Font value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(String.valueOf(value.getFamily()) + " / " + value.getName() + " (" + value.getPSName() + ")");
            return this;
        }
    }
}

