/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Preferences;

public class Toolkit {
    static final java.awt.Toolkit awtToolkit = java.awt.Toolkit.getDefaultToolkit();
    static final int SHORTCUT_KEY_MASK = awtToolkit.getMenuShortcutKeyMask();
    public static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | awtToolkit.getMenuShortcutKeyMask();
    static ArrayList<Image> iconImages;
    static Boolean highResProp;
    static Font monoFont;
    static Font monoBoldFont;
    static Font sansFont;
    static Font sansBoldFont;

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers |= 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(String title, int what) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static void addDisabledItem(JMenu menu, String title) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(false);
        menu.add(item);
    }

    public static Dimension getScreenSize() {
        return awtToolkit.getScreenSize();
    }

    public static Image getLibImage(String filename) {
        File file = Base.getContentFile("lib/" + filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath()).getImage();
    }

    public static void setIcon(Frame frame) {
        Toolkit.setIcon((Window)frame);
    }

    public static void setIcon(Window window) {
        if (!Base.isMacOS()) {
            if (iconImages == null) {
                int[] sizes;
                iconImages = new ArrayList();
                int[] nArray = sizes = new int[]{16, 32, 48, 64, 128, 256, 512};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int sz = nArray[n2];
                    iconImages.add(Toolkit.getLibImage("icons/pde-" + sz + ".png"));
                    ++n2;
                }
            }
            window.setIconImages(iconImages);
        }
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void beep() {
        awtToolkit.beep();
    }

    public static Clipboard getSystemClipboard() {
        return awtToolkit.getSystemClipboard();
    }

    public static boolean highResDisplay() {
        if (highResProp == null) {
            highResProp = Toolkit.checkRetina();
        }
        return highResProp;
    }

    private static boolean checkRetina() {
        if (Base.isMacOS()) {
            if (System.getProperty("java.vendor").contains("Apple")) {
                Float prop = (Float)awtToolkit.getDesktopProperty("apple.awt.contentScaleFactor");
                if (prop != null) {
                    return prop.floatValue() == 2.0f;
                }
            } else if (Base.isUsableOracleJava()) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = env.getDefaultScreenDevice();
                try {
                    Field field = device.getClass().getDeclaredField("scale");
                    if (field != null) {
                        field.setAccessible(true);
                        Object scale = field.get(device);
                        if (scale instanceof Integer && (Integer)scale == 2) {
                            return true;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static List<Font> getMonoFontList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        ArrayList<Font> outgoing = new ArrayList<Font>();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), Preferences.getBoolean("editor.antialias"), true);
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            double w;
            Font font = fontArray[n2];
            if (font.getStyle() == 0 && font.canDisplay('i') && font.canDisplay('M') && font.canDisplay(' ') && font.canDisplay('.') && (w = font.getStringBounds(" ", frc).getWidth()) == font.getStringBounds("i", frc).getWidth() && w == font.getStringBounds("M", frc).getWidth() && w == font.getStringBounds(".", frc).getWidth()) {
                outgoing.add(font);
            }
            ++n2;
        }
        return outgoing;
    }

    public static String[] getMonoFontFamilies() {
        HashSet<String> families = new HashSet<String>();
        for (Font font : Toolkit.getMonoFontList()) {
            families.add(font.getFamily());
        }
        return families.toArray(new String[0]);
    }

    public static String getMonoFontName() {
        if (monoFont == null) {
            Toolkit.getMonoFont(12, 0);
        }
        return monoFont.getName();
    }

    public static Font getMonoFont(int size, int style) {
        if (monoFont == null) {
            try {
                monoFont = Toolkit.createFont("SourceCodePro-Regular.ttf", size);
                monoBoldFont = Toolkit.createFont("SourceCodePro-Bold.ttf", size);
            }
            catch (Exception e) {
                Base.log("Could not load mono font", e);
                monoFont = new Font("Monospaced", 0, size);
                monoBoldFont = new Font("Monospaced", 1, size);
            }
        }
        if (style == 1) {
            if (size == monoBoldFont.getSize()) {
                return monoBoldFont;
            }
            return monoBoldFont.deriveFont((float)size);
        }
        if (size == monoFont.getSize()) {
            return monoFont;
        }
        return monoFont.deriveFont((float)size);
    }

    public static Font getSansFont(int size, int style) {
        if (sansFont == null) {
            try {
                sansFont = Toolkit.createFont("SourceSansPro-Regular.ttf", size);
                sansBoldFont = Toolkit.createFont("SourceSansPro-Semibold.ttf", size);
            }
            catch (Exception e) {
                Base.log("Could not load sans font", e);
                sansFont = new Font("SansSerif", 0, size);
                sansBoldFont = new Font("SansSerif", 1, size);
            }
        }
        if (style == 1) {
            if (size == sansBoldFont.getSize()) {
                return sansBoldFont;
            }
            return sansBoldFont.deriveFont((float)size);
        }
        if (size == sansFont.getSize()) {
            return sansFont;
        }
        return sansFont.deriveFont((float)size);
    }

    private static Font createFont(String filename, int size) throws IOException, FontFormatException {
        InputStream is = Base.getLibStream("fonts/" + filename);
        BufferedInputStream input = new BufferedInputStream(is);
        Font font = Font.createFont(0, input);
        input.close();
        return font.deriveFont((float)size);
    }

    static double getAscent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        return new TextLayout("H", g.getFont(), frc).getBounds().getHeight();
    }
}

