/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Editor;
import processing.app.Library;
import processing.app.Toolkit;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionFilter;
import processing.app.contrib.ContributionListPanel;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.ProgressMonitor;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;

public class ContributionManagerDialog {
    static final String ANY_CATEGORY = "All";
    JFrame dialog;
    String title;
    ContributionFilter filter;
    JComboBox categoryChooser;
    JScrollPane scrollPane;
    ContributionListPanel contributionListPanel;
    StatusPanel status;
    FilterField filterField;
    Editor editor;
    String category;
    ContributionListing contribListing;

    public ContributionManagerDialog(ContributionType type) {
        if (type == null) {
            this.title = "Update Manager";
            this.filter = ContributionType.createUpdateFilter();
        } else {
            this.title = String.valueOf(type.getTitle()) + " Manager";
            this.filter = type.createFilter();
        }
        this.contribListing = ContributionListing.getInstance();
        this.contributionListPanel = new ContributionListPanel(this, this.filter);
        this.contribListing.addContributionListener(this.contributionListPanel);
    }

    public boolean hasUpdates() {
        return this.contribListing.hasUpdates();
    }

    public void showFrame(Editor editor) {
        this.editor = editor;
        if (this.dialog == null) {
            this.dialog = new JFrame(this.title);
            Toolkit.setIcon(this.dialog);
            this.createComponents();
            this.registerDisposeListeners();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
            this.contributionListPanel.grabFocus();
        }
        this.dialog.setVisible(true);
        if (this.contribListing.hasDownloadedLatestList()) {
            this.updateContributionListing();
        } else {
            this.contribListing.downloadAvailableList(new ProgressMonitor(){

                @Override
                public void finished() {
                    super.finished();
                    ContributionManagerDialog.this.updateContributionListing();
                    ContributionManagerDialog.this.updateCategoryChooser();
                    if (this.error) {
                        if (this.exception instanceof SocketTimeoutException) {
                            ContributionManagerDialog.this.status.setErrorMessage("Connection timed out while downloading the contribution list.");
                        } else {
                            ContributionManagerDialog.this.status.setErrorMessage("Could not download the listof available contributions.");
                        }
                        this.exception.printStackTrace();
                    }
                }
            });
        }
    }

    protected void disposeFrame() {
        this.dialog.dispose();
        this.editor = null;
    }

    private void createComponents() {
        this.dialog.setResizable(true);
        Container pane = this.dialog.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 0));
        pane.add((Component)filterPanel, "North");
        filterPanel.add(Box.createHorizontalStrut(6));
        JLabel categoryLabel = new JLabel("Category:");
        filterPanel.add(categoryLabel);
        filterPanel.add(Box.createHorizontalStrut(5));
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.updateCategoryChooser();
        filterPanel.add(this.categoryChooser);
        this.categoryChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContributionManagerDialog.this.category = (String)ContributionManagerDialog.this.categoryChooser.getSelectedItem();
                if (ContributionManagerDialog.ANY_CATEGORY.equals(ContributionManagerDialog.this.category)) {
                    ContributionManagerDialog.this.category = null;
                }
                ContributionManagerDialog.this.filterLibraries(ContributionManagerDialog.this.category, ContributionManagerDialog.this.filterField.filters);
            }
        });
        filterPanel.add(Box.createHorizontalStrut(5));
        this.filterField = new FilterField();
        filterPanel.add(this.filterField);
        filterPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(300, 300));
        this.scrollPane.setViewportView(this.contributionListPanel);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        pane.add((Component)this.scrollPane, "Center");
        pane.add(Box.createHorizontalStrut(10), "West");
        pane.add(Box.createHorizontalStrut(10), "East");
        this.status = new StatusPanel();
        this.status.setBorder(new EmptyBorder(7, 7, 7, 7));
        pane.add((Component)this.status, "South");
        this.dialog.setMinimumSize(new Dimension(450, 400));
    }

    private void updateCategoryChooser() {
        if (this.categoryChooser != null) {
            this.categoryChooser.removeAllItems();
            ArrayList<String> categories = new ArrayList<String>(this.contribListing.getCategories(this.filter));
            Collections.sort(categories);
            boolean categoriesFound = false;
            this.categoryChooser.addItem(ANY_CATEGORY);
            for (String s : categories) {
                this.categoryChooser.addItem(s);
                if (s.equals("Unknown")) continue;
                categoriesFound = true;
            }
            this.categoryChooser.setEnabled(categoriesFound);
        }
    }

    private void registerDisposeListeners() {
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ContributionManagerDialog.this.disposeFrame();
            }
        });
        Toolkit.registerWindowCloseKeys(this.dialog.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContributionManagerDialog.this.disposeFrame();
            }
        });
        this.dialog.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    ContributionManagerDialog.this.disposeFrame();
                }
            }
        });
    }

    protected void filterLibraries(String category, List<String> filters) {
        List<Contribution> filteredLibraries = this.contribListing.getFilteredLibraryList(category, filters);
        this.contributionListPanel.filterLibraries(filteredLibraries);
    }

    protected void updateContributionListing() {
        if (this.editor != null) {
            ArrayList<Contribution> contributions = new ArrayList<Contribution>();
            ArrayList<Library> libraries = new ArrayList<Library>(this.editor.getMode().contribLibraries);
            contributions.addAll(libraries);
            ArrayList<ToolContribution> tools = this.editor.contribTools;
            contributions.addAll(tools);
            ArrayList<ModeContribution> modes = this.editor.getBase().getModeContribs();
            contributions.addAll(modes);
            this.contribListing.updateInstalledList(contributions);
        }
    }

    protected void setFilterText(String filter) {
        if (filter == null || filter.isEmpty()) {
            this.filterField.setText("");
            this.filterField.showingHint = true;
        } else {
            this.filterField.setText(filter);
            this.filterField.showingHint = false;
        }
        this.filterField.applyFilter();
    }

    public boolean hasAlreadyBeenOpened() {
        return this.dialog != null;
    }

    class FilterField
    extends JTextField {
        static final String filterHint = "Filter your search...";
        boolean showingHint;
        List<String> filters;

        public FilterField() {
            super(filterHint);
            this.showingHint = true;
            this.filters = new ArrayList<String>();
            this.updateStyle();
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (((FilterField)FilterField.this).ContributionManagerDialog.this.filterField.getText().isEmpty()) {
                        FilterField.this.showingHint = true;
                    }
                    FilterField.this.updateStyle();
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (FilterField.this.showingHint) {
                        FilterField.this.showingHint = false;
                        ((FilterField)FilterField.this).ContributionManagerDialog.this.filterField.setText("");
                    }
                    FilterField.this.updateStyle();
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }
            });
        }

        public void applyFilter() {
            String filter = ContributionManagerDialog.this.filterField.getFilterText();
            filter = filter.toLowerCase();
            filter = filter.replaceAll("[^\\x30-\\x39^\\x61-\\x7a^\\x3a]", " ");
            this.filters = Arrays.asList(filter.split(" "));
            ContributionManagerDialog.this.filterLibraries(ContributionManagerDialog.this.category, this.filters);
        }

        public String getFilterText() {
            return this.showingHint ? "" : this.getText();
        }

        public void updateStyle() {
            if (this.showingHint) {
                this.setText(filterHint);
                this.setForeground(Color.gray);
                this.setFont(this.getFont().deriveFont(2));
            } else {
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setFont(this.getFont().deriveFont(0));
            }
        }
    }
}

