/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Library;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionFilter;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;

public enum ContributionType {
    LIBRARY,
    TOOL,
    MODE;


    public String toString() {
        switch (this) {
            case LIBRARY: {
                return "library";
            }
            case TOOL: {
                return "tool";
            }
            case MODE: {
                return "mode";
            }
        }
        return null;
    }

    public String getTitle() {
        String s = this.toString();
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public String getFolderName() {
        switch (this) {
            case LIBRARY: {
                return "libraries";
            }
            case TOOL: {
                return "tools";
            }
            case MODE: {
                return "modes";
            }
        }
        return null;
    }

    public File createTempFolder() throws IOException {
        return Base.createTempFolder(this.toString(), "tmp", this.getSketchbookFolder());
    }

    public boolean isTempFolderName(String name) {
        return name.startsWith(this.toString()) && name.endsWith("tmp");
    }

    public static ContributionType fromName(String s) {
        if (s != null) {
            if ("library".equalsIgnoreCase(s)) {
                return LIBRARY;
            }
            if ("tool".equalsIgnoreCase(s)) {
                return TOOL;
            }
            if ("mode".equalsIgnoreCase(s)) {
                return MODE;
            }
        }
        return null;
    }

    public File getSketchbookFolder() {
        switch (this) {
            case LIBRARY: {
                return Base.getSketchbookLibrariesFolder();
            }
            case TOOL: {
                return Base.getSketchbookToolsFolder();
            }
            case MODE: {
                return Base.getSketchbookModesFolder();
            }
        }
        return null;
    }

    boolean isCandidate(File potential) {
        return potential.isDirectory() && new File(potential, this.toString()).exists() && !this.isTempFolderName(potential.getName());
    }

    File[] listCandidates(File folder) {
        return folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File potential) {
                return ContributionType.this.isCandidate(potential);
            }
        });
    }

    File findCandidate(File folder) {
        File[] folders = this.listCandidates(folder);
        if (folders.length == 0) {
            return null;
        }
        if (folders.length > 1) {
            Base.log("More than one " + this.toString() + " found inside " + folder.getAbsolutePath());
        }
        return folders[0];
    }

    boolean requiresRestart() {
        return this == TOOL || this == MODE;
    }

    LocalContribution load(Base base, File folder) {
        switch (this) {
            case LIBRARY: {
                return Library.load(folder);
            }
            case TOOL: {
                return ToolContribution.load(folder);
            }
            case MODE: {
                return ModeContribution.load(base, folder);
            }
        }
        return null;
    }

    ArrayList<LocalContribution> listContributions(Editor editor) {
        ArrayList<LocalContribution> contribs = new ArrayList<LocalContribution>();
        switch (this) {
            case LIBRARY: {
                contribs.addAll(editor.getMode().contribLibraries);
                break;
            }
            case TOOL: {
                contribs.addAll(editor.contribTools);
                break;
            }
            case MODE: {
                contribs.addAll(editor.getBase().getModeContribs());
            }
        }
        return contribs;
    }

    File getBackupFolder() {
        return new File(this.getSketchbookFolder(), "old");
    }

    File createBackupFolder(StatusPanel status) {
        File backupFolder = this.getBackupFolder();
        if (!backupFolder.exists() && !backupFolder.mkdirs()) {
            status.setErrorMessage("Could not create a backup folder in the sketchbook " + this.toString() + " folder.");
            return null;
        }
        return backupFolder;
    }

    ContributionFilter createFilter() {
        return new ContributionFilter(){

            @Override
            public boolean matches(Contribution contrib) {
                return contrib.getType() == ContributionType.this;
            }
        };
    }

    static ContributionFilter createUpdateFilter() {
        return new ContributionFilter(){

            @Override
            public boolean matches(Contribution contrib) {
                if (contrib instanceof LocalContribution) {
                    return ContributionListing.getInstance().hasUpdates(contrib);
                }
                return false;
            }
        };
    }
}

