/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Mode;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;

public class ModeContribution
extends LocalContribution {
    private Mode mode;

    public static ModeContribution load(Base base, File folder) {
        return ModeContribution.load(base, folder, null);
    }

    public static ModeContribution load(Base base, File folder, String searchName) {
        try {
            return new ModeContribution(base, folder, searchName);
        }
        catch (LocalContribution.IgnorableException ig) {
            Base.log(ig.getMessage());
        }
        catch (Throwable err) {
            if (searchName == null) {
                err.printStackTrace();
            }
            Base.log("ModeContribution.load() failed for " + searchName, err);
        }
        return null;
    }

    private ModeContribution(Base base, File folder, String className) throws Exception {
        super(folder);
        className = this.initLoader(className);
        if (className != null) {
            Class<?> modeClass = this.loader.loadClass(className);
            Constructor<?> con = modeClass.getConstructor(Base.class, File.class);
            this.mode = (Mode)con.newInstance(base, folder);
            this.mode.setClassLoader(this.loader);
            if (base != null) {
                this.mode.setupGUI();
            }
        }
    }

    public static void loadMissing(Base base) {
        String usemode;
        File modesFolder = Base.getSketchbookModesFolder();
        ArrayList<ModeContribution> contribModes = base.getModeContribs();
        HashMap<File, ModeContribution> existing = new HashMap<File, ModeContribution>();
        for (ModeContribution contrib : contribModes) {
            existing.put(contrib.getFolder(), contrib);
        }
        File[] potential = ContributionType.MODE.listCandidates(modesFolder);
        if (potential != null) {
            File[] fileArray = potential;
            int n = potential.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                if (!existing.containsKey(folder)) {
                    try {
                        contribModes.add(new ModeContribution(base, folder, null));
                    }
                    catch (LocalContribution.IgnorableException ig) {
                        Base.log(ig.getMessage());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        if ((usemode = System.getProperty("usemode")) != null) {
            String[] modeinfo = usemode.split(":", 2);
            String modeClass = modeinfo[0];
            String modeResourcePath = modeinfo[1];
            System.err.println("Attempting to load " + modeClass + " with resources at " + modeResourcePath);
            contribModes.add(ModeContribution.load(base, new File(modeResourcePath), modeClass));
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public ContributionType getType() {
        return ContributionType.MODE;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ModeContribution)) {
            return false;
        }
        ModeContribution other = (ModeContribution)o;
        return this.loader.equals(other.loader) && this.mode.equals(other.getMode());
    }
}

