/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import processing.app.About;
import processing.app.Base;
import processing.app.Toolkit;
import processing.core.PApplet;

public class ThinkDifferent
implements ApplicationListener {
    private static ThinkDifferent adapter;
    private static Application application;
    private Base base;

    protected static void init(Base base) {
        if (application == null) {
            application = Application.getApplication();
        }
        if (adapter == null) {
            adapter = new ThinkDifferent(base);
        }
        application.addApplicationListener((ApplicationListener)adapter);
        application.setEnabledAboutMenu(true);
        application.setEnabledPreferencesMenu(true);
        JMenuBar defaultMenuBar = new JMenuBar();
        JMenu fileMenu = ThinkDifferent.buildFileMenu(base);
        defaultMenuBar.add(fileMenu);
        Base.defaultFileMenu = fileMenu;
        if (PApplet.javaVersion <= 1.6f) {
            try {
                application.setDefaultMenuBar(defaultMenuBar);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            JFrame offscreen = new JFrame();
            offscreen.setUndecorated(true);
            offscreen.setJMenuBar(defaultMenuBar);
            Dimension screen = Toolkit.getScreenSize();
            offscreen.setLocation(screen.width, screen.height);
            offscreen.setVisible(true);
        }
    }

    public ThinkDifferent(Base base) {
        this.base = base;
    }

    protected static JMenu buildFileMenu(final Base base) {
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = Toolkit.newJMenuItem("New", 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.handleNew();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.handleOpenPrompt();
            }
        });
        fileMenu.add(item);
        fileMenu.add(base.getSketchbookMenu());
        item = Toolkit.newJMenuItemShift("Examples...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.thinkDifferentExamples();
            }
        });
        fileMenu.add(item);
        return fileMenu;
    }

    public void handleAbout(ApplicationEvent ae) {
        if (this.base == null) {
            throw new IllegalStateException("handleAbout: Base instance detached from listener");
        }
        ae.setHandled(true);
        new About(null);
    }

    public void handlePreferences(ApplicationEvent ae) {
        if (this.base == null) {
            throw new IllegalStateException("handlePreferences: Base instance detached from listener");
        }
        this.base.handlePrefs();
        ae.setHandled(true);
    }

    public void handleOpenApplication(ApplicationEvent ae) {
    }

    public void handleOpenFile(ApplicationEvent ae) {
        String filename = ae.getFilename();
        this.base.handleOpen(filename);
        ae.setHandled(true);
    }

    public void handlePrintFile(ApplicationEvent ae) {
    }

    public void handleQuit(ApplicationEvent ae) {
        if (this.base == null) {
            throw new IllegalStateException("handleQuit: Base instance detached from listener");
        }
        boolean result = this.base.handleQuit();
        ae.setHandled(result);
    }

    public void handleReOpenApplication(ApplicationEvent arg0) {
    }
}

