/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class InstallCommander
implements Tool {
    Editor editor;

    @Override
    public String getMenuTitle() {
        return "Install \u201cprocessing-java\u201d";
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        try {
            int result = JOptionPane.showConfirmDialog(this.editor, "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>Install processing-java for all users?</b><p>This will install the processing-java program, which is capable of building and running Java Mode sketches from the command line. Click \u201cYes\u201d to install it for all users (an administrator password is required), or \u201cNo\u201d to place the program in your home directory. If you rename or move Processing.app, you'll need to reinstall the tool.</p>", "Commander", 1, 3);
            if (result == 2) {
                return;
            }
            File file = File.createTempFile("processing", "commander");
            PrintWriter writer = PApplet.createWriter((File)file);
            writer.println("#!/bin/sh");
            String[] jarList = new String[]{"pde.jar", "antlr.jar", "jna.jar", "ant.jar", "ant-launcher.jar", "org-netbeans-swing-outline.jar", "com.ibm.icu_4.4.2.v20110823.jar", "jdi.jar", "jdimodel.jar", "org.eclipse.osgi_3.8.1.v20120830-144521.jar", "core/library/core.jar"};
            String classPath = PApplet.join((String[])jarList, (String)":");
            String javaRoot = Base.getContentFile(".").getCanonicalPath();
            writer.println("cd \"" + javaRoot + "\" && " + Base.getJavaPath() + " -Djna.nosys=true" + " -cp \"" + classPath + "\"" + " processing.mode.java.Commander \"$@\"");
            writer.flush();
            writer.close();
            file.setExecutable(true);
            String sourcePath = file.getAbsolutePath();
            if (result == 0) {
                String targetPath = "/usr/bin/processing-java";
                String shellScript = "/bin/mv " + sourcePath + " " + targetPath;
                String appleScript = "do shell script \"" + shellScript + "\" with administrator privileges";
                PApplet.exec((String[])new String[]{"osascript", "-e", appleScript});
            } else if (result == 1) {
                File targetFile = new File(System.getProperty("user.home"), "processing-java");
                String targetPath = targetFile.getAbsolutePath();
                if (targetFile.exists()) {
                    Base.showWarning("File Already Exists", "The processing-java program already exists at:\n" + targetPath + "\n" + "Please remove it and try again.", null);
                } else {
                    PApplet.exec((String[])new String[]{"mv", sourcePath, targetPath});
                }
            }
            this.editor.statusNotice("Finished.");
        }
        catch (IOException e) {
            Base.showWarning("Error while installing", "An error occurred and the tools were not installed.", e);
        }
    }
}

