/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.About;
import processing.app.Base;
import processing.app.ColorChooser;
import processing.app.Editor;
import processing.app.EditorState;
import processing.app.EditorToolbar;
import processing.app.Formatter;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.app.Toolkit;
import processing.mode.java.AutoFormat;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaToolbar;
import processing.mode.java.PdeKeyListener;
import processing.mode.java.runner.Runner;

public class JavaEditor
extends Editor {
    JavaMode jmode;
    PdeKeyListener listener;
    private Runner runtime;

    protected JavaEditor(Base base, String path, EditorState state, Mode mode) {
        super(base, path, state, mode);
        this.listener = new PdeKeyListener(this, this.textarea);
        this.jmode = (JavaMode)mode;
    }

    @Override
    public EditorToolbar createToolbar() {
        return new JavaToolbar(this, this.base);
    }

    @Override
    public Formatter createFormatter() {
        return new AutoFormat();
    }

    @Override
    public JMenu buildFileMenu() {
        String appTitle = JavaToolbar.getTitle(5, false);
        JMenuItem exportApplication = Toolkit.newJMenuItem(appTitle, 69);
        exportApplication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleExportApplication();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportApplication});
    }

    @Override
    public JMenu buildSketchMenu() {
        JMenuItem runItem = Toolkit.newJMenuItem(JavaToolbar.getTitle(0, false), 82);
        runItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleRun();
            }
        });
        JMenuItem presentItem = Toolkit.newJMenuItemShift(JavaToolbar.getTitle(0, true), 82);
        presentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handlePresent();
            }
        });
        JMenuItem stopItem = new JMenuItem(JavaToolbar.getTitle(1, false));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleStop();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, stopItem});
    }

    @Override
    public JMenu buildHelpMenu() {
        JMenuItem item;
        JMenu menu = new JMenu("Help ");
        if (!Base.isMacOS()) {
            item = new JMenuItem("About Processing");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new About(JavaEditor.this);
                }
            });
            menu.add(item);
        }
        item = new JMenuItem("Environment");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("environment" + File.separator + "index.html");
            }
        });
        menu.add(item);
        item = new JMenuItem("Reference");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("index.html");
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItemShift("Find in Reference", 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JavaEditor.this.textarea.isSelectionActive()) {
                    JavaEditor.this.handleFindReference();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Online");
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem("Getting Started");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processing.org/learning/gettingstarted/");
            }
        });
        menu.add(item);
        item = new JMenuItem("Troubleshooting");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://wiki.processing.org/w/Troubleshooting");
            }
        });
        menu.add(item);
        item = new JMenuItem("Frequently Asked Questions");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://wiki.processing.org/w/FAQ");
            }
        });
        menu.add(item);
        item = new JMenuItem("The Processing Foundation");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processing.org/foundation/");
            }
        });
        menu.add(item);
        item = new JMenuItem("Visit Processing.org");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processing.org/");
            }
        });
        menu.add(item);
        return menu;
    }

    @Override
    public String getCommentPrefix() {
        return "//";
    }

    public void handleExportApplication() {
        this.toolbar.activate(5);
        if (this.handleExportCheckModified()) {
            this.statusNotice("Exporting application...");
            try {
                if (this.exportApplicationPrompt()) {
                    Base.openFolder(this.sketch.getFolder());
                    this.statusNotice("Done exporting.");
                }
            }
            catch (Exception e) {
                this.statusNotice("Error during export.");
                e.printStackTrace();
            }
        }
        this.toolbar.deactivate(5);
    }

    protected boolean exportApplicationPrompt() throws IOException, SketchException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        String line1 = "Export to Application creates double-clickable,";
        String line2 = "standalone applications for the selected plaforms.";
        JLabel label1 = new JLabel(line1, 0);
        JLabel label2 = new JLabel(line2, 0);
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        panel.add(label1);
        panel.add(label2);
        panel.add(Box.createVerticalStrut(12));
        final JCheckBox windowsButton = new JCheckBox("Windows");
        windowsButton.setSelected(Preferences.getBoolean("export.application.platform.windows"));
        windowsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.windows", windowsButton.isSelected());
            }
        });
        final JCheckBox macosxButton = new JCheckBox("Mac OS X");
        macosxButton.setSelected(Preferences.getBoolean("export.application.platform.macosx"));
        macosxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.macosx", macosxButton.isSelected());
            }
        });
        final JCheckBox linuxButton = new JCheckBox("Linux");
        linuxButton.setSelected(Preferences.getBoolean("export.application.platform.linux"));
        linuxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.linux", linuxButton.isSelected());
            }
        });
        JPanel platformPanel = new JPanel();
        platformPanel.add(windowsButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(macosxButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(linuxButton);
        platformPanel.setBorder(new TitledBorder("Platforms"));
        platformPanel.setAlignmentX(0.0f);
        panel.add(platformPanel);
        int divWidth = platformPanel.getPreferredSize().width;
        int indent = 0;
        final JCheckBox showStopButton = new JCheckBox("Show a Stop button");
        showStopButton.setSelected(Preferences.getBoolean("export.application.stop"));
        showStopButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.stop", showStopButton.isSelected());
            }
        });
        showStopButton.setEnabled(Preferences.getBoolean("export.application.fullscreen"));
        showStopButton.setBorder(new EmptyBorder(3, 13 + indent, 6, 13));
        final JCheckBox fullScreenButton = new JCheckBox("Full Screen (Present mode)");
        fullScreenButton.setSelected(Preferences.getBoolean("export.application.fullscreen"));
        fullScreenButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean sal = fullScreenButton.isSelected();
                Preferences.setBoolean("export.application.fullscreen", sal);
                showStopButton.setEnabled(sal);
            }
        });
        fullScreenButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel presentPanel = new JPanel();
        presentPanel.setLayout(new BoxLayout(presentPanel, 1));
        Box fullScreenBox = Box.createHorizontalBox();
        fullScreenBox.add(fullScreenButton);
        fullScreenBox.add(new ColorPreference("run.present.bgcolor"));
        fullScreenBox.add(Box.createHorizontalStrut(10));
        fullScreenBox.add(Box.createHorizontalGlue());
        presentPanel.add(fullScreenBox);
        Box showStopBox = Box.createHorizontalBox();
        showStopBox.add(showStopButton);
        showStopBox.add(new ColorPreference("run.present.stop.color"));
        showStopBox.add(Box.createHorizontalStrut(10));
        showStopBox.add(Box.createHorizontalGlue());
        presentPanel.add(showStopBox);
        presentPanel.setBorder(new TitledBorder("Full Screen"));
        presentPanel.setAlignmentX(0.0f);
        panel.add(presentPanel);
        JPanel embedPanel = new JPanel();
        embedPanel.setLayout(new BoxLayout(embedPanel, 1));
        String platformName = null;
        if (Base.isMacOS()) {
            platformName = "Mac OS X";
        } else if (Base.isWindows()) {
            platformName = "Windows (" + Base.getNativeBits() + "-bit)";
        } else if (Base.isLinux()) {
            platformName = "Linux (" + Base.getNativeBits() + "-bit)";
        }
        boolean embed = Preferences.getBoolean("export.application.embed_java");
        final String embedWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">" + "Embedding Java will make the " + platformName + " application " + "larger, but it will be far more likely to work. " + "Users on other platforms will need to <a href=\"\">install Java 7</a>.";
        final String nopeWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">" + "Users on all platforms will have to install the latest " + "version of Java 7 from <a href=\"\">http://java.com/download</a>. " + "<br/>&nbsp;";
        final JLabel warningLabel = new JLabel(embed ? embedWarning : nopeWarning);
        warningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Base.openURL("http://java.com/download");
            }
        });
        warningLabel.setBorder(new EmptyBorder(3, 13 + indent, 3, 13));
        final JCheckBox embedJavaButton = new JCheckBox("Embed Java for " + platformName);
        embedJavaButton.setSelected(embed);
        embedJavaButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = embedJavaButton.isSelected();
                Preferences.setBoolean("export.application.embed_java", selected);
                if (selected) {
                    warningLabel.setText(embedWarning);
                } else {
                    warningLabel.setText(nopeWarning);
                }
            }
        });
        embedJavaButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        embedPanel.add(embedJavaButton);
        embedPanel.add(warningLabel);
        embedPanel.setBorder(new TitledBorder("Embed Java"));
        panel.add(embedPanel);
        if (Base.isMacOS()) {
            JPanel signPanel = new JPanel();
            signPanel.setLayout(new BoxLayout(signPanel, 1));
            signPanel.setBorder(new TitledBorder("Code Signing"));
            String thePain = "In recent versions of OS X, Apple has introduced the \u201cGatekeeper\u201d system, which makes it more difficult to run applications like those exported from Processing. ";
            thePain = new File("/usr/bin/codesign_allocate").exists() ? String.valueOf(thePain) + "This application will be \u201cself-signed\u201d which means that Finder may report that the application is from an \u201cunidentified developer\u201d. If the application will not run, try right-clicking the app and selecting Open from the pop-up menu. Or you can visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. " : String.valueOf(thePain) + "Gatekeeper requires applications to be \u201csigned\u201d, or they will be reported as damaged. To prevent this message, install Xcode (and the Command Line Tools) from the App Store, or visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. ";
            thePain = String.valueOf(thePain) + "To avoid the messages entirely, manually code sign your app. For more information: <a href=\"\">https://developer.apple.com/developer-id/</a>";
            JLabel area = new JLabel("<html><div width=\"" + divWidth + "\"><font size=\"2\">" + thePain + "</div></html>");
            area.setBorder(new EmptyBorder(3, 13, 3, 13));
            signPanel.add(area);
            signPanel.setAlignmentX(0.0f);
            area.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Base.openURL("https://developer.apple.com/developer-id/");
                }
            });
            panel.add(signPanel);
        }
        Object[] options = new String[]{"Export", "Cancel"};
        final JOptionPane optionPane = new JOptionPane(panel, -1, 0, null, options, options[0]);
        final JDialog dialog = new JDialog(this, "Export Application", true);
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        Rectangle bounds = this.getBounds();
        dialog.setLocation(bounds.x + (bounds.width - dialog.getSize().width) / 2, bounds.y + (bounds.height - dialog.getSize().height) / 2);
        dialog.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(options[0])) {
            return this.jmode.handleExportApplication(this.sketch);
        }
        if (value.equals(options[1]) || value.equals(new Integer(-1))) {
            this.statusNotice("Export to Application canceled.");
        }
        return false;
    }

    protected boolean handleExportCheckModified() {
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            int result = JOptionPane.showOptionDialog(this, "Save changes before export?", "Save", 2, 3, null, options, options[0]);
            if (result == 0) {
                this.handleSave(true);
            } else {
                this.statusNotice("Export canceled, changes must first be saved.");
                return false;
            }
        }
        return true;
    }

    public void handleRun() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JavaEditor.this.prepareRun();
                try {
                    JavaEditor.this.toolbar.activate(0);
                    JavaEditor.this.runtime = JavaEditor.this.jmode.handleRun(JavaEditor.this.sketch, JavaEditor.this);
                }
                catch (Exception e) {
                    JavaEditor.this.statusError(e);
                }
            }
        }).start();
    }

    public void handlePresent() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JavaEditor.this.prepareRun();
                try {
                    JavaEditor.this.toolbar.activate(0);
                    JavaEditor.this.runtime = JavaEditor.this.jmode.handlePresent(JavaEditor.this.sketch, JavaEditor.this);
                }
                catch (Exception e) {
                    JavaEditor.this.statusError(e);
                }
            }
        }).start();
    }

    public void handleStop() {
        this.toolbar.activate(1);
        try {
            if (this.runtime != null) {
                this.runtime.close();
                this.runtime = null;
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        this.toolbar.deactivate(0);
        this.toolbar.deactivate(1);
        this.toFront();
    }

    public void handleSave() {
        this.toolbar.activate(4);
        super.handleSave(true);
        this.toolbar.deactivate(4);
    }

    @Override
    public boolean handleSaveAs() {
        this.toolbar.activate(4);
        boolean result = super.handleSaveAs();
        this.toolbar.deactivate(4);
        return result;
    }

    @Override
    public void handleImportLibrary(String jarPath) {
        this.sketch.ensureExistence();
        if (this.mode.isDefaultExtension(this.sketch.getCurrentCode())) {
            this.sketch.setCurrentCode(0);
        }
        String[] list = Base.packageListFromClassPath(jarPath);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            buffer.append("import ");
            buffer.append(list[i]);
            buffer.append(".*;\n");
            ++i;
        }
        buffer.append('\n');
        buffer.append(this.getText());
        this.setText(buffer.toString());
        this.setSelection(0, 0);
        this.sketch.setModified(true);
    }

    @Override
    public void statusError(String what) {
        super.statusError(what);
        this.toolbar.deactivate(0);
    }

    @Override
    public void deactivateRun() {
        this.toolbar.deactivate(0);
    }

    public void deactivateExport() {
        this.toolbar.deactivate(5);
    }

    @Override
    public void internalCloseRunner() {
        this.handleStop();
    }

    class ColorPreference
    extends JPanel
    implements ActionListener {
        ColorChooser chooser;
        String prefName;

        public ColorPreference(String pref) {
            this.prefName = pref;
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(30, 20));
            this.setMaximumSize(new Dimension(30, 20));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Color color = Preferences.getColor(ColorPreference.this.prefName);
                    ColorPreference.this.chooser = new ColorChooser(JavaEditor.this, true, color, "Select", ColorPreference.this);
                    ColorPreference.this.chooser.show();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Preferences.getColor(this.prefName));
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.chooser.getColor();
            Preferences.setColor(this.prefName, color);
            this.repaint();
            this.chooser.hide();
        }
    }
}

