/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.File;
import java.io.IOException;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorState;
import processing.app.Library;
import processing.app.Mode;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.runner.Runner;

public class JavaMode
extends Mode {
    @Override
    public Editor createEditor(Base base, String path, EditorState state) {
        return new JavaEditor(base, path, state, this);
    }

    public JavaMode(Base base, File folder) {
        super(base, folder);
    }

    @Override
    public String getTitle() {
        return "Java";
    }

    @Override
    public File[] getExampleCategoryFolders() {
        return new File[]{new File(this.examplesFolder, "Basics"), new File(this.examplesFolder, "Topics"), new File(this.examplesFolder, "Demos"), new File(this.examplesFolder, "Books")};
    }

    @Override
    public String getDefaultExtension() {
        return "pde";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"pde", "java"};
    }

    @Override
    public String[] getIgnorable() {
        return new String[]{"applet", "application.macosx", "application.windows", "application.linux"};
    }

    @Override
    public Library getCoreLibrary() {
        if (this.coreLibrary == null) {
            File coreFolder = Base.getContentFile("core");
            this.coreLibrary = new Library(coreFolder);
        }
        return this.coreLibrary;
    }

    public Runner handleRun(Sketch sketch, RunnerListener listener) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(false);
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    runtime.launch(false);
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public Runner handlePresent(Sketch sketch, RunnerListener listener) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(false);
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    runtime.launch(true);
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public boolean handleExportApplication(Sketch sketch) throws SketchException, IOException {
        JavaBuild build = new JavaBuild(sketch);
        return build.exportApplication();
    }
}

